/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.lines;

import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.settings.BasicSettingsStorage;
import de.erichseifert.gral.plots.settings.SettingChangeEvent;
import de.erichseifert.gral.plots.settings.SettingsListener;
import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.GeometryUtils;
import de.erichseifert.gral.util.MathUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.io.IOException;
import java.io.ObjectInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLineRenderer2D
extends BasicSettingsStorage
implements LineRenderer,
SettingsListener {
    private static final long serialVersionUID = -4172505541305453796L;

    public AbstractLineRenderer2D() {
        this.addSettingsListener(this);
        this.setSettingDefault(STROKE, new BasicStroke(1.5f));
        this.setSettingDefault(GAP, 0.0);
        this.setSettingDefault(GAP_ROUNDED, false);
        this.setSettingDefault(COLOR, Color.BLACK);
    }

    protected Shape punch(Shape shape, Iterable<DataPoint> object) {
        if (shape == null) {
            return null;
        }
        shape = ((Stroke)this.getSetting(LineRenderer.STROKE)).createStrokedShape(shape);
        double d = DataUtils.getValueOrDefault((Number)this.getSetting(GAP), 0.0);
        if (!MathUtils.isCalculatable(d) || d == 0.0) {
            return shape;
        }
        boolean bl = (Boolean)this.getSetting(GAP_ROUNDED);
        shape = new Area(shape);
        object = object.iterator();
        while (object.hasNext()) {
            DataPoint dataPoint = (DataPoint)object.next();
            shape = GeometryUtils.punch((Area)shape, d, bl, dataPoint.position.getPoint2D(), dataPoint.shape);
        }
        return shape;
    }

    @Override
    public void settingChanged(SettingChangeEvent settingChangeEvent) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.addSettingsListener(this);
    }
}

