/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.AbstractDataSource;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcData
extends AbstractDataSource {
    private static final long serialVersionUID = 5196527358266585129L;
    private Class<? extends Comparable<?>>[] a;
    private final Connection b;
    private final String c;
    private boolean d;
    private int e;
    private ResultSet f;
    private int g;

    public JdbcData(Connection object, String string, boolean bl) {
        super(new Class[0]);
        this.b = object;
        this.c = string;
        this.setBuffered(bl);
        this.a = null;
        try {
            object = this;
            object = ((JdbcData)object).b.prepareStatement("SELECT * FROM " + ((JdbcData)object).c + " WHERE 1 = 0").getMetaData();
            int n = object.getColumnCount();
            Class[] classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                int n2 = object.getColumnType(i + 1);
                Class clazz = null;
                switch (n2) {
                    case -6: {
                        clazz = Byte.class;
                        break;
                    }
                    case 5: {
                        clazz = Short.class;
                        break;
                    }
                    case 4: {
                        clazz = Integer.class;
                        break;
                    }
                    case -5: {
                        clazz = Long.class;
                        break;
                    }
                    case 7: {
                        clazz = Float.class;
                        break;
                    }
                    case 6: 
                    case 8: {
                        clazz = Double.class;
                        break;
                    }
                    case 91: {
                        clazz = Date.class;
                        break;
                    }
                    case 92: {
                        clazz = Time.class;
                        break;
                    }
                    case 93: {
                        clazz = Timestamp.class;
                        break;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        clazz = String.class;
                    }
                }
                classArray[i] = clazz;
            }
            this.a = classArray;
            return;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return;
        }
    }

    public JdbcData(Connection connection, String string) {
        this(connection, string, true);
    }

    @Override
    public Comparable<?> get(int n, int n2) {
        try {
            ResultSet resultSet = this.f;
            if (!this.isBuffered() || resultSet == null) {
                resultSet = this.b.prepareStatement("SELECT * FROM " + this.c, 1005, 1007).executeQuery();
                if (this.isBuffered()) {
                    this.f = resultSet;
                }
            }
            if (!this.isBuffered() || n2 != this.g) {
                resultSet.absolute(n2 + 1);
                this.g = n2;
            }
            int n3 = n;
            ResultSet resultSet2 = resultSet;
            Class<? extends Comparable<?>> clazz = this.a[n3];
            ++n3;
            if (Byte.class.equals(clazz)) {
                return resultSet2.getByte(n3);
            }
            if (Short.class.equals(clazz)) {
                return resultSet2.getShort(n3);
            }
            if (Integer.class.equals(clazz)) {
                return resultSet2.getInt(n3);
            }
            if (Long.class.equals(clazz)) {
                return resultSet2.getLong(n3);
            }
            if (Float.class.equals(clazz)) {
                return Float.valueOf(resultSet2.getFloat(n3));
            }
            if (Double.class.equals(clazz)) {
                return resultSet2.getDouble(n3);
            }
            if (Date.class.equals(clazz)) {
                return resultSet2.getDate(n3);
            }
            if (Time.class.equals(clazz)) {
                return resultSet2.getTime(n3);
            }
            if (Timestamp.class.equals(clazz)) {
                return resultSet2.getTimestamp(n3);
            }
            if (String.class.equals(clazz)) {
                return resultSet2.getString(n3);
            }
            return null;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    @Override
    public int getColumnCount() {
        if (this.a != null) {
            return this.a.length;
        }
        return 0;
    }

    @Override
    public Class<? extends Comparable<?>>[] getColumnTypes() {
        return Arrays.copyOf(this.a, this.a.length);
    }

    @Override
    public int getRowCount() {
        int n = this.e;
        if (!this.isBuffered() || n < 0) {
            try {
                ResultSet resultSet = this.b.prepareStatement("SELECT COUNT(*) FROM " + this.c, 1005, 1007).executeQuery();
                if (resultSet.first()) {
                    this.e = n = resultSet.getInt(1);
                } else {
                    n = 0;
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                n = 0;
            }
        }
        return n;
    }

    public boolean isBuffered() {
        return this.d;
    }

    public void setBuffered(boolean bl) {
        this.d = bl;
        this.e = -1;
        this.f = null;
        this.g = -1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException("JDBC data sources cannot be serialized.");
    }
}

