/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.tasks;

import net.sf.nachocalendar.components.CalendarPanel;
import net.sf.nachocalendar.components.DateField;
import net.sf.nachocalendar.components.DatePanel;
import net.sf.nachocalendar.components.DefaultDayRenderer;
import net.sf.nachocalendar.components.DefaultHeaderRenderer;
import net.sf.nachocalendar.tasks.TaskDataModel;
import net.sf.nachocalendar.tasks.TaskDecorator;

public final class TaskCalendarFactory {
    private TaskCalendarFactory() {
    }

    public static DateField createDateField() {
        DateField retorno = new DateField();
        TaskCalendarFactory.configureDateField(retorno);
        return retorno;
    }

    private static void configureDateField(DateField df) {
        df.setModel(new TaskDataModel());
        df.setRenderer(new TaskDecorator(new DefaultDayRenderer()));
        df.setHeaderRenderer(new DefaultHeaderRenderer());
    }

    public static CalendarPanel createCalendarPanel() {
        CalendarPanel retorno = new CalendarPanel();
        TaskCalendarFactory.configureCalendarPanel(retorno);
        return retorno;
    }

    public static CalendarPanel createCalendarPanel(int quantity, int orientation) {
        CalendarPanel retorno = new CalendarPanel(quantity, orientation);
        TaskCalendarFactory.configureCalendarPanel(retorno);
        return retorno;
    }

    public static CalendarPanel createCalendarPanel(int quantity) {
        CalendarPanel retorno = new CalendarPanel(quantity, 1);
        TaskCalendarFactory.configureCalendarPanel(retorno);
        return retorno;
    }

    private static void configureCalendarPanel(CalendarPanel cp) {
        cp.setModel(new TaskDataModel());
        cp.setRenderer(new TaskDecorator(new DefaultDayRenderer()));
        cp.setHeaderRenderer(new DefaultHeaderRenderer());
    }

    public static DatePanel createDatePanel() {
        DatePanel retorno = new DatePanel();
        TaskCalendarFactory.configureDatePanel(retorno);
        return retorno;
    }

    public static DatePanel createDatePanel(boolean showWeekNumbers) {
        DatePanel retorno = new DatePanel(showWeekNumbers);
        TaskCalendarFactory.configureDatePanel(retorno);
        return retorno;
    }

    private static void configureDatePanel(DatePanel dp) {
        dp.setModel(new TaskDataModel());
        dp.setRenderer(new TaskDecorator(new DefaultDayRenderer()));
        dp.setHeaderRenderer(new DefaultHeaderRenderer());
    }
}

