/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.Color;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JList;
import net.sf.nachocalendar.components.DayPanel;
import net.sf.nachocalendar.components.DayRenderer;

public class DefaultDayRenderer
extends JLabel
implements DayRenderer {
    private Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private Color selectedbg;
    private Color unselectedbg;
    private Color selectedfg;
    private Color unselectedfg;
    private Color notworking;
    private Date date;

    public DefaultDayRenderer() {
        JList jl = new JList();
        this.unselectedbg = Color.white;
        this.unselectedfg = jl.getForeground();
        this.selectedbg = jl.getSelectionBackground();
        this.selectedfg = jl.getSelectionForeground();
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setOpaque(true);
        this.notworking = new Color(240, 240, 255);
    }

    public Component getDayRenderer(DayPanel daypanel, Date day, Object data, boolean selected, boolean working, boolean enabled) {
        this.date = day;
        if (selected) {
            this.setBackground(this.selectedbg);
        } else if (working) {
            this.setBackground(this.unselectedbg);
        } else {
            this.setBackground(this.notworking);
        }
        if (working) {
            if (selected) {
                this.setForeground(this.selectedfg);
            } else {
                this.setForeground(this.unselectedfg);
            }
        } else if (selected) {
            this.setForeground(this.selectedfg);
        } else {
            this.setForeground(Color.GRAY);
        }
        this.cal.setTime(day);
        this.setText(Integer.toString(this.cal.get(5)));
        if (!enabled) {
            this.setForeground(Color.lightGray);
            return this;
        }
        if (data != null) {
            this.setForeground(Color.RED);
        } else {
            daypanel.setToolTipText(null);
        }
        return this;
    }
}

