/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar;

import javax.swing.text.DateFormatter;
import net.sf.nachocalendar.components.CalendarPanel;
import net.sf.nachocalendar.components.DateField;
import net.sf.nachocalendar.components.DatePanel;
import net.sf.nachocalendar.components.DefaultDayRenderer;
import net.sf.nachocalendar.components.DefaultHeaderRenderer;

public final class CalendarFactory {
    private CalendarFactory() {
    }

    public static DateField createDateField() {
        DateField retorno = new DateField();
        CalendarFactory.configureDateField(retorno);
        return retorno;
    }

    public static DateField createDateField(DateFormatter formatter) {
        DateField retorno = new DateField(formatter, false);
        CalendarFactory.configureDateField(retorno);
        return retorno;
    }

    private static void configureDateField(DateField df) {
        df.setRenderer(new DefaultDayRenderer());
        df.setHeaderRenderer(new DefaultHeaderRenderer());
    }

    public static CalendarPanel createCalendarPanel() {
        CalendarPanel retorno = new CalendarPanel();
        CalendarFactory.configureCalendarPanel(retorno);
        return retorno;
    }

    public static CalendarPanel createCalendarPanel(int quantity, int orientation) {
        CalendarPanel retorno = new CalendarPanel(quantity, orientation);
        CalendarFactory.configureCalendarPanel(retorno);
        return retorno;
    }

    public static CalendarPanel createCalendarPanel(int quantity) {
        CalendarPanel retorno = new CalendarPanel(quantity, 1);
        CalendarFactory.configureCalendarPanel(retorno);
        return retorno;
    }

    private static void configureCalendarPanel(CalendarPanel cp) {
        cp.setRenderer(new DefaultDayRenderer());
        cp.setHeaderRenderer(new DefaultHeaderRenderer());
    }

    private static void configureDatePanel(DatePanel dp) {
        dp.setHeaderRenderer(new DefaultHeaderRenderer());
        dp.setRenderer(new DefaultDayRenderer());
    }

    public static DatePanel createDatePanel() {
        DatePanel retorno = new DatePanel();
        CalendarFactory.configureDatePanel(retorno);
        return retorno;
    }

    public static DatePanel createDatePanel(boolean showWeekNumbers) {
        DatePanel retorno = new DatePanel(showWeekNumbers);
        CalendarFactory.configureDatePanel(retorno);
        return retorno;
    }
}

