/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task.dataSetBrowser;

import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetTreeCellRenderer;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetTreeModel;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.SeismogramSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.SeismogramTreeNode;
import edu.sc.seis.gee.task.dataSetBrowser.TreeSelectionMediator;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DataSetBrowser
extends JPanel
implements Task {
    private DataSetTreeModel treeModel;
    private JTree tree = new JTree();
    private TreeSelectionMediator mediator;

    public DataSetBrowser() {
        this.setLayout(new BorderLayout());
        this.tree.setCellRenderer(new DataSetTreeCellRenderer());
        this.mediator = new TreeSelectionMediator();
        this.tree.addTreeSelectionListener(this.mediator);
        this.tree.setMinimumSize(new Dimension(100, 100));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
    }

    @Override
    public void configure(Map params) {
    }

    @Override
    public void invoke() {
        if (this.treeModel == null) {
            this.refresh();
            this.removeAll();
            this.add(new JScrollPane(this.tree));
            this.revalidate();
        }
    }

    @Override
    public void destroy() {
        this.treeModel = null;
    }

    public void refresh() {
        this.treeModel = new DataSetTreeModel();
        this.tree.setModel(this.treeModel);
    }

    public TreePath[] getSelectionPaths() {
        return this.tree.getSelectionPaths();
    }

    public void addSeismogramSelectedListener(SeismogramSelectedListener l) {
        this.mediator.addSeismogramSelectedListener(l);
    }

    public void removeSeismogramSelectedListener(SeismogramSelectedListener l) {
        this.mediator.removeSeismogramSelectedListener(l);
    }

    public void addParameterSelectedListener(ParameterSelectedListener l) {
        this.mediator.addParameterSelectedListener(l);
    }

    public void removeParameterSelectedListener(ParameterSelectedListener l) {
        this.mediator.removeParameterSelectedListener(l);
    }

    public void addDataSetSelectedListener(DataSetSelectedListener l) {
        this.mediator.addDataSetSelectedListener(l);
    }

    public void removeDataSetSelectedListener(DataSetSelectedListener l) {
        this.mediator.removeDataSetSelectedListener(l);
    }

    public DataSet[] getSelectedDataSets() {
        TreePath[] paths = this.tree.getSelectionPaths();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (paths == null) {
            return new DataSet[0];
        }
        for (int counter = 0; counter < paths.length; ++counter) {
            if (!(paths[counter].getLastPathComponent() instanceof DataSet)) continue;
            arrayList.add(paths[counter].getLastPathComponent());
        }
        return arrayList.toArray(new DataSet[arrayList.size()]);
    }

    public DataSet[] getOpenDataSets() {
        int rows = this.tree.getRowCount();
        HashSet<DataSet> dataSets = new HashSet<DataSet>();
        for (int i = 0; i < rows; ++i) {
            TreePath path = this.tree.getPathForRow(i);
            if (!(path.getLastPathComponent() instanceof SeismogramTreeNode)) continue;
            SeismogramTreeNode cur = (SeismogramTreeNode)path.getLastPathComponent();
            dataSets.add(cur.getDataSet());
        }
        DataSet[] dsArray = new DataSet[dataSets.size()];
        return dataSets.toArray(dsArray);
    }

    public DataSetSeismogram[] getSelectedSeismograms() {
        TreePath[] paths = this.tree.getSelectionPaths();
        ArrayList<DataSetSeismogram> arrayList = new ArrayList<DataSetSeismogram>();
        if (paths == null) {
            return new DataSetSeismogram[0];
        }
        for (int counter = 0; counter < paths.length; ++counter) {
            if (!(paths[counter].getLastPathComponent() instanceof SeismogramTreeNode)) continue;
            SeismogramTreeNode node = (SeismogramTreeNode)paths[counter].getLastPathComponent();
            arrayList.add(node.getSeismogram());
        }
        DataSetSeismogram[] seismograms = new DataSetSeismogram[arrayList.size()];
        seismograms = arrayList.toArray(seismograms);
        return seismograms;
    }

    public void expandLastRow() {
        this.tree.expandRow(this.tree.getRowCount() - 1);
    }
}

