/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeDecimalFormat;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.display.TimeScaleCalc;
import edu.sc.seis.fissuresUtil.display.UnitDisplayUtil;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.TimeAmpLabel;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseAdapter;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.gee.task.GlobalToolBar;
import edu.sc.seis.gee.task.Task;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Category;

public class TimeAmpLabelTask
extends SDMouseAdapter
implements Task {
    private TimeAmpLabel label = new TimeAmpLabel();
    private UnitRangeImpl curAmpRange;
    public static final ThreadSafeDecimalFormat defaultFormatter = new ThreadSafeDecimalFormat(" 0.000E0;-0.000E0");
    private ThreadSafeDecimalFormat currentFormatter;
    private ThreadSafeSimpleDateFormat fullOutput;
    private ThreadSafeSimpleDateFormat output = this.fullOutput = new ThreadSafeSimpleDateFormat("HH:mm:ss.SSS MM/dd/yyyy");
    private ThreadSafeSimpleDateFormat relativeOutput = new ThreadSafeSimpleDateFormat("mm:ss.SSS");
    private Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static Category logger = Category.getInstance((String)TimeAmpLabelTask.class.getName());

    @Override
    public void configure(Map params) {
    }

    @Override
    public void invoke() {
        GlobalToolBar.add(this);
    }

    @Override
    public void destroy() {
        GlobalToolBar.remove(this);
    }

    public void mouseMoved(SDMouseEvent me) {
        this.label.setText(this.formatInfo(me.getTime(), me.getAmp(), me.getDisplay().getAmpConfig().getAmp()));
        me.getDisplay().repaint();
    }

    public void mouseEntered(SDMouseEvent me) {
        me.getDisplay().add((Drawable)this.label);
        this.mouseMoved(me);
    }

    public void mouseExited(SDMouseEvent me) {
        me.getDisplay().remove((Drawable)this.label);
        me.getDisplay().repaint();
    }

    private String[] formatInfo(MicroSecondDate newTime, QuantityImpl newAmp, UnitRangeImpl ampRange) {
        if (this.curAmpRange != ampRange) {
            double absMin;
            this.currentFormatter = defaultFormatter;
            double absMax = Math.abs(ampRange.getMaxValue());
            double maxVal = absMax / 10.0 > (absMin = Math.abs(ampRange.getMinValue())) ? absMax : absMin;
            if (maxVal >= 1.0) {
                StringBuffer formatPattern = new StringBuffer(" 0.00;-0.00");
                while (maxVal > 10.0) {
                    formatPattern.insert(1, "0");
                    formatPattern.insert(formatPattern.length() - 4, "0");
                    maxVal /= 10.0;
                }
                this.currentFormatter = new ThreadSafeDecimalFormat(formatPattern.toString());
            }
            this.curAmpRange = ampRange;
        }
        double newAmpVal = newAmp.getValue();
        String amp = "";
        if (newAmpVal != Double.NaN) {
            String ampString = "Amplitude:";
            ampString = ampString + this.currentFormatter.format(newAmpVal);
            amp = ampString + " " + UnitDisplayUtil.getNameForUnit((UnitImpl)newAmp.getUnit());
        }
        String time = "";
        this.calendar.setTime((Date)newTime);
        this.output = TimeScaleCalc.roundTheEpoch.intersects(newTime) ? this.relativeOutput : this.fullOutput;
        StringBuffer timeBuffer = new StringBuffer(amp.length());
        if (this.output.format(this.calendar.getTime()).length() == 21) {
            timeBuffer.append(this.output.format(this.calendar.getTime()) + "00");
        } else if (this.output.format(this.calendar.getTime()).length() == 22) {
            timeBuffer.append(this.output.format(this.calendar.getTime()) + "0");
        } else {
            timeBuffer.append(this.output.format(this.calendar.getTime()));
        }
        int numSpaces = amp.length() - timeBuffer.length() - 10;
        if (numSpaces < 0) {
            numSpaces = 0;
        }
        StringBuffer spaces = new StringBuffer(numSpaces);
        for (int i = 0; i < numSpaces; ++i) {
            spaces.append(" ");
        }
        timeBuffer.insert(0, spaces);
        if (this.output == this.relativeOutput) {
            timeBuffer.insert(0, "Relative Time:");
        } else {
            timeBuffer.insert(0, "Time:");
        }
        time = timeBuffer.toString();
        String[] timeAmp = new String[]{time, amp};
        return timeAmp;
    }
}

