/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.DefaultParamNames;
import edu.sc.seis.gee.configurator.MenuHandler;
import edu.sc.seis.gee.configurator.ToolBarHandler;
import edu.sc.seis.gee.configurator.ToolBarItem;
import edu.sc.seis.gee.configurator.ToolItemHandler;
import edu.sc.seis.gee.task.AllTasks;
import edu.sc.seis.gee.task.ButtonGroupManager;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.StatusIndicator;
import edu.sc.seis.gee.task.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class TaskAction
extends AbstractAction
implements DefaultParamNames {
    private boolean displayed;
    private String classname;
    private String id;
    private String iconName;
    private ToolBarHandler toolBarHandler;
    protected boolean toolBarHandlerAdded = false;
    private JToolBar jtoolbar = null;
    private LinkedList addedToolBarItems = new LinkedList();
    private boolean toggle;
    private HashMap params;
    private Task task = null;
    private boolean configuringTask = false;
    private JFrame frame = null;
    private JDialog window = null;
    private JPanel panel = null;
    private StatusIndicator statusIndicator;
    private boolean toolBarAdded = false;
    private static Logger logger = Logger.getLogger(TaskAction.class);
    private WindowListener defWindowListener = new MyWindowListener();
    public static boolean CHILDREN_GET_MENUBAR = false;
    public static final Dimension MIN_SIZE = new Dimension(200, 100);
    private static ClassLoader loader = TaskAction.class.getClassLoader();
    private static String triangle = "edu/sc/seis/gee/data/images/arrow-right.png";
    private static String placeholder = "edu/sc/seis/gee/data/images/blank-tallboy.png";
    private static ImageIcon rightTriangle = new ImageIcon(loader.getResource(triangle));
    private static ImageIcon singlePixelWide = new ImageIcon(loader.getResource(placeholder));

    public TaskAction(String id, String classname, String name, HashMap configParam, ToolBarHandler tbh, boolean toggle, String iconName) {
        this(id, classname, name, configParam, tbh, toggle);
        this.iconName = iconName;
        String iconImageName = iconName;
        URL url = null;
        if (iconImageName.indexOf(47) == -1) {
            iconImageName = "edu/sc/seis/gee/data/images/" + iconImageName;
            url = this.getClass().getClassLoader().getResource(iconImageName);
        } else {
            try {
                url = new URL(iconImageName);
            }
            catch (MalformedURLException e) {
                System.out.println(iconName);
                logger.error((Object)("Icon Image URL is badly formed:" + iconImageName), (Throwable)e);
            }
        }
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url, name));
        }
    }

    public TaskAction(String id, String classname, String name, HashMap configParam, ToolBarHandler tbh, boolean toggle) {
        super(name);
        String displayLoc;
        this.classname = classname;
        this.id = id;
        this.params = configParam;
        this.toolBarHandler = tbh;
        this.toggle = toggle;
        configParam.put("gee.task.taskAction", this);
        String tooltip = (String)configParam.get("gee.task.tooltip");
        if (tooltip != null && tooltip.length() != 0) {
            this.putValue("ShortDescription", tooltip);
        }
        if ((displayLoc = (String)configParam.get("gee.task.displayLocation")) == null) {
            configParam.put("gee.task.displayLocation", "frame");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public String getIconLoc() {
        return this.iconName;
    }

    public ToolBarHandler getToolBarHandler() {
        return this.toolBarHandler;
    }

    public JToolBar getToolBar() {
        if (this.jtoolbar == null) {
            try {
                this.jtoolbar = this.initToolBar();
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((String)"Problem creating toolbar.", (Throwable)e);
            }
        }
        this.toolBarAdded = true;
        return this.jtoolbar;
    }

    public JToolBar copyToolBar() throws ConfigurationException {
        JToolBar jtb = this.initToolBar();
        return jtb;
    }

    public JFrame getJFrame() {
        return this.frame;
    }

    public void destroyJFrame() {
        if (this.frame != null) {
            this.frame.hide();
            this.frame = null;
        }
    }

    public JPanel getJPanel() {
        return this.panel;
    }

    public void checkDisplayLocation() throws ConfigurationException {
        this.checkDisplayLocation(false, true);
    }

    public void checkDisplayLocation(boolean tabbed) throws ConfigurationException {
        this.checkDisplayLocation(tabbed, true);
    }

    private void checkDisplayLocation(boolean tabbed, boolean bringToFront) throws ConfigurationException {
        String displayLoc;
        if (this.task == null) {
            this.invoke(tabbed);
        }
        if ((displayLoc = (String)this.params.get("gee.task.displayLocation")) == null) {
            displayLoc = "frame";
        }
        if (this.task instanceof GUITask || this.task instanceof Component) {
            FrameManager manager = FrameManager.getManager();
            if (!this.displayed) {
                if (displayLoc.equalsIgnoreCase("main")) {
                    this.frame = manager.getCurrentMainFrame();
                    logger.debug((Object)("main frame name " + this.frame.getName() + "  for " + this.getName()));
                    manager.resize(this.frame, this.getSize(new Dimension(800, 600)));
                    this.frame.addWindowListener(this.defWindowListener);
                    this.panel = CommonAccess.getCommonAccess().getDisplayArea();
                    if (tabbed) {
                        this.panel = manager.createNewTab(this.frame, (String)this.params.get("gee.task.name"));
                    }
                    this.initPanel(this.panel);
                    this.frame.validate();
                } else if (displayLoc.equalsIgnoreCase("frame")) {
                    this.initFrame();
                } else if (displayLoc.equalsIgnoreCase("palette")) {
                    this.initPalette();
                }
                this.displayed = true;
            }
            if (bringToFront) {
                manager.setCurrentPanel(this.panel);
            }
            if (this.panel != null) {
                this.panel.revalidate();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent act) {
        if (act != null && act.getActionCommand().equals("setSize")) {
            this.invoke(false);
        } else if (this.task != null) {
            this.invoke(false, true);
        } else {
            this.invoke(false);
        }
    }

    public void invoke(boolean tabbed) {
        this.invoke(tabbed, false);
    }

    public synchronized void invoke(boolean tabbed, boolean bringToFront) {
        if (this.configuringTask) {
            throw new IllegalStateException("Attempting to call invoke while the task was being configured!");
        }
        GlobalExceptionHandler.append((String)"Invoked Tasks", (String)(this.getId() + "  -  " + this.getName()));
        try {
            this.getTask();
            if (this.isToggle() && this.params.get("gee.task.buttonGroupId") != null) {
                ButtonGroup bg = ButtonGroupManager.get((String)this.params.get("gee.task.buttonGroupId"));
                if (this.params.get("gee.task.buttonModel") != null) {
                    bg.setSelected((ButtonModel)this.params.get("gee.task.buttonModel"), true);
                }
            }
            this.checkDisplayLocation(tabbed, bringToFront);
            this.task.invoke();
        }
        catch (NoNetworkException e) {
            e.showMessage();
        }
        catch (Throwable e) {
            GlobalExceptionHandler.handle((Throwable)e);
        }
    }

    public void addToToolBar(JComponent comp) {
        if (this.jtoolbar == null) {
            this.addedToolBarItems.add(comp);
        } else {
            this.addToToolBar(this.jtoolbar, comp);
            this.checkToolBar(this.panel, this.jtoolbar);
        }
    }

    public void addToToolBar(JToolBar jtb, JComponent comp) {
        for (int i = 0; i < jtb.getComponentCount(); ++i) {
            if (!(jtb.getComponent(i) instanceof Box.Filler)) continue;
            jtb.add((Component)comp, i);
            return;
        }
        jtb.add(comp);
    }

    public void addToToolBar(Action act) {
        if (this.jtoolbar == null) {
            this.addedToolBarItems.add(act);
            return;
        }
        this.addToToolBar(this.jtoolbar, act);
    }

    public void addToToolBar(JToolBar jtb, Action act) {
        AbstractButton button;
        if (act instanceof TaskAction && ((TaskAction)act).isToggle()) {
            TaskAction tAct = (TaskAction)act;
            if (tAct.params.get("gee.task.buttonGroupId") != null) {
                button = new JToggleButton(tAct);
                ButtonGroup bg = ButtonGroupManager.get((String)tAct.params.get("gee.task.buttonGroupId"));
                if (tAct.getConfigParam("gee.task.buttonModel") != null) {
                    button.setModel((ButtonModel)tAct.getConfigParam("gee.task.buttonModel"));
                } else {
                    tAct.putConfigParam("gee.task.buttonModel", button.getModel());
                }
                bg.add(button);
            } else {
                button = new JCheckBox(tAct);
            }
            if (tAct.getConfigParam("gee.task.preselected") == "true") {
                button.setSelected(true);
            }
            button.setActionCommand(tAct.getId());
        } else {
            button = new JButton();
            button.setAction(act);
        }
        if (act.getValue("SmallIcon") != null) {
            button.setText("");
        } else {
            button.setIcon(singlePixelWide);
        }
        String toolTipText = (String)act.getValue("ShortDescription");
        if (toolTipText != null && toolTipText.length() != 0) {
            button.setToolTipText(toolTipText);
        }
        this.addToToolBar(jtb, button);
    }

    private void initFrame() throws ConfigurationException {
        if (this.frame == null) {
            logger.debug((Object)"frame is null, recreating");
            this.panel = new JPanel();
            this.panel.setName(this.getName());
            this.panel.setMinimumSize(new Dimension(200, 100));
            this.initPanel(this.panel);
            Dimension size = null;
            boolean usePack = true;
            if (this.params.containsKey("gee.task.widthpercentage") || this.params.containsKey("gee.task.width") || this.params.containsKey("gee.task.heightpercentage") || this.params.containsKey("gee.task.height")) {
                usePack = false;
                size = this.getSize();
                this.panel.setPreferredSize(size);
                logger.debug((Object)("size is " + size.toString()));
            } else {
                Dimension dim = new Dimension(300, 300);
                this.panel.setPreferredSize(dim);
                this.panel.setMinimumSize(dim);
            }
            String justify = (String)this.params.get("gee.task.justify");
            FrameManager manager = FrameManager.getManager();
            JFrame motherFrame = manager.getCurrentMainFrame();
            if (justify == null) {
                this.frame = usePack ? manager.createNewChild(this.getName(), motherFrame, this.panel) : manager.createNewChild(this.getName(), motherFrame, size, this.panel);
            } else if (usePack) {
                this.frame = manager.createNewChild(this.getName(), motherFrame, this.panel);
                this.frame.setLocation(FrameManager.getLoc(justify, this.frame.getSize()));
            } else {
                this.frame = manager.createNewChild(this.getName(), motherFrame, size, this.panel, FrameManager.getLoc(justify, size));
            }
            if (CHILDREN_GET_MENUBAR) {
                manager.setMenuBar(this.frame);
            }
        }
        this.frame.addWindowListener(this.defWindowListener);
        this.frame.show();
        this.frame.validate();
        if (this.frame.getState() == 1) {
            this.frame.setState(0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initPanel(JPanel newPanel) throws ConfigurationException {
        FrameManager.getManager().clearComponent(this.panel);
        this.panel.removeAll();
        this.toolBarAdded = false;
        this.panel.setName((String)this.params.get("gee.task.name"));
        FrameManager.getManager().updateName(this.panel);
        this.panel.setLayout(new BorderLayout());
        if (this.task instanceof GUITask) {
            guiTask = (GUITask)this.task;
            try {
                this.panel.add((Component)guiTask.getGUI(), "Center");
                if (!guiTask.hasMoreOptions()) ** GOTO lbl19
                more = new JButton("More Options");
                more.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                });
                this.panel.add((Component)more, "South");
            }
            catch (Exception e) {
                throw new ConfigurationException("Problem getting GUI for task " + this.getName(), e);
            }
        } else {
            this.panel.add((Component)((JComponent)this.task), "Center");
        }
lbl19:
        // 3 sources

        this.jtoolbar = this.initToolBar();
        this.checkToolBar(this.panel, this.jtoolbar);
        this.panel.validate();
        this.panel.repaint();
    }

    private void initPalette() throws ConfigurationException {
        if (this.window == null) {
            this.window = new JDialog((JFrame)CommonAccess.getCommonAccess().getDisplayArea().getTopLevelAncestor(), this.getName(), false);
            this.panel = new JPanel();
            this.jtoolbar = new JToolBar();
            this.jtoolbar.setFloatable(false);
            if (this.toolBarHandler != null && this.toolBarHandler.getToolItems().length > 1) {
                this.jtoolbar.setLayout(new GridLayout(this.toolBarHandler.getToolItems().length / 2, 2));
            }
            this.initPanel(this.panel);
            this.window.getContentPane().setLayout(new BorderLayout());
            this.window.getContentPane().add(this.panel);
            this.window.pack();
            this.window.validate();
            String justify = (String)this.params.get("gee.task.justify");
            if (justify == null) {
                justify = "center";
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int x = 0;
            int y = 0;
            int w = this.window.getSize().width;
            int h = this.window.getSize().height;
            if (justify.equals("center")) {
                x = (dimension.width - w) / 2;
                y = (dimension.height - h) / 2;
            } else if (justify.equals("topleft")) {
                x = 0;
                y = 0;
            } else if (justify.equals("topright")) {
                x = dimension.width - w;
                y = 0;
            } else if (justify.equals("bottomleft")) {
                x = 0;
                y = dimension.height - h - 40;
            } else if (justify.equals("bottomright")) {
                x = dimension.width - w;
                y = dimension.height - h - 40;
            }
            this.window.setLocation(x, y);
        }
        this.window.setVisible(true);
    }

    private JToolBar initToolBar() throws ConfigurationException {
        JToolBar jtb = new JToolBar();
        jtb.setFloatable(false);
        if (this.toolBarHandler != null) {
            ToolBarItem[] toolBarItems = this.toolBarHandler.getToolItems();
            for (int i = 0; i < toolBarItems.length; ++i) {
                if (toolBarItems[i] instanceof ToolItemHandler) {
                    this.addToToolBar(jtb, ((ToolItemHandler)toolBarItems[i]).getToolItem());
                    continue;
                }
                if (!(toolBarItems[i] instanceof MenuHandler)) continue;
                MenuHandler menuHandler = (MenuHandler)toolBarItems[i];
                final JButton menuButton = new JButton(menuHandler.getName(), rightTriangle);
                final JPopupMenu popup = menuHandler.getPopupMenu();
                this.addToToolBar(jtb, menuButton);
                menuButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        popup.show(menuButton, 0, menuButton.getHeight());
                    }
                });
            }
            this.toolBarHandlerAdded = true;
        }
        if (this.addedToolBarItems.size() != 0) {
            for (Object obj : this.addedToolBarItems) {
                if (obj instanceof JComponent) {
                    this.addToToolBar(jtb, (JComponent)obj);
                    continue;
                }
                if (!(obj instanceof Action)) continue;
                this.addToToolBar(jtb, (Action)obj);
            }
        }
        if (jtb.getComponentCount() > 0 && this.statusIndicator == null) {
            jtb.add(Box.createHorizontalGlue());
            this.statusIndicator = new StatusIndicator();
            jtb.add(this.statusIndicator);
        }
        return jtb;
    }

    private void checkToolBar(JPanel newPanel, JToolBar jtb) {
        if (!this.toolBarAdded && this.jtoolbar.getComponentCount() != 0 && this.panel != null) {
            logger.debug((Object)"adding tool bar");
            this.toolBarAdded = true;
            this.panel.add((Component)jtb, "North");
        }
        this.jtoolbar.repaint();
    }

    public StatusIndicator getStatusIndicator() {
        return new StatusIndicator();
    }

    public synchronized Task getTask() throws ConfigurationException {
        if (this.task == null) {
            if (this.params.containsKey("gee.task.task")) {
                this.task = (Task)this.params.get("gee.task.task");
            } else {
                try {
                    Class<?> c = Class.forName(this.classname);
                    this.task = (Task)c.newInstance();
                }
                catch (Exception ee) {
                    if (ee instanceof ConfigurationException) {
                        throw (ConfigurationException)ee;
                    }
                    throw new ConfigurationException("Couldn't load task! " + this.classname, ee);
                }
            }
            this.configuringTask = true;
            this.task.configure(this.params);
            this.configuringTask = false;
            AllTasks.associateTaskWithTaskAction(this, this.task);
        }
        return this.task;
    }

    public Object getConfigParam(String key) {
        return this.params.get(key);
    }

    public void putConfigParam(String key, Object value) {
        this.params.put(key, value);
    }

    public HashMap getConfigParams() {
        return this.params;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean destroyFrame) {
        this.reset(destroyFrame, true);
    }

    public void reset(boolean destroyFrame, boolean nullifyTask) {
        if (destroyFrame) {
            this.destroyJFrame();
        } else {
            this.frame = null;
            this.displayed = false;
        }
        if (this.panel != null) {
            this.panel = null;
        }
        if (this.task != null) {
            this.task.destroy();
            if (nullifyTask) {
                this.task = null;
            }
        }
        if (this.jtoolbar != null) {
            this.jtoolbar = null;
        }
        if (this.window != null) {
            this.window.hide();
            this.window.dispose();
            this.window = null;
        }
        if (this.statusIndicator != null) {
            this.statusIndicator.destroy();
            this.statusIndicator = null;
        }
        this.addedToolBarItems.clear();
        this.toolBarHandlerAdded = false;
        this.toolBarAdded = false;
        this.setEnabled(true);
    }

    private Dimension getSize() {
        return this.getSize(new Dimension(400, 400));
    }

    private Dimension getSize(Dimension defaultDim) {
        String heightPix;
        String heightPer;
        String widthPix;
        int width = defaultDim.width;
        int height = defaultDim.height;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        String widthPer = (String)this.params.get("gee.task.widthpercentage");
        if (widthPer != null) {
            double percentage = (double)Integer.parseInt(widthPer) / 100.0;
            width = (int)((double)screenSize.width * percentage);
        }
        if ((widthPix = (String)this.params.get("gee.task.width")) != null) {
            width = Integer.parseInt(widthPix);
        }
        if ((heightPer = (String)this.params.get("gee.task.heightpercentage")) != null) {
            double percentage = (double)Integer.parseInt(heightPer) / 100.0;
            height = (int)((double)screenSize.height * percentage);
        }
        if ((heightPix = (String)this.params.get("gee.task.height")) != null) {
            height = Integer.parseInt(heightPix);
        }
        return new Dimension(width, height);
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            TaskAction.this.frame = null;
            TaskAction.this.displayed = false;
            TaskAction.this.reset(false, false);
        }
    }
}

