/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.dataset.EarthquakeStationIterator;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SeismogramApprovalTask
implements GUITask {
    private JTextArea eventInfo = new JTextArea();
    private ProxyEventAccessOperations currentEvent;
    private List currentSeismograms;
    private EarthquakeStationIterator eqStaIt;
    private Map params;
    private TaskAction dispAction;
    private TaskAction exportAction;
    private ColumnSeismogramTask colSeis;
    private Box vBox;
    private JPanel panel;

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if (!params.containsKey("seisDisplay")) {
            throw new ConfigurationException("seisDisplay parameter must defined");
        }
        String displayId = (String)params.get("seisDisplay");
        this.dispAction = CommonAccess.getCommonAccess().getTaskAction(displayId);
        this.colSeis = (ColumnSeismogramTask)this.dispAction.getTask();
        if (!params.containsKey("approvalExport")) {
            throw new ConfigurationException("seisDisplay parameter must defined");
        }
        displayId = (String)params.get("approvalExport");
        this.exportAction = CommonAccess.getCommonAccess().getTaskAction(displayId);
    }

    @Override
    public void invoke() throws Exception {
        this.colSeis.getDisplay().clear();
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        this.eqStaIt = new EarthquakeStationIterator(commonAccess.getDataSetRoot());
        if (!this.queueUpSeismograms()) {
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(), "There are no seismograms in the dataset!", "No seismograms!", 1);
            this.hide();
        }
    }

    @Override
    public JComponent getGUI() throws Exception {
        if (this.vBox == null) {
            this.vBox = Box.createVerticalBox();
            this.vBox.add(Box.createVerticalGlue());
            Box singleBox = Box.createHorizontalBox();
            singleBox.setBorder(BorderFactory.createTitledBorder("Current Seismograms"));
            ButtonGroup singleButtons = new ButtonGroup();
            JButton singleApproveButton = new JButton("Approve");
            singleApproveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SeismogramApprovalTask.this.approveSeismograms(true);
                }
            });
            singleButtons.add(singleApproveButton);
            JButton singleDisapproveButton = new JButton("Disapprove");
            singleDisapproveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SeismogramApprovalTask.this.approveSeismograms(false);
                }
            });
            singleButtons.add(singleDisapproveButton);
            singleButtons.setSelected(singleApproveButton.getModel(), true);
            singleBox.add(Box.createHorizontalGlue());
            singleBox.add(singleApproveButton);
            singleBox.add(Box.createHorizontalGlue());
            singleBox.add(singleDisapproveButton);
            singleBox.add(Box.createHorizontalGlue());
            this.vBox.add(singleBox);
            this.vBox.add(Box.createVerticalGlue());
            Box batchBox = Box.createHorizontalBox();
            batchBox.setBorder(BorderFactory.createTitledBorder("Remaining Seismograms for Event"));
            ButtonGroup batchButtons = new ButtonGroup();
            JButton batchApproveButton = new JButton("Approve");
            batchApproveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SeismogramApprovalTask.this.approveRemainingSeismograms((EventAccessOperations)SeismogramApprovalTask.this.currentEvent, true);
                }
            });
            batchButtons.add(batchApproveButton);
            batchButtons.setSelected(batchApproveButton.getModel(), true);
            JButton batchDisapproveButton = new JButton("Disapprove");
            batchDisapproveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SeismogramApprovalTask.this.approveRemainingSeismograms((EventAccessOperations)SeismogramApprovalTask.this.currentEvent, false);
                }
            });
            batchButtons.add(batchDisapproveButton);
            batchBox.add(Box.createHorizontalGlue());
            batchBox.add(batchApproveButton);
            batchBox.add(Box.createHorizontalGlue());
            batchBox.add(batchDisapproveButton);
            batchBox.add(Box.createHorizontalGlue());
            this.vBox.add(batchBox);
            this.vBox.add(Box.createVerticalGlue());
            Box evInfoBox = Box.createHorizontalBox();
            evInfoBox.setBorder(BorderFactory.createTitledBorder("Event Info"));
            evInfoBox.add(Box.createHorizontalGlue());
            this.eventInfo.setEditable(false);
            evInfoBox.add(this.eventInfo);
            evInfoBox.add(Box.createHorizontalGlue());
            this.vBox.add(evInfoBox);
            this.vBox.add(Box.createVerticalGlue());
        }
        return this.vBox;
    }

    @Override
    public boolean hasMoreOptions() {
        return false;
    }

    @Override
    public JComponent getMoreOptionsGUI() {
        return null;
    }

    @Override
    public void destroy() {
    }

    private void approveRemainingSeismograms(EventAccessOperations event, boolean approve) {
        while (event.equals(this.currentEvent)) {
            this.approveSeismograms(approve);
        }
    }

    private void approveSeismograms(boolean approve) {
        SeismogramDisplay display = this.colSeis.getDisplay();
        DataSetSeismogram[] seismos = display.getSeismograms();
        for (int i = 0; i < seismos.length; ++i) {
            if (approve) {
                seismos[i].addAuxillaryData((Object)StdAuxillaryDataNames.APPROVED, (Object)"true");
                continue;
            }
            seismos[i].addAuxillaryData((Object)StdAuxillaryDataNames.APPROVED, (Object)"false");
        }
        this.colSeis.getDisplay().clear();
        if (!this.queueUpSeismograms()) {
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(), "You've finished this quality control session.  Now it's time to export!", "Finished!", 1);
            this.hide();
            this.exportAction.invoke(false);
        }
    }

    private boolean queueUpSeismograms() {
        if (this.eqStaIt.hasNext()) {
            this.currentSeismograms = (List)this.eqStaIt.next();
            DataSetSeismogram[] dsSeismos = this.currentSeismograms.toArray(new DataSetSeismogram[0]);
            this.currentEvent = BulletproofVestFactory.vestEventAccess((EventAccessOperations)dsSeismos[0].getDataSet().getEvent());
            this.eventInfo.setText(EventUtil.getEventInfo((EventAccessOperations)this.currentEvent, (String)"LOC\nTIME\nMag: MAG\nDepth: DEPTH DEPTH_UNIT\nLat: LAT\nLon: LON"));
            this.colSeis.setDisplay();
            for (int i = 0; i < dsSeismos.length; ++i) {
                this.colSeis.addSeismogram(dsSeismos[i]);
            }
            return true;
        }
        this.currentEvent = null;
        return false;
    }

    private void hide() {
        TaskAction thisAction = CommonAccess.getCommonAccess().getTaskAction(this);
        thisAction.getJFrame().hide();
    }
}

