/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.AbstractHandler;
import edu.sc.seis.gee.task.SAXTask;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.VersionTask;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ProjectChoice
extends JLayeredPane
implements SAXTask {
    private static Integer CHOICE_LAYER = new Integer(1);
    private static Integer BACKGROUND_LAYER = JLayeredPane.DEFAULT_LAYER;
    private int GLOBE_RADIUS = 330;
    private Point GLOBE_CENTER = new Point(-8, 424);
    private Map params;
    private List choices = new ArrayList();

    @Override
    public void configure(Map configParams) {
        this.params = configParams;
    }

    @Override
    public void invoke() throws Exception {
        String imageName = (String)this.params.get("background");
        URL imgURL = this.getClass().getClassLoader().getResource(imageName);
        ImageIcon imageIcon = new ImageIcon(imgURL);
        JLabel imageLabel = new JLabel(imageIcon);
        this.add((Component)imageLabel, BACKGROUND_LAYER);
        imageLabel.setBounds(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        int y = 110;
        int radiusSquared = this.GLOBE_RADIUS * this.GLOBE_RADIUS;
        Iterator it = this.choices.iterator();
        while (it.hasNext()) {
            SelectionImage si = new SelectionImage((Choice)it.next());
            int nextPosition = y + si.getHeight() + 15;
            int centerDist = nextPosition - this.GLOBE_CENTER.y;
            if (y >= this.GLOBE_CENTER.y) {
                centerDist -= si.getHeight() + 15;
            }
            int x = (int)Math.sqrt(radiusSquared - centerDist * centerDist) + 5;
            this.add((Component)si, CHOICE_LAYER);
            si.setBounds(x, y, si.getWidth(), si.getHeight());
            y = nextPosition;
        }
        JLabel version = new JLabel(VersionTask.getVersion());
        this.add((Component)version, CHOICE_LAYER);
        version.setSize(version.getPreferredSize());
        version.setBounds(this.getWidth() - 15 - version.getWidth(), this.getHeight() - 5 - version.getHeight(), version.getWidth(), version.getHeight());
    }

    @Override
    public void destroy() {
    }

    @Override
    public AbstractHandler getConfigureHandler(String name, XMLReader parser, AbstractHandler parent) {
        return new ChoiceHandler(parser, parent);
    }

    class SelectionImage
    extends JLabel
    implements MouseListener {
        private ImageIcon deadImage;
        private ImageIcon highlightedImage;
        private String val;
        private String text;

        public SelectionImage(Choice cho) {
            String deadImageName = cho.imageURL;
            String taskId = cho.taskId;
            String description = cho.description;
            URL url = this.getClass().getClassLoader().getResource(deadImageName);
            this.deadImage = new ImageIcon(url);
            if (!taskId.equals("seperator")) {
                url = this.getClass().getClassLoader().getResource(this.getHighlightName(deadImageName));
                this.highlightedImage = new ImageIcon(url);
                this.val = taskId;
                this.text = description;
                this.addMouseListener(this);
            }
            this.setIcon(this.deadImage);
            int height = this.deadImage.getIconHeight();
            height = height < 60 ? 35 : 70;
            int width = this.deadImage.getIconWidth();
            if (width < 30) {
                width = 30;
            }
            this.setSize(new Dimension(width, height));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setIcon(this.highlightedImage);
            this.setToolTipText(this.text);
        }

        @Override
        public Point getToolTipLocation(MouseEvent e) {
            return new Point(0, this.getSize().height);
        }

        public String getHighlightName(String deadName) {
            return deadName.replaceFirst("un", "");
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            CommonAccess c = CommonAccess.getCommonAccess();
            TaskAction t = c.getTaskAction(this.val);
            t.actionPerformed(null);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setIcon(this.deadImage);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }
    }

    private class Choice {
        public String imageURL;
        public String description;
        public String taskId;

        private Choice() {
        }
    }

    private final class ChoiceHandler
    extends AbstractHandler {
        private String lastParsedString;
        private Choice cur;

        private ChoiceHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
            this.lastParsedString = "";
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.lastParsedString = this.lastParsedString.trim();
            if (localName.equals("choice")) {
                if (this.cur.imageURL == null || this.cur.description == null || this.cur.taskId == null) {
                    throw new SAXException("Poorly formed choice!");
                }
                ProjectChoice.this.choices.add(this.cur);
            } else if (localName.equals("imageURL")) {
                this.cur.imageURL = this.lastParsedString;
            } else if (localName.equals("description")) {
                this.cur.description = this.lastParsedString.replaceAll("\\s+", " ");
            } else if (localName.equals("taskId")) {
                this.cur.taskId = this.lastParsedString;
            } else if (localName.equals("complexValue")) {
                super.endElement(namespaceURI, localName, qName);
            }
            this.lastParsedString = "";
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.lastParsedString = this.lastParsedString + new String(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (localName.equals("choice")) {
                this.cur = new Choice();
            }
        }
    }
}

