/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.xml.DCDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.FDSNWSDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeEvent;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import edu.sc.seis.fissuresUtil.xml.SeisDataErrorEvent;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.Task;
import java.awt.Component;
import java.util.Date;
import java.util.Map;
import javax.swing.JOptionPane;

public class DataFillTask
implements Task {
    private WorkerThreadPool dataFillPool = new WorkerThreadPool("DataFill", 1);
    private DataFiller filler = new DataFiller();
    private static boolean displayMoreThanADay = false;
    private static String warningMessage = "You are attempting to display over 6 hours worth of data.  This can cause slowness.  Are you sure you want to?";
    private static TimeInterval SIX_HOURS = new TimeInterval(6.0, UnitImpl.HOUR);
    private Map params;
    private ColumnSeismogramTask display;
    private static final SeisDataChangeListener EMPTY_INITIATOR = new SeisDataChangeListener(){

        public void pushData(SeisDataChangeEvent sdce) {
        }

        public void error(SeisDataErrorEvent sdce) {
        }

        public void finished(SeisDataChangeEvent sdce) {
        }
    };

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if (!params.containsKey("display")) {
            throw new ConfigurationException("fill display task requires a colSeisDisplay in the configuration");
        }
        String targetId = (String)params.get("display");
        this.display = (ColumnSeismogramTask)CommonAccess.getCommonAccess().getTaskAction(targetId).getTask();
    }

    @Override
    public void invoke() throws Exception {
        JobTracker.getTracker().add((Job)this.filler);
        this.dataFillPool.invokeLater((Runnable)((Object)this.filler));
    }

    public boolean userWantsMoreThanSixHours(SeismogramDisplay disp) {
        if (displayMoreThanADay || JOptionPane.showConfirmDialog((Component)disp, warningMessage, "Fetch data", 0, 2) == 0) {
            displayMoreThanADay = true;
        }
        return displayMoreThanADay;
    }

    @Override
    public void destroy() {
    }

    private class DataFiller
    extends AbstractJob {
        public DataFiller() {
            super("Data Expander");
            this.setFinished();
        }

        public void runJob() {
            this.setStatus("Getting seismograms");
            SeismogramDisplay disp = DataFillTask.this.display.getDisplay();
            DataSetSeismogram[] seismos = disp.getSeismograms();
            TimeEvent event = disp.getTimeConfig().fireTimeEvent();
            MicroSecondTimeRange timeRange = disp.getTimeConfig().fireTimeEvent().getTime();
            if (!timeRange.getInterval().greaterThan((QuantityImpl)SIX_HOURS) || DataFillTask.this.userWantsMoreThanSixHours(disp)) {
                for (int j = 0; j < seismos.length; ++j) {
                    int i;
                    if (!(seismos[j] instanceof DCDataSetSeismogram) && !(seismos[j] instanceof FDSNWSDataSetSeismogram)) continue;
                    boolean expandBegin = false;
                    boolean expandEnd = false;
                    this.setStatus("Getting other components for " + (j + 1) + "/" + seismos.length);
                    timeRange = event.getTime(seismos[j]);
                    if (seismos[j].getBeginMicroSecondDate().after((Date)timeRange.getBeginTime())) {
                        expandBegin = true;
                    }
                    if (seismos[j].getEndMicroSecondDate().before((Date)timeRange.getEndTime())) {
                        expandEnd = true;
                    }
                    if (!expandBegin && !expandEnd) continue;
                    this.setStatus("Expanding time for " + (j + 1) + "/" + seismos.length);
                    DataSetSeismogram[] seisAndFriends = DisplayUtils.getComponents((DataSetSeismogram)seismos[j]);
                    if (expandBegin) {
                        for (i = 0; i < seisAndFriends.length; ++i) {
                            seisAndFriends[i].setBeginTime(timeRange.getBeginTime().getFissuresTime());
                        }
                    }
                    if (!expandEnd) continue;
                    for (i = 0; i < seisAndFriends.length; ++i) {
                        seisAndFriends[i].setEndTime(timeRange.getEndTime().getFissuresTime());
                    }
                }
            }
            this.setFinished();
        }
    }
}

