/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.Dimension;
import edu.iris.Fissures.IfEvent.EventAccess;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfPlottable.PlottableDC;
import edu.iris.Fissures.IfPlottable.PlottableDCOperations;
import edu.iris.Fissures.IfPlottable.PlottableNotAvailable;
import edu.iris.Fissures.IfPlottable.UnsupportedDimension;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.NotImplemented;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.cache.ProxyPlottableDC;
import edu.sc.seis.gee.task.CrocusPlottableQueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrocusPlottable
extends AbstractFDSNQuerier
implements ProxyPlottableDC {
    String host = "crocus.seis.sc.edu";
    int port = 80;
    String path = "/onesecminmaxb";
    String scheme = "http";
    String userInfo = null;
    String fragment = null;
    CrocusPlottableQueryParams queryParams;
    public static final String NODATA = "nodata";
    public static final String NETWORK_SHORT = "net";
    public static final String NETWORK = "network";
    public static final String STATION_SHORT = "sta";
    public static final String STATION = "station";
    public static final String LOCATION_SHORT = "loc";
    public static final String LOCATION = "location";
    public static final String CHANNEL_SHORT = "cha";
    public static final String CHANNEL = "channel";
    public static final String STARTTIME_SHORT = "start";
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME_SHORT = "end";
    public static final String ENDTIME = "endtime";
    public static final String YEAR = "year";
    public static final String DAY = "day";
    public static final String MODULO = "modulo";
    private static final Logger logger = LoggerFactory.getLogger(CrocusPlottable.class);

    public CrocusPlottable(CrocusPlottableQueryParams queryParams) {
        this.queryParams = queryParams;
    }

    public URL getSchemaURL() {
        return null;
    }

    public URI formURI() throws URISyntaxException {
        StringBuilder newQuery = new StringBuilder();
        newQuery.append(NETWORK).append("=").append(this.queryParams.getChannel_id().network_id.network_code).append("&");
        newQuery.append(STATION).append("=").append(this.queryParams.getChannel_id().station_code).append("&");
        newQuery.append(LOCATION).append("=").append(this.queryParams.getChannel_id().site_code).append("&");
        newQuery.append(CHANNEL).append("=").append(this.queryParams.getChannel_id().channel_code).append("&");
        newQuery.append(YEAR).append("=").append(this.queryParams.getYear()).append("&");
        newQuery.append(DAY).append("=").append(this.queryParams.getJday()).append("&");
        newQuery.append(MODULO).append("=").append(this.queryParams.getModulo()).append("&");
        if (newQuery.length() > 1) {
            newQuery.deleteCharAt(newQuery.length() - 1);
        }
        return new URI(this.getScheme(), this.getUserInfo(), this.getHost(), this.getPort(), this.getPath(), newQuery.toString(), this.getFragment());
    }

    public boolean custom_sizes() {
        return false;
    }

    public Plottable[] get_plottable(RequestFilter request, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension, NotImplemented {
        throw new NotImplemented();
    }

    public Dimension[] get_whole_day_sizes() {
        return new Dimension[]{new Dimension(6000, 0)};
    }

    public Plottable[] get_for_day(ChannelId channel_id, int year, int jday, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension {
        return new Plottable[0];
    }

    public Plottable[] getPlottable() {
        URI uri = null;
        try {
            int dayBegin = (int)(new MicroSecondDate(this.queryParams.getYear() + "" + this.queryParams.getJday() + "J00:00:00Z").getTime() / 1000L);
            this.connect();
            uri = this.formURI();
            if (!this.isError()) {
                if (!this.isEmpty()) {
                    ArrayList<Plottable> outList = new ArrayList<Plottable>();
                    ArrayList<Integer> xList = new ArrayList<Integer>();
                    ArrayList<Integer> yList = new ArrayList<Integer>();
                    DataInputStream dis = new DataInputStream(new BufferedInputStream(this.getInputStream()));
                    int lastX = -2;
                    try {
                        while (true) {
                            int readX;
                            int x;
                            if (lastX + 1 != (x = ((readX = dis.readInt()) - dayBegin) / this.queryParams.getModulo()) && xList != null) {
                                int i;
                                Plottable out = new Plottable();
                                out.x_coor = new int[xList.size()];
                                for (i = 0; i < xList.size(); ++i) {
                                    out.x_coor[i] = (Integer)xList.get(i);
                                }
                                out.y_coor = new int[yList.size()];
                                for (i = 0; i < yList.size(); ++i) {
                                    out.y_coor[i] = (Integer)yList.get(i);
                                }
                                outList.add(out);
                                xList = new ArrayList();
                                yList = new ArrayList();
                            }
                            int min = dis.readInt();
                            int max = dis.readInt();
                            xList.add(x);
                            yList.add(min);
                            xList.add(x);
                            yList.add(max);
                            lastX = x;
                        }
                    }
                    catch (EOFException e) {
                        if (xList != null) {
                            int i;
                            Plottable out = new Plottable();
                            out.x_coor = new int[xList.size()];
                            for (i = 0; i < xList.size(); ++i) {
                                out.x_coor[i] = (Integer)xList.get(i);
                            }
                            out.y_coor = new int[yList.size()];
                            for (i = 0; i < yList.size(); ++i) {
                                out.y_coor[i] = (Integer)yList.get(i);
                            }
                            outList.add(out);
                        }
                        return outList.toArray(new Plottable[0]);
                    }
                }
                return new Plottable[0];
            }
            throw new RuntimeException("Error: " + this.getErrorMessage() + "  " + uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error with URL syntax", e);
        }
        catch (SeisFileException e) {
            if (e instanceof FDSNWSException) {
                ((FDSNWSException)e).setTargetURI(uri);
                throw new RuntimeException(e);
            }
            throw new RuntimeException((Throwable)new FDSNWSException(e.getMessage(), (Throwable)e, uri));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Dimension[] get_event_sizes() {
        return new Dimension[0];
    }

    public Plottable[] get_for_event(EventAccess event, ChannelId channel_id, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension {
        throw new PlottableNotAvailable("No implemented");
    }

    public PlottableDCOperations getWrappedDC() {
        return null;
    }

    public PlottableDCOperations getWrappedDC(Class wrappedClass) {
        return null;
    }

    public void reset() {
    }

    public PlottableDC getCorbaObject() {
        return null;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getFragment() {
        return this.fragment;
    }
}

