/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.FilterNetworkDC;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserSeisSource;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserSource;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.FDSNChannelChooserSource;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.LoadSeismogram;
import edu.sc.seis.gee.task.ShowEventsTask;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQueryParams;
import edu.sc.seis.sod.source.network.FdsnStation;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Category;

public class ChannelChooserTask
implements GUITask {
    private Pattern[] patterns = new Pattern[0];
    private String[] autoSelectBand = new String[]{"B", "H"};
    private static final String[] DEFAULT_BAND = new String[]{"B", "H", "L", "S", "E"};
    String[] bands = DEFAULT_BAND;
    private int orientation = 0;
    Map params = new HashMap();
    JPanel panel;
    boolean showSites = false;
    boolean showNetworks = true;
    boolean showCodes = false;
    protected boolean guiInitialized = false;
    private ChannelChooserCubbyHole channelChooserCubbyHole = null;
    private LoadSeismogram loadSeis = null;
    static Category logger = Category.getInstance((String)ChannelChooserTask.class.getName());
    private TaskAction processDisplayAction;
    public static final String SERVER_HOST = "host";

    @Override
    public JComponent getMoreOptionsGUI() {
        return null;
    }

    @Override
    public boolean hasMoreOptions() {
        return false;
    }

    @Override
    public void invoke() {
    }

    @Override
    public JComponent getGUI() throws Exception {
        if (!this.guiInitialized) {
            this.panel = new JPanel();
            this.guiInitialized = true;
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.getChannelChooser());
        }
        return this.panel;
    }

    @Override
    public void configure(Map map) throws ConfigurationException {
        TaskAction taskAction;
        this.params = map;
        if (map.containsKey("showSites") && ((String)map.get("showSites")).equalsIgnoreCase("true")) {
            this.showSites = true;
        }
        if (map.containsKey("showNetworks") && ((String)map.get("showNetworks")).equalsIgnoreCase("false")) {
            this.showNetworks = false;
        }
        if (map.containsKey("showCodes") && ((String)map.get("showCodes")).equalsIgnoreCase("true")) {
            this.showCodes = true;
        }
        if (map.containsKey("eventSelector")) {
            taskAction = CommonAccess.getCommonAccess().getTaskAction((String)map.get("eventSelector"));
            final ShowEventsTask showEventsTask = (ShowEventsTask)taskAction.getTask();
            ListSelectionModel selectionModel = showEventsTask.getEventSelectionModel();
            selectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    EventAccessOperations[] selectedEvents = showEventsTask.getSelectedEvents();
                    if (selectedEvents.length > 0) {
                        try {
                            ChannelChooserTask.this.getChannelChooser().setAvailbleDataOrigin(selectedEvents[0].get_preferred_origin());
                        }
                        catch (NoPreferredOrigin noPreferredOrigin) {
                        }
                        catch (NoNetworkException ex) {
                            GlobalExceptionHandler.handle((Throwable)ex);
                        }
                    }
                }
            });
        }
        if (map.containsKey("filterStations")) {
            String filterURL = (String)map.get("filterStations");
            try {
                this.patterns = FilterNetworkDC.readPattern((String)filterURL);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("The url for the file with a list of stations to filter, " + filterURL + ", is malformed", e);
            }
            catch (IOException e) {
                GlobalExceptionHandler.handle((String)"Trouble reading list of patterns", (Throwable)e);
            }
        }
        if (map.containsKey("orientation")) {
            String orient = (String)map.get("orientation");
            if (orient.equals("INDIVIDUAL_CHANNELS")) {
                this.orientation = 3;
            } else if (orient.equals("THREE_COMPONENT")) {
                this.orientation = 4;
            } else if (orient.equals("VERTICAL_ONLY")) {
                this.orientation = 1;
            } else if (orient.equals("HORIZONTAL_ONLY")) {
                this.orientation = 2;
            } else {
                throw new ConfigurationException("That orientation string isn't supported.  As of now, INDIVIDUAL_CHANNELS is the only one.  Add more in ChannelChooserTask if you need it.");
            }
        }
        if (map.containsKey("bands")) {
            ArrayList<String> tmpbands = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer((String)map.get("bands"), ",");
            while (tokenizer.hasMoreTokens()) {
                tmpbands.add(tokenizer.nextToken());
            }
            this.bands = tmpbands.toArray(new String[0]);
            this.autoSelectBand = tmpbands.toArray(new String[0]);
        }
        if (map.containsKey("loadSeismogramTask")) {
            taskAction = CommonAccess.getCommonAccess().getTaskAction((String)map.get("loadSeismogramTask"));
            this.loadSeis = (LoadSeismogram)taskAction.getTask();
        }
        this.initializeChannelChooser();
    }

    @Override
    public void destroy() {
    }

    protected List<ChannelChooserSource> getConfiguredNetworkSources() throws ConfigurationException {
        Set keySet = this.params.keySet();
        Iterator iter = keySet.iterator();
        ArrayList<ChannelChooserSource> list = new ArrayList<ChannelChooserSource>();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(SERVER_HOST)) continue;
            String host = (String)this.params.get(key);
            if (host == null || host.length() == 0) {
                throw new ConfigurationException("Bad configuration for " + key);
            }
            FDSNStationQueryParams queryParams = new FDSNStationQueryParams();
            queryParams.setHost(host);
            for (String band : this.bands) {
                queryParams.appendToChannel(band + "H?");
            }
            FdsnStation fdsnStation = new FdsnStation(key, -1, queryParams);
            list.add(new FDSNChannelChooserSource(fdsnStation));
        }
        return list;
    }

    public String[] getConfiguredNetworks() {
        Set keySet = this.params.keySet();
        Iterator iter = keySet.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith("network")) continue;
            String value = (String)this.params.get(key);
            arrayList.add(value);
        }
        String[] rtnValues = new String[arrayList.size()];
        rtnValues = arrayList.toArray(rtnValues);
        return rtnValues;
    }

    public ChannelChooser getChannelChooser() throws NoNetworkException {
        if (!NetworkGateKeeper.accessAllowed()) {
            throw new NoNetworkException();
        }
        if (this.channelChooserCubbyHole == null) {
            try {
                this.initializeChannelChooser();
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((String)"Problem initializing the channel chooser", (Throwable)e);
            }
        }
        return this.channelChooserCubbyHole.get();
    }

    protected void initializeChannelChooser() throws ConfigurationException {
        if (this.channelChooserCubbyHole == null) {
            this.channelChooserCubbyHole = new ChannelChooserCubbyHole();
            ChannelChooserInitializer cci = new ChannelChooserInitializer();
            JobTracker.getTracker().add((Job)cci);
            if (this.processDisplayAction != null) {
                this.processDisplayAction.checkDisplayLocation();
            }
            cci.run();
        }
    }

    private class ChannelChooserInitializer
    extends AbstractJob {
        public ChannelChooserInitializer() {
            super("Channel Chooser");
        }

        public void runJob() {
            if (!NetworkGateKeeper.accessAllowed()) {
                this.setFinished();
                return;
            }
            List<Object> netDCs = new ArrayList();
            try {
                this.setStatus("Getting Networks");
                netDCs = ChannelChooserTask.this.getConfiguredNetworkSources();
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
            this.setStatus("Creating chooser");
            ChannelChooser myChannelChooser = new ChannelChooser(netDCs, ChannelChooserTask.this.showSites, ChannelChooserTask.this.showNetworks, ChannelChooserTask.this.getConfiguredNetworks(), ChannelChooserTask.this.bands, ChannelChooserTask.this.autoSelectBand, ChannelChooser.DEFAULT_SELECTABLE_ORIENTATIONS, ChannelChooserTask.this.orientation);
            if (ChannelChooserTask.this.showCodes) {
                myChannelChooser.setShowCodes(ChannelChooserTask.this.showCodes);
            }
            myChannelChooser.setSeismogramDC(new ChannelChooserSeisSource(){

                public List<LocalSeismogramImpl> request(List<RequestFilter> request) {
                    try {
                        SeismogramSource source = ChannelChooserTask.this.loadSeis.getDataCenterRouter().getSeismogramSource(null, null, request.toArray(new RequestFilter[0]), null);
                        return source.retrieveData(request);
                    }
                    catch (ConfigurationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public List<RequestFilter> availableData(List<RequestFilter> request) {
                    try {
                        SeismogramSource source = ChannelChooserTask.this.loadSeis.getDataCenterRouter().getSeismogramSource(null, null, request.toArray(new RequestFilter[0]), null);
                        return source.availableData(request);
                    }
                    catch (ConfigurationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            myChannelChooser.selectAllNetworks();
            ChannelChooserTask.this.channelChooserCubbyHole.put(myChannelChooser);
            this.setFinished();
        }
    }

    private class ChannelChooserCubbyHole {
        private ChannelChooser contents;
        private boolean available = false;

        private ChannelChooserCubbyHole() {
        }

        public synchronized ChannelChooser get() {
            if (!this.available) {
                logger.debug((Object)"Waiting to get channel chooser from CubbyHole");
            }
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.notifyAll();
            return this.contents;
        }

        public synchronized void put(ChannelChooser value) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.contents = value;
            this.available = true;
            this.notifyAll();
        }
    }
}

