/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.configurator;

import edu.sc.seis.gee.configurator.AbstractHandler;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.MenuItemHandler;
import edu.sc.seis.gee.configurator.ToolBarItem;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MenuHandler
extends AbstractHandler
implements ToolBarItem {
    String name = "";
    LinkedList menuItem = new LinkedList();

    public MenuHandler(XMLReader parser, AbstractHandler parent) {
        super(parser, parent);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (localName.equals("name")) {
            this.parser.setContentHandler(new NameHandler(this.parser, this));
        } else if (localName.equals("menuItem")) {
            MenuItemHandler handler = new MenuItemHandler(this.parser, this);
            this.parser.setContentHandler(handler);
            this.menuItem.add(handler);
        } else if (localName.equals("menu")) {
            MenuHandler handler = new MenuHandler(this.parser, this);
            this.parser.setContentHandler(handler);
            this.menuItem.add(handler);
        } else if (localName.equals("separator")) {
            SeparatorHandler handler = new SeparatorHandler(this.parser, this);
            this.parser.setContentHandler(handler);
            this.menuItem.add(handler);
        }
    }

    public JMenu getMenu() throws ConfigurationException {
        JMenu menu = new JMenu(this.name);
        for (Object item : this.menuItem) {
            if (item instanceof MenuHandler) {
                MenuHandler mh = (MenuHandler)item;
                menu.add(mh.getMenu());
                continue;
            }
            if (item instanceof SeparatorHandler) {
                menu.addSeparator();
                continue;
            }
            MenuItemHandler mih = (MenuItemHandler)item;
            menu.add(mih.getMenuItem());
        }
        return menu;
    }

    public JPopupMenu getPopupMenu() throws ConfigurationException {
        JPopupMenu menu = new JPopupMenu(this.name);
        for (Object item : this.menuItem) {
            if (item instanceof MenuHandler) {
                MenuHandler mh = (MenuHandler)item;
                menu.add(mh.getMenu());
                continue;
            }
            if (item instanceof SeparatorHandler) {
                menu.addSeparator();
                continue;
            }
            MenuItemHandler mih = (MenuItemHandler)item;
            menu.add(mih.getMenuItem());
        }
        return menu;
    }

    public String getName() {
        return this.name;
    }

    class SeparatorHandler
    extends AbstractHandler {
        SeparatorHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }
    }

    class NameHandler
    extends AbstractHandler {
        NameHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            MenuHandler.this.name = MenuHandler.this.name + new String(ch, start, length);
        }
    }
}

