/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.configurator;

import edu.sc.seis.gee.configurator.AbstractHandler;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.ExceptionGreetingHandler;
import edu.sc.seis.gee.configurator.InactiveTaskHandler;
import edu.sc.seis.gee.configurator.InitialTaskHandler;
import edu.sc.seis.gee.configurator.MenuBarHandler;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenuBar;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ActivityHandler
extends AbstractHandler {
    static JMenuBar EMPTY_MENU = new JMenuBar();
    String id = "";
    String title = "";
    String description = "";
    MenuBarHandler menubar;
    LinkedList initialTasks = new LinkedList();
    LinkedList inactiveTasks = new LinkedList();
    String appendActivityId = "";

    public ActivityHandler(XMLReader parser, AbstractHandler parent) {
        super(parser, parent);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (localName.equals("title")) {
            this.parser.setContentHandler(new TitleHandler(this.parser, this));
        } else if (localName.equals("id")) {
            this.parser.setContentHandler(new IdHandler(this.parser, this));
        } else if (localName.equals("description")) {
            this.parser.setContentHandler(new DescriptionHandler(this.parser, this));
        } else if (localName.equals("appendActivityId")) {
            this.parser.setContentHandler(new AppendActivityHandler(this.parser, this));
        } else if (localName.equals("menubar")) {
            this.menubar = new MenuBarHandler(this.parser, this);
            this.parser.setContentHandler(this.menubar);
        } else if (localName.equals("initialTask")) {
            InitialTaskHandler handle = new InitialTaskHandler(this.parser, this);
            this.parser.setContentHandler(handle);
            this.initialTasks.add(handle);
        } else if (localName.equals("inactiveTask")) {
            InactiveTaskHandler handle = new InactiveTaskHandler(this.parser, this);
            this.parser.setContentHandler(handle);
            this.inactiveTasks.add(handle);
        } else if (localName.equals("exceptionGreeting")) {
            ExceptionGreetingHandler handle = new ExceptionGreetingHandler(this.parser, this);
            this.parser.setContentHandler(handle);
        }
    }

    public JMenuBar getMenuBar() throws ConfigurationException {
        if (this.menubar == null) {
            return EMPTY_MENU;
        }
        return this.menubar.getMenuBar();
    }

    public String[] getInitialTasks() throws ConfigurationException {
        String[] out = new String[this.initialTasks.size()];
        Iterator it = this.initialTasks.iterator();
        int i = 0;
        while (it.hasNext()) {
            InitialTaskHandler handler = (InitialTaskHandler)it.next();
            out[i++] = handler.getTaskId();
        }
        return out;
    }

    public String[] getInactiveTasks() throws ConfigurationException {
        String[] out = new String[this.inactiveTasks.size()];
        Iterator it = this.inactiveTasks.iterator();
        int i = 0;
        while (it.hasNext()) {
            InactiveTaskHandler handler = (InactiveTaskHandler)it.next();
            out[i++] = handler.getTaskId();
        }
        return out;
    }

    public String getId() {
        return this.id;
    }

    public String getAppendActivityId() {
        return this.appendActivityId;
    }

    class DescriptionHandler
    extends AbstractHandler {
        DescriptionHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            ActivityHandler.this.description = ActivityHandler.this.description + new String(ch, start, length);
        }
    }

    class AppendActivityHandler
    extends AbstractHandler {
        AppendActivityHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            ActivityHandler.this.appendActivityId = ActivityHandler.this.appendActivityId + new String(ch, start, length);
        }
    }

    class IdHandler
    extends AbstractHandler {
        IdHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            ActivityHandler.this.id = ActivityHandler.this.id + new String(ch, start, length);
        }
    }

    class TitleHandler
    extends AbstractHandler {
        TitleHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            ActivityHandler.this.title = ActivityHandler.this.title + new String(ch, start, length);
        }
    }
}

