/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.model.AllVTFactory;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.dataset.DataSetEventOrganizer;
import edu.sc.seis.fissuresUtil.dataset.Organizer;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionInterceptor;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporter;
import edu.sc.seis.fissuresUtil.exceptionHandler.FilterReporter;
import edu.sc.seis.fissuresUtil.exceptionHandler.GUIReporter;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.exceptionHandler.ServletReporter;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.fissuresUtil.netConnChecker.Checker;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnChecker;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatus;
import edu.sc.seis.fissuresUtil.netConnChecker.HTTPChecker;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSet;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.SimpleAuthenticator;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.Configure;
import edu.sc.seis.gee.task.AllTasks;
import edu.sc.seis.gee.task.StatusIndicator;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.VersionTask;
import edu.sc.seis.sod.Args;
import edu.sc.seis.sod.Start;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.omg.CORBA_2_3.ORB;
import org.xml.sax.InputSource;

public class CommonAccess {
    private static CommonAccess singleton = new CommonAccess();
    private Resetter resetter = new Resetter();
    private WorkerThreadPool resetPool = new WorkerThreadPool("Reset Pool", 1);
    private TauPUtil taup = null;
    private DataSet rootDataSet = null;
    private Configure configure = new Configure();
    protected static String cacheDirectory = null;
    protected static String cacheDirectoryString = System.getProperty("java.io.tmpdir") + File.separatorChar + "GEE_cache_" + System.getProperty("user.name").replaceAll("\\W", "_");
    private String[] args;
    private Checker connCheckers;
    private Properties props;
    private String initialActivity;
    ORB orb = null;
    FissuresNamingService fisName;
    Organizer organizer;
    private static Logger logger = Logger.getLogger(CommonAccess.class);

    private CommonAccess() {
        try {
            Properties props = new Properties();
            props.put("fissuresUtil.database.url", "jdbc:hsqldb:mem:SodDB");
            Start s = new Start(new Args(new String[]{"-f", "<stream>", "-q"}), new Start.InputSourceCreator(){

                public InputSource create() {
                    return new InputSource(new StringReader("<sod></sod>\n"));
                }
            }, props, true);
            s.setupDatabaseForUnitTests();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonAccess getCommonAccess() {
        return singleton;
    }

    public void resetActivity(String id) throws ConfigurationException {
        this.resetActivity(id, true);
    }

    public void resetActivity(String id, boolean inNewThread) throws ConfigurationException {
        this.getConfigure().setActivity(id);
        this.resetActivity(inNewThread);
    }

    public void resetActivity() throws ConfigurationException {
        this.resetActivity(true);
    }

    public void resetActivity(boolean inNewThread) throws ConfigurationException {
        JobTracker.getTracker().add((Job)this.resetter);
        if (inNewThread) {
            this.resetPool.invokeLater((Runnable)((Object)this.resetter));
        } else {
            this.resetter.reset();
        }
    }

    public JFrame getMainFrame() {
        return FrameManager.getManager().getCurrentMainFrame();
    }

    public Organizer getOrganizer() {
        if (this.organizer == null) {
            this.organizer = new DataSetEventOrganizer(this.getDataSetRoot());
        }
        return this.organizer;
    }

    public void setDataSetRoot(DataSet newDS) {
        if (newDS == null) {
            throw new RuntimeException("Should call clearDataSetRoot() to null the root dataset");
        }
        this.rootDataSet = newDS;
    }

    public void clearDataSetRoot() {
        this.rootDataSet = null;
        this.organizer = null;
    }

    public DataSet getDataSetRoot() {
        if (this.rootDataSet == null) {
            AuditInfo[] audit_info = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "created in memory.")};
            this.setDataSetRoot((DataSet)new MemoryDataSet("no id", "My Data", "nobody", audit_info));
        }
        return this.rootDataSet;
    }

    public ORB getORB() throws ConfigurationException {
        if (this.orb == null) {
            this.initORB();
        }
        return this.orb;
    }

    public TauPUtil getTravelTimeCalc() throws ConfigurationException {
        if (this.taup == null) {
            this.taup = TauPUtil.getTauPUtil();
        }
        return this.taup;
    }

    public FissuresNamingService getFissuresNamingService() throws ConfigurationException {
        if (this.fisName == null) {
            this.fisName = new FissuresNamingService(this.getORB());
            if (this.props.containsKey("edu.sc.seis.fissuresUtil.nameServiceCorbaLoc")) {
                this.fisName.setNameServiceCorbaLoc((String)this.props.get("edu.sc.seis.fissuresUtil.nameServiceCorbaLoc"));
            }
        }
        return this.fisName;
    }

    public TaskAction getTaskAction(String taskId) {
        return AllTasks.getTaskAction(taskId);
    }

    public TaskAction getTaskAction(Task t) {
        return AllTasks.getTaskAction(t);
    }

    public JPanel getDisplayArea() {
        return FrameManager.getManager().getCurrentPanel();
    }

    public Configure getConfigure() {
        return this.configure;
    }

    protected void init(String[] args) throws ConfigurationException {
        this.args = args;
        ArrayList<Class<NoNetworkException>> ignoreList = new ArrayList<Class<NoNetworkException>>();
        ignoreList.add(NoNetworkException.class);
        GlobalExceptionHandler.add((ExceptionReporter)new FilterReporter((ExceptionReporter)new GUIReporter(), ignoreList));
        if (System.getProperty("errorHandlerServlet") != null) {
            GlobalExceptionHandler.add((ExceptionReporter)new ServletReporter());
        }
        GlobalExceptionHandler.add((ExceptionInterceptor)new NetworkGateKeeper.SystemExceptionInterceptor());
        this.props = System.getProperties();
        String config = "edu/sc/seis/gee/data/conf/DefaultConfig.xml";
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equals("-props") || args[i].equals("-p")) {
                String prop = args[i + 1];
                try {
                    FileInputStream in = new FileInputStream(prop);
                    this.props.load(in);
                    in.close();
                }
                catch (FileNotFoundException f) {
                    System.err.println(" file missing " + f + " using defaults");
                }
                catch (IOException f) {
                    System.err.println(f.toString() + " using defaults");
                }
                continue;
            }
            if (args[i].equals("-config")) {
                config = args[i + 1];
                continue;
            }
            if (!args[i].equals("-activity")) continue;
            this.initialActivity = args[i + 1];
        }
        this.props.put("edu.sc.seis.gee.configuration", config);
        if (this.props.get("log4j.rootCategory") == null) {
            this.props.put("log4j.threshold", "OFF");
        }
        if (this.props.get("log4j.appender.R.File") == null) {
            this.props.put("log4j.appender.R.File", CommonAccess.getCacheDirectory() + "/GEE.log");
            File logFile = new File((String)this.props.get("log4j.appender.R.File"));
            logFile.getParentFile().mkdirs();
        }
        GlobalExceptionHandler.add((String)"Logger Output", (File)new File((String)this.props.get("log4j.appender.R.File")));
        PropertyConfigurator.configure((Properties)this.props);
        logger.info((Object)("Logging configured, logging to " + this.props.get("log4j.appender.R.File")));
        logger.info((Object)("Configuration: " + config));
        Authenticator.setDefault(new SimpleAuthenticator());
        this.initializeConnChecker();
    }

    private void initializeConnChecker() throws ConfigurationException {
        this.connCheckers = new Checker();
        this.connCheckers.add((ConnChecker)new HTTPChecker("Connection to public web site", "http://www.yahoo.com"));
        this.connCheckers.add((ConnChecker)new HTTPChecker("Connection to IRIS web site", "http://www.iris.edu"));
        this.connCheckers.add((ConnChecker)new HTTPChecker("Connection to IRIS web services", "http://service.iris.edu/fdsnws/event/1/query?eventid=3954686"));
    }

    public static String getCacheDirectory() {
        if (cacheDirectory == null) {
            CommonAccess.initCacheDirectory();
        }
        return cacheDirectory;
    }

    protected static synchronized void initCacheDirectory() {
        try {
            File cacheDir = new File(cacheDirectoryString);
            cacheDir.mkdirs();
            File versionFile = new File(cacheDir, "GEE_version");
            if (versionFile.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(versionFile));
                String fileVersion = in.readLine();
                if (!fileVersion.equals(VersionTask.getVersion())) {
                    CommonAccess.cleanCache();
                }
            } else {
                CommonAccess.cleanCache();
            }
        }
        catch (IOException e) {
            logger.error((Object)("unable to clean/create chache directory " + cacheDirectoryString), (Throwable)e);
        }
        cacheDirectory = cacheDirectoryString;
    }

    protected static void cleanCache() throws IOException {
        File cacheDir = new File(cacheDirectoryString);
        CommonAccess.deleteDirectory(cacheDir);
        cacheDir.mkdirs();
        File versionFile = new File(cacheDirectoryString, "GEE_version");
        BufferedWriter versionOut = new BufferedWriter(new FileWriter(versionFile));
        versionOut.write(VersionTask.getVersion());
        versionOut.close();
    }

    protected static void deleteDirectory(File dir) {
        File[] cacheFiles = dir.listFiles();
        for (int i = 0; i < cacheFiles.length; ++i) {
            if (cacheFiles[i].isDirectory()) {
                CommonAccess.deleteDirectory(cacheFiles[i]);
            }
            cacheFiles[i].delete();
        }
        dir.delete();
    }

    protected void initORB() throws ConfigurationException {
        if (this.orb != null) {
            throw new ConfigurationException("CommonAccess already configured");
        }
        this.orb = (ORB)org.omg.CORBA.ORB.init((String[])this.args, (Properties)this.props);
        AllVTFactory vt = new AllVTFactory();
        vt.register(this.orb);
        logger.info((Object)("initialize " + this.orb.getClass().toString() + " orb"));
    }

    public ConnStatus getNetworkStatus() {
        return this.connCheckers.getStatus();
    }

    public String getInitialActivity() {
        return this.initialActivity;
    }

    public void add(ConnChecker checker) {
        this.connCheckers.add(checker);
    }

    public Checker getChecker() {
        return this.connCheckers;
    }

    public void appQuit() {
        if (this.orb != null) {
            this.orb.shutdown(false);
        }
        System.exit(0);
    }

    private class Resetter
    extends AbstractJob {
        private JWindow window;

        public Resetter() {
            super("Activity Changer");
            this.window = new JWindow();
            this.setFinished();
            StatusIndicator indicator = new StatusIndicator("Switching activities");
            this.window.getContentPane().setLayout(new BorderLayout());
            indicator.setBorder(BorderFactory.createRaisedBevelBorder());
            this.window.getContentPane().add((Component)indicator, "Center");
            this.window.pack();
            this.window.setLocation(FrameManager.getLoc("center", this.window.getSize()));
            this.window.pack();
        }

        public void runJob() {
            try {
                this.reset();
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
        }

        public void reset() throws ConfigurationException {
            this.setStatus("Changing activity");
            JobTracker.getTracker().clearFinished();
            JFrame frame = FrameManager.getManager().reset();
            this.window.setVisible(true);
            CommonAccess.this.clearDataSetRoot();
            AllTasks.resetAll();
            Configure config = CommonAccess.this.getConfigure();
            String[] initialTasks = config.getInitialTasks();
            for (int i = 0; i < initialTasks.length; ++i) {
                logger.debug((Object)("Initial task: " + initialTasks[i]));
                TaskAction task = CommonAccess.this.getTaskAction(initialTasks[i]);
                if (task == null) continue;
                task.actionPerformed(new ActionEvent((Object)this, i, "setSize"));
            }
            String[] inactiveTasks = config.getInactiveTasks();
            for (int i = 0; i < inactiveTasks.length; ++i) {
                logger.debug((Object)("Inactive task: " + inactiveTasks[i]));
                TaskAction task = CommonAccess.this.getTaskAction(inactiveTasks[i]);
                if (task == null) continue;
                task.setEnabled(false);
            }
            this.window.setVisible(false);
            frame.setVisible(true);
            this.setFinished();
        }
    }
}

