/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalSModel;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class TauP_Create {
    public transient boolean verbose = false;
    String modelFilename = "iasp91.tvel";
    String overlayModelFilename = null;
    protected String velFileType = "tvel";
    String overlayVelFileType;
    String directory = ".";
    SlownessModel sMod;
    VelocityModel vMod;
    VelocityModel overlayVMod;
    TauModel tMod;
    boolean DEBUG = false;
    protected boolean GUI = false;
    protected Properties toolProps;
    protected boolean plotVmod = false;
    protected String plotVmodFilename;
    protected boolean plotSmod = false;
    protected String plotSmodFilename;
    protected boolean plotTmod = false;
    protected String plotTmodFilename;

    public TauP_Create() {
        Alert.setGUI(this.GUI);
        try {
            this.toolProps = PropertyLoader.load();
        }
        catch (Exception e) {
            Alert.warning("Unable to load properties, using defaults.", e.getMessage());
            this.toolProps = new Properties();
        }
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setModelFilename(String modelFilename) {
        this.modelFilename = modelFilename;
    }

    public String getModelFilename() {
        return this.modelFilename;
    }

    public String getVelFileType() {
        return this.velFileType;
    }

    public void setVelFileType(String type) {
        this.velFileType = type;
    }

    public void setDEBUG(boolean DEBUG) {
        this.DEBUG = DEBUG;
    }

    public boolean getDEBUG() {
        return this.DEBUG;
    }

    public void setVelocityModel(VelocityModel vMod) {
        this.vMod = vMod;
    }

    public void setMinDeltaP(float minDeltaP) {
        this.toolProps.setProperty("taup.create.minDeltaP", "" + minDeltaP);
    }

    public void setMaxDeltaP(float maxDeltaP) {
        this.toolProps.setProperty("taup.create.maxDeltaP", "" + maxDeltaP);
    }

    public void setMaxDepthInterval(float maxDepthInterval) {
        this.toolProps.setProperty("taup.create.maxDepthInterval", "" + maxDepthInterval);
    }

    public void setMaxRangeInterval(float maxRangeInterval) {
        this.toolProps.setProperty("taup.create.maxRangeInterval", "" + maxRangeInterval);
    }

    public void setMaxInterpError(float maxInterpError) {
        this.toolProps.setProperty("taup.create.maxInterpError", "" + maxInterpError);
    }

    public void setAllowInnerCoreS(boolean allowInnerCoreS) {
        this.toolProps.setProperty("taup.create.allowInnerCoreS", "" + allowInnerCoreS);
    }

    public void printUsage() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        System.out.println("Usage: " + className.toLowerCase() + " [arguments]");
        System.out.println("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        System.out.println("\nArguments are:");
        System.out.println("\n   To specify the velocity model:");
        System.out.println("-nd modelfile       -- \"named discontinuities\" velocity file");
        System.out.println("-tvel modelfile     -- \".tvel\" velocity file, ala ttimes\n");
        System.out.println("--vplot file.gmt     -- plot velocity as a GMT script\n");
        System.out.println("-debug              -- enable debugging output\n-verbose            -- enable verbose output\n-version            -- print the version\n-help               -- print this out, but you already know that!\n\n");
    }

    public static boolean dashEquals(String argName, String arg) {
        return TauP_Time.dashEquals(argName, arg);
    }

    protected String[] parseCmdLineArgs(String[] args) {
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_Create.dashEquals("help", args[i])) {
                this.printUsage();
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                return noComprendoArgs;
            }
            if (TauP_Create.dashEquals("version", args[i])) {
                System.out.println(BuildVersion.getDetailedVersion());
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                return noComprendoArgs;
            }
            if (TauP_Create.dashEquals("debug", args[i])) {
                this.verbose = true;
                this.DEBUG = true;
                continue;
            }
            if (TauP_Create.dashEquals("verbose", args[i])) {
                this.verbose = true;
                continue;
            }
            if (TauP_Create.dashEquals("gui", args[i])) {
                this.GUI = true;
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("p", args[i])) {
                try {
                    this.toolProps.load(new BufferedInputStream(new FileInputStream(args[i + 1])));
                    ++i;
                }
                catch (IOException e) {
                    noComprendoArgs[numNoComprendoArgs++] = args[i + 1];
                }
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("nd", args[i])) {
                this.velFileType = "nd";
                this.parseFileName(args[i + 1]);
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("tvel", args[i])) {
                this.velFileType = "tvel";
                this.parseFileName(args[i + 1]);
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("overlayND", args[i])) {
                this.overlayVelFileType = "nd";
                this.overlayModelFilename = args[i + 1];
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("vplot", args[i])) {
                this.plotVmod = true;
                this.plotVmodFilename = args[i + 1];
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("splot", args[i])) {
                this.plotSmod = true;
                this.plotSmodFilename = args[i + 1];
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("tplot", args[i])) {
                this.plotTmod = true;
                this.plotTmodFilename = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].startsWith("GB.")) {
                this.velFileType = "nd";
                this.parseFileName(args[i]);
                continue;
            }
            if (args[i].endsWith(".nd")) {
                this.velFileType = "nd";
                this.parseFileName(args[i]);
                continue;
            }
            if (args[i].endsWith(".tvel")) {
                this.velFileType = "tvel";
                this.parseFileName(args[i]);
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (this.modelFilename == null) {
            System.out.println("Velocity model not specified, use one of -nd or -tvel");
            this.printUsage();
            System.exit(1);
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) throws SlownessModelException, TauModelException {
        System.out.println("TauP_Create starting...");
        TauP_Create tauPCreate = new TauP_Create();
        String[] noComprendoArgs = tauPCreate.parseCmdLineArgs(args);
        TauP_Time.printNoComprendoArgs(noComprendoArgs);
        try {
            tauPCreate.loadVMod();
            tauPCreate.start();
            System.out.println("Done!");
        }
        catch (IOException e) {
            System.out.println("Tried to read!\n Caught IOException " + e.getMessage() + "\nCheck that the file exists and is readable.");
        }
        catch (VelocityModelException e) {
            System.out.println("Caught VelocityModelException " + e.getMessage() + "\nCheck your velocity model.");
        }
    }

    public void parseFileName(String modelFilename) {
        int j = modelFilename.lastIndexOf(System.getProperty("file.separator"));
        this.modelFilename = modelFilename.substring(j + 1);
        this.directory = j == -1 ? "." : modelFilename.substring(0, j);
    }

    public VelocityModel loadVMod() throws IOException, VelocityModelException {
        String file_sep = System.getProperty("file.separator");
        String filename = this.directory + file_sep + this.modelFilename;
        File f = new File(filename);
        if (this.verbose) {
            System.out.println("filename =" + this.directory + file_sep + this.modelFilename);
        }
        this.vMod = VelocityModel.readVelocityFile(filename, this.velFileType);
        if (this.vMod == null) {
            this.vMod = TauModelLoader.loadVelocityModel(this.modelFilename);
        }
        if (this.vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelFilename + ", tried internally and from file: " + f);
        }
        if (this.verbose) {
            System.out.println("Done reading velocity model.");
            System.out.println("Radius of model " + this.vMod.getModelName() + " is " + this.vMod.getRadiusOfEarth());
        }
        if (this.overlayModelFilename != null) {
            if (this.DEBUG) {
                System.out.println("orig model: " + this.vMod);
            }
            this.overlayVMod = VelocityModel.readVelocityFile(this.directory + file_sep + this.overlayModelFilename, this.overlayVelFileType);
            this.vMod = this.vMod.replaceLayers(this.overlayVMod.getLayers(), this.overlayVMod.getModelName(), true, true);
        }
        if (this.DEBUG) {
            System.out.println("velocity mode: " + this.vMod);
        }
        return this.vMod;
    }

    public TauModel createTauModel(VelocityModel vMod) throws VelocityModelException, SlownessModelException, TauModelException {
        if (vMod == null) {
            throw new IllegalArgumentException("vMod cannot be null");
        }
        if (!vMod.getSpherical()) {
            throw new SlownessModelException("Flat slowness model not yet implemented.");
        }
        SlownessModel.DEBUG = this.DEBUG;
        this.sMod = new SphericalSModel(vMod, Double.valueOf(this.toolProps.getProperty("taup.create.minDeltaP", "0.1")), Double.valueOf(this.toolProps.getProperty("taup.create.maxDeltaP", "11.0")), Double.valueOf(this.toolProps.getProperty("taup.create.maxDepthInterval", "115.0")), Double.valueOf(this.toolProps.getProperty("taup.create.maxRangeInterval", "2.5")) * Math.PI / 180.0, Double.valueOf(this.toolProps.getProperty("taup.create.maxInterpError", "0.05")), Boolean.valueOf(this.toolProps.getProperty("taup.create.allowInnerCoreS", "true")), 1.0E-16);
        if (this.verbose) {
            System.out.println("Parameters are:");
            System.out.println("taup.create.minDeltaP = " + this.sMod.getMinDeltaP() + " sec / radian");
            System.out.println("taup.create.maxDeltaP = " + this.sMod.getMaxDeltaP() + " sec / radian");
            System.out.println("taup.create.maxDepthInterval = " + this.sMod.getMaxDepthInterval() + " kilometers");
            System.out.println("taup.create.maxRangeInterval = " + this.sMod.getMaxRangeInterval() + " degrees");
            System.out.println("taup.create.maxInterpError = " + this.sMod.getMaxInterpError() + " seconds");
            System.out.println("taup.create.allowInnerCoreS = " + this.sMod.isAllowInnerCoreS());
            System.out.println("Slow model  " + this.sMod.getNumLayers(true) + " P layers," + this.sMod.getNumLayers(false) + " S layers");
        }
        if (this.DEBUG) {
            System.out.println(this.sMod);
        }
        TauModel.DEBUG = this.DEBUG;
        SlownessModel.DEBUG = this.DEBUG;
        return new TauModel(this.sMod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SlownessModelException, TauModelException {
        try {
            if (this.plotVmod || this.plotSmod || this.plotTmod) {
                if (this.plotVmod) {
                    this.vMod.printGMT(this.plotVmodFilename);
                }
            } else {
                String file_sep = System.getProperty("file.separator");
                TauModel tMod = this.createTauModel(this.vMod);
                if (this.DEBUG) {
                    System.out.println("Done calculating Tau branches.");
                }
                if (this.DEBUG) {
                    tMod.print();
                }
                String outFile = this.directory.equals(".") ? this.directory + file_sep + this.vMod.getModelName() + ".taup" : this.vMod.getModelName() + ".taup";
                tMod.writeModel(outFile);
                if (this.verbose) {
                    System.out.println("Done Saving " + outFile);
                }
            }
        }
        catch (IOException e) {
            System.out.println("Tried to write!\n Caught IOException " + e.getMessage() + "\nDo you have write permission in this directory?");
        }
        catch (VelocityModelException e) {
            System.out.println("Caught VelocityModelException " + e.getMessage());
        }
        finally {
            if (this.verbose) {
                System.out.println("Done!");
            }
        }
    }
}

