/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TimeDist;

public class Arrival {
    private SeismicPhase phase;
    private double time;
    private double dist;
    private double rayParam;
    private int rayParamIndex;
    private String name;
    private String puristName;
    private double sourceDepth;
    private TimeDist[] pierce;
    private TimeDist[] path;
    private double incidentAngle;
    private double takeoffAngle;
    protected static final double TWOPI = Math.PI * 2;
    protected static final double DtoR = Math.PI / 180;
    protected static final double RtoD = 57.29577951308232;

    public Arrival(SeismicPhase phase, double time, double dist, double rayParam, int rayParamIndex, String name, String puristName, double sourceDepth) {
        this(phase, time, dist, rayParam, rayParamIndex, name, puristName, sourceDepth, phase.calcTakeoffAngle(rayParam), phase.calcIncidentAngle(rayParam));
    }

    public Arrival(SeismicPhase phase, double time, double dist, double rayParam, int rayParamIndex, String name, String puristName, double sourceDepth, double takeoffAngle, double incidentAngle) {
        if (Double.isNaN(time)) {
            throw new IllegalArgumentException("Time cannot be NaN");
        }
        if (rayParamIndex < 0) {
            throw new IllegalArgumentException("rayParamIndex cannot be negative: " + rayParamIndex);
        }
        this.phase = phase;
        this.time = time;
        this.dist = dist;
        this.rayParam = rayParam;
        this.rayParamIndex = rayParamIndex;
        this.name = name;
        this.puristName = puristName;
        this.sourceDepth = sourceDepth;
        this.takeoffAngle = takeoffAngle;
        this.incidentAngle = incidentAngle;
    }

    public SeismicPhase getPhase() {
        return this.phase;
    }

    public double getTime() {
        return this.time;
    }

    public double getDist() {
        return this.dist;
    }

    public double getDistDeg() {
        return 57.29577951308232 * this.getDist();
    }

    public double getModuloDist() {
        double moduloDist = this.getDist() % (Math.PI * 2);
        if (moduloDist > Math.PI) {
            moduloDist = Math.PI * 2 - moduloDist;
        }
        return moduloDist;
    }

    public double getModuloDistDeg() {
        double moduloDist = 57.29577951308232 * this.getDist() % 360.0;
        if (moduloDist > 180.0) {
            moduloDist = 360.0 - moduloDist;
        }
        return moduloDist;
    }

    public double getRayParam() {
        return this.rayParam;
    }

    public double getRayParamDeg() {
        return this.getRayParam() / 57.29577951308232;
    }

    public double getIncidentAngle() {
        return this.incidentAngle;
    }

    public double getTakeoffAngle() {
        return this.takeoffAngle;
    }

    public int getRayParamIndex() {
        return this.rayParamIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getPuristName() {
        return this.puristName;
    }

    public double getSourceDepth() {
        return this.sourceDepth;
    }

    public TimeDist[] getPierce() {
        if (this.pierce == null) {
            this.pierce = this.getPhase().calcPierceTimeDist(this).toArray(new TimeDist[0]);
        }
        return this.pierce;
    }

    public TimeDist[] getPath() {
        if (this.path == null) {
            this.path = this.getPhase().calcPathTimeDist(this).toArray(new TimeDist[0]);
        }
        return this.path;
    }

    public String toString() {
        String desc = Outputs.formatDistance(this.getModuloDistDeg()) + Outputs.formatDepth(this.getSourceDepth()) + "   " + this.getName() + "  " + Outputs.formatTime(this.getTime()) + "  " + Outputs.formatRayParam(Math.PI / 180 * this.getRayParam()) + "  " + Outputs.formatDistance(this.getTakeoffAngle()) + " " + Outputs.formatDistance(this.getIncidentAngle()) + " " + Outputs.formatDistance(this.getDistDeg()) + " " + this.getRayParamIndex();
        desc = this.getName().equals(this.getPuristName()) ? desc + "   = " : desc + "   * ";
        desc = desc + this.getPuristName();
        return desc;
    }

    public int getNumPiercePoints() {
        if (this.pierce != null) {
            return this.pierce.length;
        }
        return 0;
    }

    public int getNumPathPoints() {
        if (this.path != null) {
            return this.path.length;
        }
        return 0;
    }

    public TimeDist getPiercePoint(int i) {
        return this.pierce[i];
    }

    public TimeDist getFirstPiercePoint(double depth) {
        for (int i = 0; i < this.pierce.length; ++i) {
            if (this.pierce[i].getDepth() != depth) continue;
            return this.pierce[i];
        }
        throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + depth);
    }

    public TimeDist getLastPiercePoint(double depth) {
        TimeDist piercepoint = null;
        for (int i = 0; i < this.pierce.length; ++i) {
            if (this.pierce[i].getDepth() != depth) continue;
            piercepoint = this.pierce[i];
        }
        if (piercepoint == null) {
            throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + depth);
        }
        return piercepoint;
    }

    public TimeDist getPathPoint(int i) {
        return this.path[i];
    }
}

