/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.sc.seis.fissuresUtil.exceptionHandler.Extractor;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.StAXFileWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtil {
    private static boolean needToRegisteredWithGEH = true;
    private static XMLOutputFactory staxOutputFactory;
    private static XMLInputFactory staxInputFactory;
    private static XMLEventFactory staxEventFactory;
    public static QName emptyName;
    private static CachedXPathAPI xpath;

    public static void registerExtractorWithExceptionHandler() {
        if (needToRegisteredWithGEH) {
            needToRegisteredWithGEH = false;
            GlobalExceptionHandler.add(new Extractor(){

                @Override
                public boolean canExtract(Throwable throwable) {
                    return throwable instanceof XMLStreamException;
                }

                @Override
                public String extract(Throwable throwable) {
                    String out = "";
                    if (throwable instanceof XMLStreamException) {
                        XMLStreamException mie = (XMLStreamException)throwable;
                        out = out + "XML Location: " + mie.getLocation() + "\n";
                    }
                    return out;
                }

                @Override
                public Throwable getSubThrowable(Throwable throwable) {
                    if (throwable instanceof XMLStreamException) {
                        return ((XMLStreamException)throwable).getNestedException();
                    }
                    return null;
                }
            });
        }
    }

    public static void writeTextElement(XMLStreamWriter writer, String elementName, String value) throws XMLStreamException {
        writer.writeStartElement(elementName);
        writer.writeCharacters(value);
        XMLUtil.writeEndElementWithNewLine(writer);
    }

    public static void writeEndElementWithNewLine(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        writer.writeCharacters("\n");
    }

    public static XMLStreamReader getXMLStreamReader(File file) throws XMLStreamException, FileNotFoundException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        return XMLUtil.getStaxInputFactory().createXMLStreamReader(inputStream);
    }

    public static StAXFileWriter openXMLFileForAppending(File file) throws IOException, XMLStreamException {
        FileReader fileReader = new FileReader(file);
        XMLStreamReader xmlReader = XMLUtil.getXMLStreamReader(file);
        StAXFileWriter staxWriter = new StAXFileWriter(file);
        QName rootTag = emptyName;
        int i = xmlReader.next();
        while (xmlReader.hasNext()) {
            if (i != 2 || !xmlReader.getName().equals(rootTag)) {
                if (i == 1 && rootTag.equals(emptyName)) {
                    rootTag = xmlReader.getName();
                }
                XMLUtil.translateAndWrite(xmlReader, staxWriter.getStreamWriter());
            }
            i = xmlReader.next();
        }
        xmlReader.close();
        fileReader.close();
        return staxWriter;
    }

    public static void translateAndWrite(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        XMLUtil.translateAndWrite(reader, writer, true);
    }

    public static void translateAndWrite(XMLStreamReader reader, XMLStreamWriter writer, boolean newlinesAfterEndElements) throws XMLStreamException {
        int type = reader.getEventType();
        switch (type) {
            case 7: {
                writer.writeStartDocument(reader.getEncoding(), reader.getVersion());
                break;
            }
            case 8: {
                writer.writeEndDocument();
                break;
            }
            case 1: {
                int i;
                String prefix = reader.getPrefix() == null ? "" : reader.getPrefix();
                writer.writeStartElement(prefix, reader.getLocalName(), reader.getNamespaceURI());
                for (i = 0; i < reader.getNamespaceCount(); ++i) {
                    writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                }
                for (i = 0; i < reader.getAttributeCount(); ++i) {
                    if (reader.getAttributePrefix(i) != null) {
                        writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                        continue;
                    }
                    if (reader.getAttributeNamespace(i) != null) {
                        writer.writeAttribute(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                        continue;
                    }
                    writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                }
                break;
            }
            case 2: {
                if (newlinesAfterEndElements) {
                    XMLUtil.writeEndElementWithNewLine(writer);
                    break;
                }
                writer.writeEndElement();
                break;
            }
            case 3: {
                writer.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                break;
            }
            case 4: {
                if (reader.getText().equals("\n")) break;
                writer.writeCharacters(reader.getText());
                break;
            }
            case 5: {
                writer.writeComment(reader.getText());
            }
        }
    }

    public static String readEvent(XMLStreamReader reader) {
        StringBuffer buf = new StringBuffer();
        int type = reader.getEventType();
        switch (type) {
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                int i;
                buf.append('<');
                if (reader.getPrefix() != null && reader.getPrefix() != "") {
                    buf.append(reader.getPrefix() + ":");
                }
                buf.append(reader.getLocalName());
                for (i = 0; i < reader.getNamespaceCount(); ++i) {
                    buf.append(" xmlns:" + reader.getNamespacePrefix(i) + "=\"" + reader.getNamespaceURI(i) + '\"');
                }
                for (i = 0; i < reader.getAttributeCount(); ++i) {
                    buf.append(' ');
                    if (reader.getAttributePrefix(i) != null && reader.getAttributePrefix(i) != "") {
                        buf.append(reader.getAttributePrefix(i) + ":");
                    }
                    buf.append(reader.getAttributeLocalName(i) + "=\"" + reader.getAttributeValue(i) + '\"');
                }
                buf.append('>');
                break;
            }
            case 2: {
                buf.append("</");
                if (reader.getPrefix() != null && reader.getPrefix() != "") {
                    buf.append(reader.getPrefix() + ":");
                }
                buf.append(reader.getLocalName() + '>');
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                buf.append(reader.getText());
                break;
            }
        }
        return buf.toString();
    }

    public static void gotoNextStartElement(XMLStreamReader parser, String name) throws XMLStreamException {
        while (parser.hasNext()) {
            int event = parser.next();
            if (event != 1 || !parser.getLocalName().equals(name)) continue;
            return;
        }
    }

    public static void getNextStartElement(XMLStreamReader parser) throws XMLStreamException {
        while (parser.hasNext()) {
            int event = parser.next();
            if (event != 1) continue;
            return;
        }
    }

    public static XMLOutputFactory getStaxOutputFactory() {
        if (staxOutputFactory == null) {
            staxOutputFactory = XMLOutputFactory.newInstance();
        }
        return staxOutputFactory;
    }

    public static XMLInputFactory getStaxInputFactory() {
        if (staxInputFactory == null) {
            staxInputFactory = XMLInputFactory.newInstance();
        }
        return staxInputFactory;
    }

    public static XMLEventFactory getStaxEventFactory() {
        if (staxEventFactory == null) {
            staxEventFactory = XMLEventFactory.newInstance();
        }
        return staxEventFactory;
    }

    public static Element createTextElement(Document doc, String elementName, String value) {
        Element element = doc.createElement(elementName);
        Text text = doc.createTextNode(value);
        element.appendChild(text);
        return element;
    }

    public static NodeList evalNodeList(Node context, String path) {
        try {
            XObject xobj = xpath.eval(context, path);
            if (xobj != null && xobj.getType() == 4) {
                return xobj.nodelist();
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public static String evalString(Node context, String path) {
        try {
            return xpath.eval(context, path).str();
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public static String getText(Element config) {
        if (config == null) {
            return new String("");
        }
        NodeList children = config.getChildNodes();
        String out = "";
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Text)) continue;
            out = out + node.getNodeValue();
        }
        return out;
    }

    public static Element getElement(Element config, String elementName) {
        NodeList children = config.getChildNodes();
        for (int counter = 0; counter < children.getLength(); ++counter) {
            Node node = children.item(counter);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals(elementName)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element[] getElementArray(Element config, String elementName) {
        NodeList children = config.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int counter = 0; counter < children.getLength(); ++counter) {
            Node node = children.item(counter);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals(elementName)) continue;
            arrayList.add(node);
        }
        Element[] elementArray = new Element[arrayList.size()];
        elementArray = arrayList.toArray(elementArray);
        return elementArray;
    }

    public static String[] getAllAsStrings(Element config, String path) {
        NodeList nodes = XMLUtil.evalNodeList(config, path);
        if (nodes == null) {
            return new String[0];
        }
        String[] out = new String[nodes.getLength()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = nodes.item(i).getNodeValue();
        }
        return out;
    }

    public static String getUniqueName(String[] nameList, String name) {
        int counter = 0;
        for (int i = 0; i < nameList.length; ++i) {
            if (nameList[i].indexOf(name) == -1) continue;
            ++counter;
        }
        if (counter == 0) {
            return name;
        }
        return name + "_" + (counter + 1);
    }

    public static Element evalElement(Node context, String path) {
        NodeList nList = XMLUtil.evalNodeList(context, path);
        if (nList != null && nList.getLength() != 0) {
            return (Element)nList.item(0);
        }
        return null;
    }

    static {
        XMLUtil.registerExtractorWithExceptionHandler();
        emptyName = new QName("", "thisisareallyuglynameforatagthathopefullynoonewilleveruse");
        xpath = new CachedXPathAPI();
    }
}

