/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.database.DBDataCenter;
import edu.sc.seis.fissuresUtil.database.LocalDataCenterCallBack;
import edu.sc.seis.fissuresUtil.time.CoverageTool;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCDataSetSeismogram
extends DataSetSeismogram
implements LocalDataCenterCallBack,
Cloneable {
    private DataCenterOperations dataCenterOps;
    private static Logger logger = LoggerFactory.getLogger((String)DCDataSetSeismogram.class.getName());

    public DCDataSetSeismogram(RequestFilter rf, DataCenterOperations dco) {
        this(rf, dco, null);
    }

    public DCDataSetSeismogram(RequestFilter rf, DataCenterOperations dco, DataSet ds) {
        this(rf, dco, ds, null);
    }

    public DCDataSetSeismogram(RequestFilter rf, DataCenterOperations dco, DataSet ds, String name) {
        super(ds, name);
        this.requestFilter = rf;
        this.dataCenterOps = dco;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieveData(SeisDataChangeListener dataListener) {
        ArrayList<LocalSeismogramImpl> existingSeismos = new ArrayList<LocalSeismogramImpl>();
        List list = this.seisCache;
        synchronized (list) {
            Iterator it = this.seisCache.iterator();
            while (it.hasNext()) {
                LocalSeismogramImpl current = (LocalSeismogramImpl)((SoftReference)it.next()).get();
                if (current == null) continue;
                if (DCDataSetSeismogram.intersects(this.requestFilter, current)) {
                    existingSeismos.add(current);
                    continue;
                }
                it.remove();
            }
        }
        RequestFilter[] uncovered = new RequestFilter[]{this.requestFilter};
        if (existingSeismos.size() > 0) {
            LocalSeismogramImpl[] cachedSeismos = new LocalSeismogramImpl[existingSeismos.size()];
            cachedSeismos = existingSeismos.toArray(cachedSeismos);
            this.pushData(cachedSeismos, dataListener);
            uncovered = CoverageTool.notCovered(uncovered, cachedSeismos);
        }
        if (this.dataCenterOps instanceof DBDataCenter && uncovered.length > 0) {
            ((DBDataCenter)this.dataCenterOps).request_seismograms(uncovered, this, dataListener, false, ClockUtil.now().getFissuresTime());
        } else {
            this.finished(dataListener);
        }
    }

    public static boolean intersects(RequestFilter rf, LocalSeismogramImpl seis) {
        MicroSecondDate rfBegin = new MicroSecondDate(rf.start_time);
        MicroSecondDate rfEnd = new MicroSecondDate(rf.end_time);
        return seis.getBeginTime().before((Date)rfEnd) && seis.getEndTime().after((Date)rfBegin) || seis.getEndTime().after((Date)rfBegin) && seis.getBeginTime().before((Date)rfEnd);
    }
}

