/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.time;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import edu.sc.seis.fissuresUtil.time.SortTool;
import java.util.ArrayList;
import java.util.Date;

public class CoverageTool {
    public static RequestFilter[] notCovered(RequestFilter[] neededFilters, LocalSeismogramImpl[] existingFilters) {
        if (existingFilters.length == 0) {
            return neededFilters;
        }
        LocalSeismogramImpl[] sorted = SortTool.byBeginTimeAscending(existingFilters);
        MicroSecondTimeRange[] ranges = new MicroSecondTimeRange[sorted.length];
        for (int i = 0; i < sorted.length; ++i) {
            ranges[i] = new MicroSecondTimeRange(sorted[i]);
        }
        return CoverageTool.notCovered(neededFilters, ranges);
    }

    public static RequestFilter[] notCovered(RequestFilter[] neededFilters, RequestFilter[] existingFilters) {
        if (existingFilters.length == 0) {
            return neededFilters;
        }
        RequestFilter[] sorted = SortTool.byBeginTimeAscending(existingFilters);
        MicroSecondTimeRange[] ranges = new MicroSecondTimeRange[sorted.length];
        for (int i = 0; i < sorted.length; ++i) {
            ranges[i] = new MicroSecondTimeRange(sorted[i]);
        }
        return CoverageTool.notCovered(neededFilters, ranges);
    }

    public static RequestFilter[] notCovered(RequestFilter[] filters, MicroSecondTimeRange[] timeRanges) {
        ArrayList<RequestFilter> unsatisfied = new ArrayList<RequestFilter>();
        timeRanges = ReduceTool.merge(timeRanges);
        timeRanges = SortTool.byBeginTimeAscending(timeRanges);
        for (int i = 0; i < filters.length; ++i) {
            MicroSecondDate rfStart = new MicroSecondDate(filters[i].start_time);
            MicroSecondDate rfEnd = new MicroSecondDate(filters[i].end_time);
            for (int j = 0; j < timeRanges.length; ++j) {
                MicroSecondDate trStart = timeRanges[j].getBeginTime();
                MicroSecondDate trEnd = timeRanges[j].getEndTime();
                if (!trStart.before((Date)rfEnd) || !trEnd.after((Date)rfStart)) continue;
                if (ReduceTool.equalsOrBefore(trStart, rfStart)) {
                    rfStart = trEnd;
                } else {
                    unsatisfied.add(new RequestFilter(filters[i].channel_id, rfStart.getFissuresTime(), trStart.getFissuresTime()));
                    rfStart = trEnd;
                }
                if (ReduceTool.equalsOrAfter(trEnd, rfEnd)) break;
            }
            if (!rfEnd.after((Date)rfStart)) continue;
            unsatisfied.add(new RequestFilter(filters[i].channel_id, rfStart.getFissuresTime(), rfEnd.getFissuresTime()));
        }
        return unsatisfied.toArray(new RequestFilter[unsatisfied.size()]);
    }

    public static RequestFilter[] notCoveredIgnoreGaps(RequestFilter[] filters, MicroSecondTimeRange[] timeRanges) {
        if (timeRanges.length != 0) {
            timeRanges = SortTool.byBeginTimeAscending(timeRanges);
            timeRanges = new MicroSecondTimeRange[]{new MicroSecondTimeRange(timeRanges[0], timeRanges[timeRanges.length - 1])};
        }
        return CoverageTool.notCovered(filters, timeRanges);
    }
}

