/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.simple.SimpleEventClient;
import edu.sc.seis.fissuresUtil.simple.Tester;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedEventClient
extends SimpleEventClient {
    private static final TimeInterval ONE_DAY = new TimeInterval(1.0, UnitImpl.DAY);
    private static Logger logger = LoggerFactory.getLogger(ThreadedEventClient.class);

    public ThreadedEventClient() {
    }

    public ThreadedEventClient(String serverDNS, String serverName) {
        super(serverDNS, serverName);
    }

    @Override
    public void exercise() {
        super.exercise();
        try {
            Tester.runAll(this.createRunnables());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public Runnable[] createRunnables() {
        Runnable[] runnables = new Runnable[]{new QueryEvents(), new KnownCatalogs(), new KnownContributors(), new GetByName()};
        return runnables;
    }

    public static void amain(String[] args) {
        Initializer.init(args);
        try {
            Tester.runAll(new ThreadedEventClient().createRunnables());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Initializer.init(args);
        Properties props = Initializer.getProps();
        try {
            ThreadedEventClient client = props.containsKey("serverName") && props.containsKey("serverDNS") ? new ThreadedEventClient(props.getProperty("serverDNS"), props.getProperty("serverName")) : new ThreadedEventClient();
            Tester.runAll(client.createRunnables());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private class GetByName
    implements Runnable {
        private GetByName() {
        }

        @Override
        public void run() {
            ThreadedEventClient.this.finder.get_by_name("11481542");
        }

        public String toString() {
            return "get_by_name";
        }
    }

    private class KnownContributors
    implements Runnable {
        private KnownContributors() {
        }

        @Override
        public void run() {
            ThreadedEventClient.this.finder.known_contributors();
        }

        public String toString() {
            return "known_contributors";
        }
    }

    private class KnownCatalogs
    implements Runnable {
        private KnownCatalogs() {
        }

        @Override
        public void run() {
            ThreadedEventClient.this.finder.known_catalogs();
        }

        public String toString() {
            return "known_catalogs";
        }
    }

    private class QueryEvents
    implements Runnable {
        private QueryEvents() {
        }

        @Override
        public void run() {
            ThreadedEventClient.this.query_events();
        }

        public String toString() {
            return "query_events";
        }
    }
}

