/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.rt130.PropParser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XYReader {
    public static final String XY_FILE_LOC = "XYFile";
    private static final Logger logger = LoggerFactory.getLogger(XYReader.class);

    public static Map read(BufferedReader reader) throws IOException {
        String line;
        HashMap<String, Location> locs = new HashMap<String, Location>();
        int num = 1;
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, " ");
            Location loc = new Location();
            loc.longitude = Float.parseFloat(st.nextToken());
            loc.latitude = Float.parseFloat(st.nextToken());
            loc.elevation = new QuantityImpl((double)Float.parseFloat(st.nextToken()), (Unit)UnitImpl.METER);
            loc.depth = new QuantityImpl(0.0, (Unit)UnitImpl.METER);
            loc.type = LocationType.GEOGRAPHIC;
            String stationCode = st.nextToken();
            if (locs.containsKey(stationCode)) {
                System.err.println("Inserting second location for '" + stationCode + "' on line " + num);
            }
            locs.put(stationCode, loc);
            logger.debug("Read in location for " + stationCode + " " + XYReader.toString(loc));
            ++num;
        }
        return locs;
    }

    public static String toString(Location loc) {
        return "Lat: " + loc.latitude + " Long: " + loc.longitude + " Elev: " + loc.elevation;
    }

    public static Map create(Properties props) throws IOException {
        PropParser pp = new PropParser(props);
        return XYReader.read(new BufferedReader(new FileReader(pp.getPath(XY_FILE_LOC))));
    }
}

