/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.model.MicroSecondDate;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryNameParser {
    private static Pattern racsDasDir = Pattern.compile("[A-Z0-9]{4}_\\d{4}_\\d{3}_\\d{2}_\\d{2}\\.\\d");
    private static Pattern dumpyDasDir = Pattern.compile("[A-Z0-9]{4}_\\d{4}_\\d{3}");
    private static Pattern dayDir = Pattern.compile("\\d{7}");
    private static Calendar dirParserCal = Calendar.getInstance();
    private static final Logger logger;

    public static MicroSecondDate getTime(File file) {
        String name = file.getName();
        if (name.startsWith(".")) {
            return null;
        }
        if (dumpyDasDir.matcher(name).matches()) {
            return DirectoryNameParser.getTimeFromDumppyDirectory(file);
        }
        if (dayDir.matcher(name).matches()) {
            return DirectoryNameParser.getTimeFromDayDirectory(file);
        }
        if (racsDasDir.matcher(name).matches()) {
            return DirectoryNameParser.getTimeFromDumppyDirectory(file);
        }
        logger.warn("Directory '" + file + "' did not match any known format.");
        return null;
    }

    private static MicroSecondDate getTimeFromDumppyDirectory(File file) {
        String yearAndDay = file.getName().substring(5, 13);
        int year = Integer.valueOf(yearAndDay.substring(0, 4));
        int dayOfYear = Integer.valueOf(yearAndDay.substring(5, 8));
        return DirectoryNameParser.makeMicroSecondFromDayAndYear(year, dayOfYear);
    }

    private static MicroSecondDate getTimeFromDayDirectory(File file) {
        String yearAndDay = file.getName();
        int year = Integer.valueOf(yearAndDay.substring(0, 4));
        int dayOfYear = Integer.valueOf(yearAndDay.substring(4, 7));
        return DirectoryNameParser.makeMicroSecondFromDayAndYear(year, dayOfYear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MicroSecondDate makeMicroSecondFromDayAndYear(int year, int dayOfYear) {
        Date d;
        Calendar calendar = dirParserCal;
        synchronized (calendar) {
            dirParserCal.set(1, year);
            dirParserCal.set(6, dayOfYear);
            d = dirParserCal.getTime();
        }
        return new MicroSecondDate(d);
    }

    static {
        dirParserCal.setTimeZone(TimeZone.getTimeZone("GMT"));
        dirParserCal.set(11, 0);
        dirParserCal.set(12, 0);
        dirParserCal.set(13, 0);
        dirParserCal.set(14, 0);
        logger = LoggerFactory.getLogger(DirectoryNameParser.class);
    }
}

