/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.layers;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.EQDataEvent;
import edu.sc.seis.fissuresUtil.display.EQSelectionEvent;
import edu.sc.seis.fissuresUtil.display.EQSelectionListener;
import edu.sc.seis.fissuresUtil.display.EventDataListener;
import edu.sc.seis.fissuresUtil.map.LayerProjectionUpdater;
import edu.sc.seis.fissuresUtil.map.layers.MouseAdapterLayer;
import edu.sc.seis.fissuresUtil.map.layers.StationLayer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class DistanceLayer
extends MouseAdapterLayer
implements EQSelectionListener,
EventDataListener {
    private static String[] modeList = new String[]{SelectMouseMode.modeID};
    private OMGraphicList distCircles = new OMGraphicList();
    private MapBean mapBean;
    private EventAccessOperations[] events;

    public DistanceLayer(MapBean mapBean) {
        this.mapBean = mapBean;
        this.setName("Distance Information Layer");
    }

    @Override
    public void projectionChanged(ProjectionEvent e) {
        LayerProjectionUpdater.update(e, this.distCircles, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eqSelectionChanged(EQSelectionEvent eqSelectionEvent) {
        OMGraphicList oMGraphicList = this.distCircles;
        synchronized (oMGraphicList) {
            this.distCircles.clear();
        }
        try {
            this.events = eqSelectionEvent.getEvents();
            Origin origin = this.events[0].get_preferred_origin();
            LatLonPoint llp = new LatLonPoint(origin.getLocation().latitude, origin.getLocation().longitude);
            this.makeDistCircles(llp);
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void eventDataAppended(EQDataEvent eqDataEvent) {
    }

    @Override
    public void eventDataChanged(EQDataEvent eqDataEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventDataCleared() {
        OMGraphicList oMGraphicList = this.distCircles;
        synchronized (oMGraphicList) {
            this.distCircles.clear();
        }
        this.events = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDistCircle(LatLonPoint llp, double radiusDegrees, Paint p) {
        OMGraphicList oMGraphicList = this.distCircles;
        synchronized (oMGraphicList) {
            LatLonPoint[] labelPoints;
            DistCircle circle = new DistCircle(llp, radiusDegrees, p);
            this.distCircles.add((OMGraphic)circle);
            labelPoints = new LatLonPoint[]{this.makeTextLabelLatLon(llp, radiusDegrees, 0.0), this.makeTextLabelLatLon(llp, -radiusDegrees, 0.0), new WrapAroundLatLonPoint(-labelPoints[0].getLatitude(), labelPoints[0].getLongitude() + 180.0f), new WrapAroundLatLonPoint(-labelPoints[1].getLatitude(), labelPoints[1].getLongitude() + 180.0f)};
            int labelInt = (int)radiusDegrees;
            for (int i = 0; i < labelPoints.length; ++i) {
                if (i > 1) {
                    labelInt = 180 - (int)radiusDegrees;
                }
                TextLabel label = new TextLabel(this.adjustLatLonByPixels(labelPoints[i], 0, 6), Integer.toString(labelInt));
                this.distCircles.add((OMGraphic)label);
            }
        }
    }

    private void makeDistCircles(LatLonPoint llp) {
        this.makeDistCircle(llp, 30.0, new Color(255, 255, 255));
        this.makeDistCircle(llp, 60.0, new Color(255, 191, 255));
        this.makeDistCircle(llp, 90.0, new Color(255, 127, 255));
        this.makeDistCircle(llp, 120.0, new Color(255, 64, 255));
        this.makeDistCircle(llp, 150.0, new Color(255, 0, 255));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        OMGraphicList oMGraphicList = this.distCircles;
        synchronized (oMGraphicList) {
            this.distCircles.render(g);
        }
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        if (this.events != null && this.events[0] != null) {
            try {
                LatLonPoint llp = this.mapBean.getCoordinates(e);
                double dist = StationLayer.calcDistEventFromLocation(llp.getLatitude(), llp.getLongitude(), this.events[0]);
                String message = "Distance from Event: " + dist + " deg";
                this.fireRequestInfoLine(message);
            }
            catch (NoPreferredOrigin noPreferredOrigin) {}
        } else {
            this.fireRequestInfoLine(" ");
        }
        return false;
    }

    private LatLonPoint makeTextLabelLatLon(LatLonPoint center, double degreesNorth, double degreesEast) {
        WrapAroundLatLonPoint textLLP = new WrapAroundLatLonPoint((double)center.getLatitude() + degreesNorth, (double)center.getLongitude() + degreesEast);
        return textLLP;
    }

    private LatLonPoint adjustLatLonByPixels(LatLonPoint latLon, int pixelsLeft, int pixelsUp) {
        Projection proj = this.getProjection();
        Point XYPoint = proj.forward(latLon);
        XYPoint.setLocation(XYPoint.getX() + (double)pixelsLeft, XYPoint.getY() - (double)pixelsUp);
        LatLonPoint llp = proj.inverse(XYPoint);
        return llp;
    }

    @Override
    public String[] getMouseModeServiceList() {
        return modeList;
    }

    private class WrapAroundLatLonPoint
    extends LatLonPoint {
        public WrapAroundLatLonPoint(double lat, double lon) {
            super(0.0f, 0.0f);
            if (lat > 90.0) {
                lat = 180.0 - lat;
                lon = lon > 0.0 ? (lon -= 180.0) : (lon += 180.0);
            }
            LatLonPoint latLon = new LatLonPoint(lat, lon);
            super.setLatLon(latLon);
        }
    }

    private class TextLabel
    extends OMText {
        public TextLabel(LatLonPoint position, String text) {
            super(position.getLatitude(), position.getLongitude(), text, 1);
            this.setFont(new Font("Serif", 1, 14));
            this.setLinePaint(Color.WHITE);
        }
    }

    private class DistCircle
    extends OMCircle {
        public DistCircle(LatLonPoint llp, double radiusDegrees, Paint p) {
            super(llp.getLatitude(), llp.getLongitude(), (float)radiusDegrees, Length.DECIMAL_DEGREE);
            this.setLinePaint(p);
            this.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
            this.generate(DistanceLayer.this.getProjection());
        }
    }
}

