/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.graphics;

import com.bbn.openmap.Layer;
import com.bbn.openmap.omGraphics.OMPoly;
import edu.iris.Fissures.IfNetwork.Station;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.map.graphics.FissuresGraphic;
import java.awt.Color;

public class OMStation
extends OMPoly
implements FissuresGraphic {
    private boolean selected = false;
    private boolean isUp = false;
    private Station station;
    private Color defaultColor;
    public static int SHIFT = 5;
    private static int[] xPoints = new int[]{-SHIFT, 0, SHIFT};
    private static int[] yPoints = new int[]{SHIFT, -SHIFT, SHIFT};

    public OMStation(Station stat, Layer stationLayer) {
        super(stat.getLocation().latitude, stat.getLocation().longitude, xPoints, yPoints, 0);
        this.station = stat;
        this.setDefaultColor(DisplayUtils.NO_STATUS_STATION);
        this.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
        this.setLinePaint(Color.BLACK);
        this.generate(stationLayer.getProjection());
    }

    public Station getStation() {
        return this.station;
    }

    public void select() {
        this.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
        this.setLinePaint(Color.WHITE);
        this.selected = true;
    }

    public boolean toggleSelection() {
        if (!this.selected) {
            this.select();
        } else {
            this.deselect();
        }
        return this.selected;
    }

    public void resetIsUp() {
        this.setDefaultColor(DisplayUtils.NO_STATUS_STATION);
    }

    public void setIsUp(boolean up) {
        this.isUp = up;
        if (up) {
            this.setDefaultColor(DisplayUtils.STATION);
        } else {
            this.setDefaultColor(DisplayUtils.DOWN_STATION);
        }
    }

    public boolean isUp() {
        return this.isUp;
    }

    public void deselect() {
        this.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
        this.setLinePaint(Color.BLACK);
        this.selected = false;
    }

    public void setDefaultColor(Color c) {
        this.defaultColor = c;
        this.setFillPaint(this.defaultColor);
    }
}

