/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.hibernate;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.UnsupportedFileTypeException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;

public abstract class AbstractSeismogramFileReference {
    protected int dbid;
    protected String netCode;
    protected String staCode;
    protected String siteCode;
    protected String chanCode;
    protected Timestamp beginTime;
    protected Timestamp endTime;
    protected String filePath;
    protected int fileType;

    protected AbstractSeismogramFileReference() {
    }

    public AbstractSeismogramFileReference(String netCode, String staCode, String siteCode, String chanCode, Timestamp beginTime, Timestamp endTime, String filePath, int fileType) {
        this.netCode = netCode;
        this.staCode = staCode;
        this.siteCode = siteCode;
        this.chanCode = chanCode;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.filePath = filePath;
        this.fileType = fileType;
    }

    public URLDataSetSeismogram getDataSetSeismogram(DataSet ds, RequestFilter rf) {
        try {
            MicroSecondDate b = new MicroSecondDate(this.getBeginTime());
            MicroSecondDate e = new MicroSecondDate(this.getEndTime());
            return new URLDataSetSeismogram(this.getFilePathAsURL(), SeismogramFileTypes.fromInt(this.getFileType()), ds, this.getNetworkCode() + "." + this.getStationCode() + "." + this.getSiteCode() + "." + this.getChannelCode(), rf);
        }
        catch (UnsupportedFileTypeException e) {
            throw new RuntimeException("should not happen, type from database: " + this.getFileType());
        }
    }

    public String getNetworkCode() {
        return this.netCode;
    }

    public String getStationCode() {
        return this.staCode;
    }

    public String getSiteCode() {
        return this.siteCode;
    }

    public String getChannelCode() {
        return this.chanCode;
    }

    public Timestamp getBeginTime() {
        return this.beginTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public URL getFilePathAsURL() {
        try {
            return new File(this.getFilePath()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Should not happen as url comes from file.", e);
        }
    }

    public int getFileType() {
        return this.fileType;
    }

    protected void setNetworkCode(String netCode) {
        this.netCode = netCode;
    }

    protected void setStationCode(String staCode) {
        this.staCode = staCode;
    }

    protected void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    protected void setChannelCode(String chanCode) {
        this.chanCode = chanCode;
    }

    protected void setBeginTime(Timestamp beginTime) {
        this.beginTime = beginTime;
    }

    protected void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    protected void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    protected void setFileType(int fileType) {
        this.fileType = fileType;
    }

    public int getDbid() {
        return this.dbid;
    }

    protected void setDbid(int dbid) {
        this.dbid = dbid;
    }
}

