/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.exceptionHandler;

import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporter;
import edu.sc.seis.fissuresUtil.exceptionHandler.Extractor;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.exceptionHandler.Section;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4jReporter
implements ExceptionReporter {
    private static Logger logger = LoggerFactory.getLogger(Log4jReporter.class);

    @Override
    public void report(String message, Throwable e, List sections) throws IOException {
        if (e != null) {
            logger.error(message, e);
            if (e.getCause() != null) {
                logger.error("...caused by:", e.getCause());
            }
            for (Extractor ext : GlobalExceptionHandler.getExtractors()) {
                if (!ext.canExtract(e)) continue;
                logger.error(ext.getClass().getSimpleName() + ": " + ext.extract(e));
                if (ext.getSubThrowable(e) == null) continue;
                this.report("...caused by subthrowable:", ext.getSubThrowable(e), new ArrayList());
            }
        } else {
            logger.error(message);
        }
        for (Section section : sections) {
            logger.debug(section.getName() + ":" + section.getContents());
        }
    }
}

