/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.SeismogramIterator;
import edu.sc.seis.fissuresUtil.display.UnitDisplayUtil;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfigData;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.BasicAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.BasicAmpEvent;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMeanAmpConfig
extends BasicAmpConfig {
    private static final Logger logger = LoggerFactory.getLogger(RMeanAmpConfig.class);

    public RMeanAmpConfig() {
    }

    public RMeanAmpConfig(DataSetSeismogram[] seismos) {
        super(seismos);
    }

    @Override
    public AmpEvent recalculate() {
        AmpConfigData[] ad = this.getAmpData();
        double range = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < ad.length; ++i) {
            UnitRangeImpl current = ad[i].getRange();
            if (current == null || !(current.getMaxValue() - current.getMinValue() > range)) continue;
            range = current.getMaxValue() - current.getMinValue();
        }
        UnitRangeImpl[] amps = new UnitRangeImpl[ad.length];
        for (int i = 0; i < ad.length; ++i) {
            amps[i] = this.setRange(ad[i].getRange(), range);
        }
        UnitRangeImpl genericAmp = DisplayUtils.ONE_RANGE;
        if (ad.length == 1 || AmpConfigData.isAllFromSameSite(ad)) {
            genericAmp = UnitDisplayUtil.getRealWorldUnitRange(amps[0], ad[0].getDSS());
        }
        return new BasicAmpEvent(AmpConfigData.getSeismograms(ad), amps, genericAmp);
    }

    @Override
    protected boolean setAmpRange(AmpConfigData data) {
        double minToMeanDiff;
        SeismogramIterator it = data.getIterator();
        if (!it.hasNext()) {
            return data.setRange(DisplayUtils.ONE_RANGE);
        }
        double[] minMaxMean = it.minMaxMean();
        double maxToMeanDiff = Math.abs(minMaxMean[2] - minMaxMean[1]);
        double meanDiff = maxToMeanDiff > (minToMeanDiff = Math.abs(minMaxMean[2] - minMaxMean[0])) ? maxToMeanDiff : minToMeanDiff;
        double min = minMaxMean[2] - meanDiff;
        double max = minMaxMean[2] + meanDiff;
        return data.setRange(new UnitRangeImpl(min, max, (Unit)it.getUnit()));
    }

    private UnitRangeImpl setRange(UnitRangeImpl currRange, double range) {
        double middle = currRange.getMaxValue() - (currRange.getMaxValue() - currRange.getMinValue()) / 2.0;
        return new UnitRangeImpl(middle - range / 2.0, middle + range / 2.0, (Unit)currRange.getUnit());
    }
}

