/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.model.TimeInterval;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.registrar.EmptyTimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeListener;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTimeConfig
implements TimeConfig {
    private Set listeners = new HashSet();
    protected Map seismoTimes = new HashMap();
    protected DataSetSeismogram[] seismograms;
    protected double shift;
    protected double scale = 1.0;
    protected MicroSecondTimeRange time;
    protected MicroSecondTimeRange initialTime;
    private static Logger logger = LoggerFactory.getLogger((String)BasicTimeConfig.class.getName());

    public BasicTimeConfig() {
    }

    public BasicTimeConfig(DataSetSeismogram[] seismos) {
        this.add(seismos);
    }

    @Override
    public void add(DataSetSeismogram[] seismos) {
        for (int i = 0; i < seismos.length; ++i) {
            MicroSecondTimeRange seisTime;
            if (this.contains(seismos[i]) || (seisTime = this.getInitialTime(seismos[i])) == null) continue;
            if (this.time == null) {
                this.initialTime = this.time = seisTime;
            }
            this.seismoTimes.put(seismos[i], this.getInitialTime(seismos[i]));
        }
        this.seismograms = null;
        this.fireTimeEvent();
    }

    protected MicroSecondTimeRange getInitialTime(DataSetSeismogram seis) {
        if (this.time == null && seis != null) {
            this.initialTime = this.time = new MicroSecondTimeRange(seis.getRequestFilter());
        }
        return this.time;
    }

    @Override
    public void remove(DataSetSeismogram[] seismos) {
        boolean someRemoved = false;
        for (int i = 0; i < seismos.length; ++i) {
            if (this.seismoTimes.remove(seismos[i]) == null) continue;
            someRemoved = true;
        }
        if (someRemoved) {
            this.seismograms = null;
            if (this.seismoTimes.size() == 0) {
                this.time = null;
                return;
            }
            this.fireTimeEvent();
        }
    }

    @Override
    public void clear() {
        this.remove(this.getSeismograms());
    }

    @Override
    public boolean contains(DataSetSeismogram seismo) {
        return this.seismoTimes.containsKey(seismo);
    }

    @Override
    public DataSetSeismogram[] getSeismograms() {
        if (this.seismograms == null) {
            this.seismograms = this.seismoTimes.keySet().toArray(new DataSetSeismogram[this.seismoTimes.size()]);
        }
        return this.seismograms;
    }

    @Override
    public void reset() {
        this.time = null;
        this.shift = 0.0;
        this.scale = 1.0;
        this.reset(this.getSeismograms());
    }

    @Override
    public void reset(DataSetSeismogram[] seismos) {
        this.remove(seismos);
        this.add(seismos);
    }

    @Override
    public void shaleTime(double shift, double scale) {
        this.shaleTime(shift, scale, this.getSeismograms());
    }

    @Override
    public void shaleTime(double shift, double scale, DataSetSeismogram[] seismos) {
        this.shift += shift * this.scale;
        this.scale *= scale;
        if (this.time != null) {
            this.time = this.time.shale(shift, scale);
            for (int i = 0; i < seismos.length; ++i) {
                MicroSecondTimeRange seisTime = (MicroSecondTimeRange)this.seismoTimes.get(seismos[i]);
                this.seismoTimes.put(seismos[i], seisTime.shale(shift, scale));
            }
            this.fireTimeEvent();
        }
    }

    @Override
    public double getShift() {
        return this.shift;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public TimeEvent fireTimeEvent() {
        if (this.seismoTimes.size() == 0 && this.time != null) {
            return this.fireTimeEvent(new EmptyTimeEvent(this.time));
        }
        DataSetSeismogram[] seismos = this.getSeismograms();
        MicroSecondTimeRange[] times = new MicroSecondTimeRange[seismos.length];
        for (int i = 0; i < seismos.length; ++i) {
            times[i] = (MicroSecondTimeRange)this.seismoTimes.get(seismos[i]);
        }
        return this.fireTimeEvent(new TimeEvent(seismos, times, this.time));
    }

    protected TimeEvent fireTimeEvent(TimeEvent event) {
        Iterator f = this.listeners.iterator();
        while (f.hasNext()) {
            ((TimeListener)f.next()).updateTime(event);
        }
        return event;
    }

    @Override
    public MicroSecondTimeRange getTime() {
        if (this.time != null) {
            return this.time;
        }
        return DisplayUtils.ZERO_TIME;
    }

    @Override
    public MicroSecondTimeRange getTime(DataSetSeismogram seis) {
        return (MicroSecondTimeRange)this.seismoTimes.get(seis);
    }

    @Override
    public void addListener(TimeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
            this.fireTimeEvent();
        }
    }

    @Override
    public void removeListener(TimeListener listener) {
        this.listeners.remove(listener);
    }

    protected TimeInterval getInterval(DataSetSeismogram seismo) {
        return new MicroSecondTimeRange(seismo.getRequestFilter()).getInterval();
    }
}

