/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.UnitDisplayUtil;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAmpEvent
implements AmpEvent {
    protected DataSetSeismogram[] seismos;
    protected UnitRangeImpl[] amps;
    protected UnitRangeImpl genericAmp;
    private static Logger logger = LoggerFactory.getLogger(BasicAmpEvent.class);

    public BasicAmpEvent(DataSetSeismogram[] seismos, UnitRangeImpl[] amps, UnitRangeImpl genericRange) {
        if (seismos.length != amps.length) {
            throw new IllegalArgumentException("seismogram and amp arrays must have equal length " + seismos.length + " != " + amps.length);
        }
        this.seismos = seismos;
        this.amps = amps;
        this.genericAmp = genericRange;
    }

    @Override
    public UnitRangeImpl getAmp(DataSetSeismogram seismo) {
        return this.amps[this.indexOf(seismo)];
    }

    @Override
    public boolean contains(DataSetSeismogram seismo) {
        try {
            this.indexOf(seismo);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public UnitRangeImpl getAmp() {
        return this.genericAmp;
    }

    protected void generateGenericAmp() {
        if (this.amps.length == 0) {
            this.genericAmp = DisplayUtils.ONE_RANGE;
        } else if (this.amps.length == 1) {
            this.genericAmp = UnitDisplayUtil.getRealWorldUnitRange(this.amps[0], this.seismos[0]);
        } else {
            boolean totallyEqual = true;
            for (int i = 1; i < this.amps.length; ++i) {
                if (this.amps[i].equals((Object)this.amps[i - 1])) continue;
                totallyEqual = false;
                break;
            }
            this.genericAmp = totallyEqual ? UnitDisplayUtil.getRealWorldUnitRange(this.amps[0], this.seismos[0]) : DisplayUtils.ONE_RANGE;
        }
    }

    @Override
    public DataSetSeismogram[] getSeismograms() {
        return this.seismos;
    }

    private int indexOf(DataSetSeismogram seismo) {
        for (int i = 0; i < this.seismos.length; ++i) {
            if (this.seismos[i] != seismo) continue;
            return i;
        }
        throw new IllegalArgumentException("Seismogram is not in this AmpEvent");
    }
}

