/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.SeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.sound.FissuresToWAV;
import edu.sc.seis.fissuresUtil.sound.PlayEvent;
import edu.sc.seis.fissuresUtil.sound.PlayEventListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.Timer;

public class SoundPlay
extends MouseAdapter
implements Drawable,
MouseMotionListener,
PlayEventListener {
    private Color drawColor = Color.BLACK;
    private int x2;
    private int x3;
    private int x1;
    private int x0;
    private int yMaxA = 9;
    private int yMaxB = 11;
    private int yMinA = 6;
    private int yMinB = 4;
    private int playCursor = 0;
    private SeismogramDisplay display;
    private boolean visible = true;
    private SeismogramContainer container;
    private TimeEvent timeEvent;
    private FissuresToWAV seisWAV;
    private PlayEvent playEvent;
    private TimeInterval timeInterval;
    private Timer timer;
    private double totalCount;
    private int currentCount;
    private double positionMultiplier;
    private MicroSecondDate clickTime;

    public SoundPlay(SeismogramDisplay display, SeismogramContainer container) {
        this.display = display;
        this.container = container;
        this.seisWAV = new FissuresToWAV(container, 1200);
        this.seisWAV.addPlayEventListener(this);
        display.addMouseListener(this);
        display.addMouseMotionListener(this);
    }

    @Override
    public void setVisibility(boolean b) {
        this.visible = b;
    }

    @Override
    public Color getColor() {
        return this.drawColor;
    }

    @Override
    public void setColor(Color c) {
        throw new UnsupportedOperationException("These colors are controlled by mousing, you can't set them");
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.intersects(e)) {
            this.setDrawColor(Color.RED);
        } else {
            this.setDrawColor(Color.BLACK);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.intersects(e)) {
            this.seisWAV.play(this.timeEvent.getTime(this.container.getDataSetSeismogram()));
        }
    }

    private boolean intersects(MouseEvent e) {
        if (e.getSource() == this.display) {
            int clickX = e.getX() - this.display.getInsets().left;
            int clickY = e.getY() - this.display.getInsets().top;
            if (clickX >= this.x0 && clickX <= this.x3 + 1 && clickY >= this.yMinB && clickY <= this.yMaxB) {
                return true;
            }
        }
        return false;
    }

    private void setDrawColor(Color newColor) {
        Color prevColor = this.drawColor;
        this.drawColor = newColor;
        if (prevColor != newColor) {
            this.display.repaint();
        }
    }

    @Override
    public void draw(Graphics2D canvas, Dimension size, TimeEvent currentTime, AmpEvent currentAmp) {
        if (this.visible && !SeismogramDisplay.PRINTING) {
            double sizeOfDisplay = size.getWidth();
            this.x0 = (int)sizeOfDisplay - 20;
            this.x1 = (int)sizeOfDisplay - 15;
            this.x2 = (int)sizeOfDisplay - 11;
            this.x3 = (int)sizeOfDisplay - 7;
            this.timeEvent = currentTime;
            canvas.setColor(this.drawColor);
            canvas.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
            int yMid = (this.yMinA + this.yMaxA + this.yMinB + this.yMaxB) / 4;
            canvas.drawLine(this.x0, this.yMinA, this.x0, this.yMaxA);
            canvas.drawLine(this.x0, this.yMaxA, this.x1, this.yMaxB);
            canvas.drawLine(this.x1, this.yMaxB, this.x1, this.yMinB);
            canvas.drawLine(this.x1, this.yMinB, this.x0, this.yMinA);
            canvas.drawLine(this.x2, this.yMinB, this.x2 + 1, yMid);
            canvas.drawLine(this.x2 + 1, yMid, this.x2, this.yMaxB);
            canvas.drawLine(this.x3, this.yMinB, this.x3 + 1, yMid);
            canvas.drawLine(this.x3 + 1, yMid, this.x3, this.yMaxB);
            if (this.playEvent != null && this.playEvent.getClip().isRunning()) {
                long elapsedTime = this.playEvent.getClip().getMicrosecondPosition();
                long clipLength = this.playEvent.getClip().getMicrosecondLength();
                canvas.setColor(Color.RED);
                canvas.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
                this.playCursor = (int)((double)elapsedTime / (double)clipLength * sizeOfDisplay);
                canvas.drawLine(this.playCursor, 0, this.playCursor, this.display.getHeight());
                this.display.repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.intersects(e)) {
            this.setDrawColor(Color.RED);
        } else if (e.getSource() == this.display) {
            this.setDrawColor(Color.BLACK);
        }
    }

    private void sendToWAV() throws FissuresException {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream("seis.wav")));
        }
        catch (FileNotFoundException e) {
            GlobalExceptionHandler.handle("file not found", e);
        }
        try {
            this.seisWAV.writeWAV(dos, this.timeEvent.getTime(this.container.getDataSetSeismogram()));
            dos.close();
        }
        catch (IOException e) {
            GlobalExceptionHandler.handle(e);
        }
    }

    @Override
    public void eventPlayed(PlayEvent e) {
        this.playEvent = e;
        this.timeInterval = e.getTimeInterval();
        this.display.repaint();
    }
}

