/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeismogramShapeIterator
implements PathIterator {
    private boolean prevSegBadMoveto = false;
    private boolean min = false;
    private int totalShift = 0;
    private double leftoverPixels = 0.0;
    private int baseSeisPoint;
    private int[] seisPoints;
    private int[][] points;
    private int[] drawnPixels;
    private double pointsPerPixel;
    private UnitRangeImpl amp;
    private MicroSecondTimeRange time;
    private Dimension size;
    protected int startIndex;
    protected int endIndex;
    protected int currentIndex;
    protected AffineTransform at;
    private static Logger logger = LoggerFactory.getLogger((String)SeismogramShapeIterator.class.getName());

    public SeismogramShapeIterator(SeismogramShapeIterator brother) {
        this(brother.getTime(), brother.getAmp(), brother.getSize());
    }

    public SeismogramShapeIterator(MicroSecondTimeRange time, UnitRangeImpl amp, Dimension size) {
        this.time = time;
        this.amp = amp;
        this.size = size;
    }

    public boolean isDraggedFrom(SeismogramShapeIterator otherIterator) {
        return otherIterator != null && this.size.equals(otherIterator.getSize()) && this.time.getInterval().equals((Object)otherIterator.getTime().getInterval());
    }

    public boolean hasSimilarAmp(SeismogramShapeIterator otherIterator) {
        if (otherIterator != null) {
            double thisMax = this.amp.getMaxValue();
            double thisMin = this.amp.getMinValue();
            double thisRange = thisMax - thisMin;
            double pixelHeightPercentage = 1.0 / (double)this.size.height;
            double otherMax = otherIterator.getAmp().getMaxValue();
            double otherMin = otherIterator.getAmp().getMinValue();
            if (Math.abs(otherMax - thisMax) / thisRange <= pixelHeightPercentage && Math.abs(otherMin - thisMin) / thisRange <= pixelHeightPercentage) {
                return true;
            }
        }
        return false;
    }

    public void copyBasicInfo(SeismogramShapeIterator iterator) {
        this.setPointsPerPixel(iterator.getPointsPerPixel());
        this.setBaseSeisPoint(iterator.getBaseSeisPoint());
        this.setAmp(iterator.getAmp());
        this.setPoints(iterator.getPoints());
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setTime(MicroSecondTimeRange time) {
        this.time = time;
    }

    public MicroSecondTimeRange getTime() {
        return this.time;
    }

    public void setAmp(UnitRangeImpl amp) {
        this.amp = amp;
    }

    public UnitRangeImpl getAmp() {
        return this.amp;
    }

    public void setPointsPerPixel() {
        this.setPointsPerPixel((double)(this.seisPoints[1] - this.seisPoints[0]) / (double)this.size.width);
    }

    public void setPointsPerPixel(double pointsPerPixel) {
        this.pointsPerPixel = pointsPerPixel;
    }

    public double getPointsPerPixel() {
        return this.pointsPerPixel;
    }

    public void setDrawnPixels(int[] drawnPixels) {
        if (drawnPixels != null) {
            this.drawnPixels = drawnPixels;
        } else {
            int[] pixels = new int[]{-1, -1};
            this.drawnPixels = pixels;
        }
        this.startIndex = this.drawnPixels[0];
        this.endIndex = this.drawnPixels[1];
        this.currentIndex = this.startIndex;
    }

    public int[] getDrawnPixels() {
        return this.drawnPixels;
    }

    public void setPoints(int[][] points) {
        this.points = points;
    }

    public int[][] getPoints() {
        return this.points;
    }

    public void setSeisPoints(int[] seisPoints) {
        this.seisPoints = seisPoints;
    }

    public int[] getSeisPoints() {
        return this.seisPoints;
    }

    public void setLeftoverPixels(double leftoverPixels) {
        this.leftoverPixels = leftoverPixels;
    }

    public double getLeftoverPixels() {
        return this.leftoverPixels;
    }

    public void setBaseSeisPoint() {
        this.setBaseSeisPoint(this.seisPoints[0]);
    }

    public void setBaseSeisPoint(int baseSeisPoint) {
        this.baseSeisPoint = baseSeisPoint;
    }

    public int getBaseSeisPoint() {
        return this.baseSeisPoint;
    }

    public void setTotalShift(int totalShift) {
        this.totalShift = totalShift;
    }

    public int getTotalShift() {
        return this.totalShift;
    }

    public void setAT(AffineTransform at) {
        this.at = at;
    }

    public AffineTransform getAt() {
        return this.at;
    }

    @Override
    public void next() {
        ++this.currentIndex;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        if (this.currentIndex == this.endIndex) {
            this.currentIndex = this.startIndex;
            this.min = false;
            return true;
        }
        return false;
    }

    @Override
    public int currentSegment(float[] coordinates) {
        int i = 0;
        if (this.min) {
            i = 1;
            --this.currentIndex;
        }
        this.min = !this.min;
        coordinates[0] = this.currentIndex;
        coordinates[1] = this.points[i][this.currentIndex];
        if (this.points[i][this.currentIndex] < 0 || this.points[i][this.currentIndex] > this.size.height) {
            coordinates[1] = 0.0f;
            this.prevSegBadMoveto = true;
            return 0;
        }
        if (this.at != null) {
            this.at.transform(coordinates, 0, coordinates, 0, 1);
        }
        if (this.currentIndex == this.startIndex || this.prevSegBadMoveto) {
            this.prevSegBadMoveto = false;
            return 0;
        }
        return 1;
    }

    @Override
    public int currentSegment(double[] coordinates) {
        float[] temp = new float[2];
        int val = this.currentSegment(temp);
        coordinates[0] = temp[0];
        coordinates[1] = temp[1];
        return val;
    }
}

