/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.display.ScaleMapper;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeListener;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeScaleCalc
implements ScaleMapper,
TimeListener {
    private ThreadSafeSimpleDateFormat borderFormat = new ThreadSafeSimpleDateFormat("MM/dd/yyy", TimeZone.getTimeZone("GMT"));
    private boolean daysInBorder = false;
    private MicroSecondTimeRange time;
    private ThreadSafeSimpleDateFormat axisFormat = new ThreadSafeSimpleDateFormat("MM/dd/yyyy");
    public static MicroSecondTimeRange roundTheEpoch = new MicroSecondTimeRange(new MicroSecondDate(0L), new TimeInterval(20.0, UnitImpl.DAY));
    private boolean relative = false;
    private Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private int totalPixels;
    private long beginTime;
    private long endTime;
    private long firstLabelTime;
    private long timeIntv;
    private long majTickTime;
    private int numTicks;
    private int majTickRatio;
    private int majTickOffset;
    private double tickSpacing;
    private double tickOffset;
    private static final long SECOND = 1000000L;
    private static final long MINUTE = 60000000L;
    private static final long HOUR = 3600000000L;
    private static final long DAY = 86400000000L;
    private static final long WEEK = 604800000000L;

    TimeScaleCalc(int totalPixels, TimeConfig tc) {
        this.totalPixels = totalPixels;
        tc.addListener(this);
    }

    public void calculateTicks() {
        if (this.totalPixels == 0) {
            this.numTicks = 0;
            return;
        }
        int majTickNum = this.totalPixels / 60;
        if (majTickNum < 2) {
            majTickNum = 2;
        }
        this.majTickTime = this.timeIntv / (long)majTickNum;
        this.majTickRatio = 10;
        this.daysInBorder = false;
        if (this.majTickTime <= 1000000L) {
            this.setTimeFormat("mm:ss.S");
            if (this.majTickTime <= 1000L) {
                this.majTickTime = 1000L;
            } else if (this.majTickTime <= 10000L) {
                this.majTickTime = 10000L;
            } else if (this.majTickTime <= 100000L) {
                this.majTickTime = 100000L;
            } else {
                this.majTickTime = 500000L;
                this.majTickRatio = 5;
            }
        } else if (this.majTickTime <= 45000000L) {
            this.majTickRatio = 10;
            this.setTimeFormat("mm:ss");
            if ((double)this.majTickTime <= 1200000.0) {
                this.majTickTime = 1000000L;
            } else if (this.majTickTime <= 3000000L) {
                this.majTickTime = 2000000L;
                this.majTickRatio = 4;
            } else if (this.majTickTime <= 6000000L) {
                this.majTickTime = 5000000L;
                this.majTickRatio = 5;
            } else if (this.majTickTime <= 12000000L) {
                this.majTickTime = 10000000L;
            } else if (this.majTickTime <= 22000000L) {
                this.majTickTime = 20000000L;
                this.majTickRatio = 4;
            } else {
                this.majTickTime = 30000000L;
            }
        } else if (this.majTickTime <= 180000000L) {
            this.majTickRatio = 6;
            this.setTimeFormat("HH:mm:ss");
            if (this.majTickTime <= 70000000L) {
                this.majTickTime = 60000000L;
            } else if (this.majTickTime <= 150000000L) {
                this.majTickTime = 120000000L;
                this.majTickRatio = 12;
            } else {
                this.majTickTime = 150000000L;
            }
        } else if (this.majTickTime <= 1800000000L) {
            this.majTickRatio = 10;
            this.setTimeFormat("HH:mm:ss");
            if (this.majTickTime <= 360000000L) {
                this.majTickTime = 300000000L;
                this.majTickRatio = 5;
            } else {
                this.majTickTime = this.majTickTime <= 600000000L ? 600000000L : (this.majTickTime <= 1200000000L ? 1200000000L : 1800000000L);
            }
        } else if (this.majTickTime <= 14400000000L) {
            this.majTickRatio = 6;
            this.daysInBorder = true;
            this.setTimeFormat("MM/dd HH:mm");
            if (this.majTickTime <= 3600000000L) {
                this.majTickTime = 3600000000L;
            } else if (this.majTickTime <= 7200000000L) {
                this.majTickTime = 7200000000L;
                this.majTickRatio = 4;
            } else if (this.majTickTime <= 10800000000L) {
                this.majTickTime = 10800000000L;
                this.majTickRatio = 6;
            } else {
                this.majTickTime = 14400000000L;
                this.majTickRatio = 4;
            }
        } else if (this.majTickTime <= 345600000000L) {
            this.majTickRatio = 6;
            this.daysInBorder = true;
            this.setTimeFormat("MM/dd");
            this.majTickTime = 86400000000L;
        } else {
            this.majTickRatio = 7;
            this.daysInBorder = true;
            this.setTimeFormat("MM/dd");
            this.majTickTime = 604800000000L;
        }
        double numTicksDbl = (double)this.timeIntv / (double)this.majTickTime * (double)this.majTickRatio;
        this.numTicks = (int)numTicksDbl;
        this.firstLabelTime = this.beginTime > 0L ? (this.beginTime / this.majTickTime + 1L) * this.majTickTime : this.beginTime / this.majTickTime * this.majTickTime;
        this.majTickOffset = (int)((double)(this.firstLabelTime - this.beginTime) / (double)this.timeIntv * (double)this.numTicks);
        this.tickOffset = (double)(this.firstLabelTime - this.beginTime) / (double)this.timeIntv / (double)this.majTickRatio * (double)this.totalPixels;
        this.tickSpacing = (double)this.totalPixels / numTicksDbl;
    }

    public void setTotalPixels(int totalPixels) {
        this.totalPixels = totalPixels;
        this.calculateTicks();
    }

    private void setTimeFormat(String newFormat) {
        if (!this.borderFormat.toPattern().equals(newFormat)) {
            this.borderFormat = new ThreadSafeSimpleDateFormat(newFormat);
        }
    }

    @Override
    public int getTotalPixels() {
        return this.totalPixels;
    }

    public void setTimes(MicroSecondDate beginTime, MicroSecondDate endTime) {
        this.beginTime = beginTime.getMicroSecondTime();
        this.endTime = endTime.getMicroSecondTime();
        this.timeIntv = this.endTime - this.beginTime;
        this.calculateTicks();
    }

    @Override
    public String getLabel(int i) {
        if (this.isLabelTick(i)) {
            MicroSecondDate date = new MicroSecondDate(this.firstLabelTime + (long)(i / this.majTickRatio) * this.majTickTime);
            this.calendar.setTime((Date)date);
            return this.borderFormat.format(this.calendar.getTime());
        }
        return "";
    }

    @Override
    public String getAxisLabel() {
        if (this.relative) {
            return "Relative time";
        }
        if (this.time != null && !this.daysInBorder) {
            MicroSecondDate middleDate = this.time.getBeginTime().add(new TimeInterval((Quantity)this.time.getInterval().divideBy(2.0)));
            this.calendar.setTime((Date)middleDate);
            return this.axisFormat.format(this.calendar.getTime()) + " (GMT)";
        }
        return "Time (GMT)";
    }

    @Override
    public int getPixelLocation(int i) {
        return (int)((double)i * this.tickSpacing + this.tickOffset);
    }

    @Override
    public int getNumTicks() {
        return this.numTicks;
    }

    public boolean isLabelTick(int i) {
        return this.isMajorTick(i);
    }

    @Override
    public boolean isMajorTick(int i) {
        return i % this.majTickRatio - this.majTickOffset == 0;
    }

    @Override
    public void updateTime(TimeEvent event) {
        this.time = event.getTime();
        this.relative = roundTheEpoch.intersects(this.time);
        this.setTimes(event.getTime().getBeginTime(), event.getTime().getEndTime());
    }
}

