/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.display.SeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerListener;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeEvent;
import edu.sc.seis.fissuresUtil.xml.SeisDataErrorEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSeismogramContainer
implements SeismogramContainer {
    private static int i = 0;
    private int j;
    private DataSetSeismogram seismogram;
    private boolean finished = false;
    protected boolean noData = true;
    private boolean error = false;
    protected List listeners = Collections.synchronizedList(new ArrayList());

    public AbstractSeismogramContainer(SeismogramContainerListener initialListener, DataSetSeismogram dss) {
        this.j = i++;
        this.seismogram = dss;
        if (initialListener != null) {
            this.listeners.add(initialListener);
        }
        this.seismogram.addSeisDataChangeListener(this);
        this.seismogram.addRequestFilterChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(SeismogramContainerListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(SeismogramContainerListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public DataSetSeismogram getDataSetSeismogram() {
        return this.seismogram;
    }

    @Override
    public void pushData(SeisDataChangeEvent sdce) {
        this.addSeismograms(sdce.getSeismograms());
    }

    @Override
    public void error(SeisDataErrorEvent sdce) {
        GlobalExceptionHandler.handle("Trouble getting data for " + sdce.getSource(), sdce.getCausalException());
        this.error = true;
    }

    @Override
    public void finished(SeisDataChangeEvent sdce) {
        this.finished = true;
        this.addSeismograms(sdce.getSeismograms());
    }

    @Override
    public void beginTimeChanged() {
        this.reset();
    }

    @Override
    public void endTimeChanged() {
        this.reset();
    }

    protected synchronized void reset() {
        this.getDataSetSeismogram().retrieveData(this);
        this.finished = false;
        this.noData = true;
    }

    @Override
    public String getDataStatus() {
        if (this.error) {
            return "Error encountered getting data";
        }
        if (this.noData && this.finished) {
            return "No data available";
        }
        if (this.noData) {
            return "Trying to get data";
        }
        return "";
    }

    protected abstract void addSeismograms(LocalSeismogramImpl[] var1);

    public String toString() {
        return this.getDataSetSeismogram().getName() + this.j + " Container";
    }
}

