/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.dataset;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.dataset.TopLevelOrganizer;
import edu.sc.seis.fissuresUtil.display.ParseRegions;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.StdDataSetParamNames;
import edu.sc.seis.fissuresUtil.xml.URLDataSet;

public class DataSetEventOrganizer
extends TopLevelOrganizer
implements StdDataSetParamNames {
    ParseRegions parseRegions = ParseRegions.getInstance();

    public DataSetEventOrganizer() {
    }

    public DataSetEventOrganizer(DataSet root) {
        super(root);
    }

    @Override
    public void addSeismogram(DataSetSeismogram seis, EventAccessOperations event, AuditInfo[] audit) {
        DataSet ds = this.getEventDataSet(event);
        ds.addDataSetSeismogram(seis, audit);
    }

    @Override
    public void addChannel(Channel channel, EventAccessOperations event, AuditInfo[] audit) {
        DataSetEventOrganizer.addChannel(channel, this.getEventDataSet(event), audit);
    }

    public static void addChannel(Channel channel, DataSet dataSet, AuditInfo[] audit) {
        String channelParamName = "edu.sc.seis.fissuresUtil.xml#CHANNEL_" + ChannelIdUtil.toString((ChannelId)channel.get_id());
        if (channel != null && dataSet.getParameter(channelParamName) == null) {
            dataSet.addParameter(channelParamName, channel, audit);
        }
    }

    private DataSet getEventDataSet(EventAccessOperations event) {
        if (event != null) {
            DataSet dataSet = this.findEventDataSet(event, this.getRootDataSet());
            if (dataSet == null) {
                dataSet = this.makeSubDataSet(event, this.getRootDataSet());
            }
            return dataSet;
        }
        return this.getRootDataSet();
    }

    private DataSet findEventDataSet(EventAccessOperations event, DataSet dataSet) {
        EventAccessOperations dataSetEvent = dataSet.getEvent();
        CacheEvent cacheEvent = event instanceof CacheEvent ? (CacheEvent)event : new CacheEvent(event);
        if (dataSetEvent == null) {
            String[] dataSetNames = dataSet.getDataSetNames();
            for (int counter = 0; counter < dataSetNames.length; ++counter) {
                DataSet rtnValue;
                DataSet subDataset = dataSet.getDataSet(dataSetNames[counter]);
                if (subDataset instanceof URLDataSet || (rtnValue = this.findEventDataSet((EventAccessOperations)cacheEvent, subDataset)) == null) continue;
                return rtnValue;
            }
            return null;
        }
        if (cacheEvent.close(dataSetEvent)) {
            return dataSet;
        }
        return null;
    }

    protected DataSet makeSubDataSet(EventAccessOperations event, DataSet rootDataSet) {
        EventAttr eventAttr = event.get_attributes();
        String dataSetName = null;
        if (eventAttr.region.number != 0) {
            dataSetName = this.parseRegions.getRegionName(eventAttr.region);
        }
        String[] dataSetNames = rootDataSet.getDataSetNames();
        if (dataSetName == null || dataSetName.equals("Unknown")) {
            dataSetName = "Your Earthquake (" + EventUtil.getEventInfo(event, "TIME, MAG )");
        }
        if (this.nameExists(dataSetName, dataSetNames)) {
            try {
                Origin origin = event.get_preferred_origin();
                if (origin.getMagnitudes().length > 0) {
                    dataSetName = dataSetName + " " + origin.getMagnitudes()[0].value + origin.getMagnitudes()[0].type;
                }
            }
            catch (NoPreferredOrigin origin) {
                // empty catch block
            }
            int nameNumber = 1;
            String suffix = "";
            while (this.nameExists(dataSetName + suffix, dataSetNames)) {
                suffix = " " + ++nameNumber;
            }
            dataSetName = dataSetName + suffix;
        }
        DataSet dataSet = rootDataSet.createChildDataSet("genid" + Math.round(Math.random() * 2.147483647E9), dataSetName, rootDataSet.getName(), new AuditInfo[0]);
        this.fireDataSetAdded(rootDataSet);
        dataSet.addParameter("edu.sc.seis.fissuresUtil.xml#EVENT", event, new AuditInfo[0]);
        return dataSet;
    }

    protected boolean nameExists(String name, String[] existing) {
        for (int i = 0; i < existing.length; ++i) {
            if (!name.equals(existing[i])) continue;
            return true;
        }
        return false;
    }
}

