/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.sc.seis.fissuresUtil.database.AbstractDb;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueNumberGenerator
extends AbstractDb {
    private static UniqueNumberGenerator ung = null;
    private PreparedStatement insertStmt;
    private PreparedStatement getStmt;
    private PreparedStatement updateStmt;
    private static Logger logger = LoggerFactory.getLogger((String)UniqueNumberGenerator.class.getName());

    private UniqueNumberGenerator(String directoryName, String databaseName) {
        super(directoryName, databaseName);
        this.create();
        this.insert(-1);
    }

    public static UniqueNumberGenerator getUNG(String directoryName, String databaseName) {
        if (ung == null) {
            ung = new UniqueNumberGenerator(directoryName, databaseName);
        }
        return ung;
    }

    @Override
    public void create() {
        try {
            this.connection = this.getConnection();
            if (this.connection == null) {
                Object[] options = new Object[]{"Exit GEE"};
                JOptionPane.showOptionDialog(null, "It appears that another copy of GEE is running right now.\nPlease use it instead of starting another copy.\nIf you feel you are getting this message in error, please remove the cache directory\n" + this.directoryName, "Multiple instances of GEE running", 0, 0, null, options, "Exit GEE");
                System.exit(0);
            }
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate(" CREATE TABLE uniqueIdentifier  ( number INTEGER)");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.insertStmt = this.connection.prepareStatement("INSERT INTO uniqueIdentifier VALUES(?)");
            this.getStmt = this.connection.prepareStatement(" SELECT number FROM uniqueIdentifier");
            this.updateStmt = this.connection.prepareStatement(" UPDATE uniqueIdentifier SET number = ? ");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void insert(int num) {
        try {
            this.insertStmt.setInt(1, num);
            this.insertStmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public int getUniqueIdentifier() {
        try {
            int num = this.getId();
            UniqueNumberGenerator.ung.updateStmt.setInt(1, num + 1);
            UniqueNumberGenerator.ung.updateStmt.executeUpdate();
            return num + 1;
        }
        catch (SQLException sqle) {
            logger.debug("ERROR while updating ", (Throwable)sqle);
            return -1;
        }
    }

    private int getId() {
        try {
            ResultSet rs = UniqueNumberGenerator.ung.getStmt.executeQuery();
            if (rs.next()) {
                return rs.getInt(1);
            }
        }
        catch (SQLException sqle) {
            logger.debug("ERROR while retrieveing ", (Throwable)sqle);
        }
        return -1;
    }
}

