/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSequence {
    private PreparedStatement nextVal;
    private static final Logger logger = LoggerFactory.getLogger(JDBCSequence.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCSequence(Connection conn, String name) throws SQLException {
        try {
            Class<JDBCSequence> clazz = JDBCSequence.class;
            synchronized (JDBCSequence.class) {
                if (!DBUtil.sequenceExists(name, conn)) {
                    conn.createStatement().executeUpdate(JDBCSequence.initCreateStmt(conn, name));
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (SQLException e) {
            logger.info("Sequence must already exist for " + name, (Throwable)e);
        }
        {
            this.nextVal = conn.prepareStatement(JDBCSequence.initNextValStmt(conn, name));
            return;
        }
    }

    public int next() throws SQLException {
        ResultSet rs = this.nextVal.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    private static String initNextValStmt(Connection conn, String seqName) throws SQLException {
        if (conn.getMetaData().getURL().startsWith("jdbc:postgresql:")) {
            return "SELECT NEXTVAL ('" + seqName + "')";
        }
        if (conn.getMetaData().getURL().startsWith("jdbc:hsqldb:")) {
            return "CALL NEXT VALUE FOR " + seqName;
        }
        return ConnMgr.getSQL(seqName + ".nextVal");
    }

    private static String initCreateStmt(Connection conn, String seqName) throws SQLException {
        if (conn.getMetaData().getURL().startsWith("jdbc:postgresql:") || conn.getMetaData().getURL().startsWith("jdbc:hsqldb:")) {
            return "CREATE SEQUENCE " + seqName;
        }
        return ConnMgr.getSQL(seqName + ".create");
    }
}

