/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.fissuresUtil.chooser.NetworkFromSource;
import edu.sc.seis.fissuresUtil.chooser.StationAcceptor;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StationLoader
extends Thread {
    private NetworkFromSource[] nets;
    private ChannelChooser chooser;
    private LinkedList acceptors = new LinkedList();
    private static Logger logger = LoggerFactory.getLogger(StationLoader.class);

    public StationLoader(ChannelChooser chooser, NetworkFromSource[] nets2) {
        this.chooser = chooser;
        this.nets = nets2;
    }

    public void addStationAcceptor(StationAcceptor acceptor) {
        this.acceptors.add(acceptor);
    }

    @Override
    public void run() {
        ArrayList<StationImpl> stations = new ArrayList<StationImpl>();
        this.chooser.setProgressOwner(this);
        this.chooser.setProgressMax(this, 100);
        try {
            int netProgressInc = 50 / this.nets.length;
            int progressValue = 10;
            this.chooser.setProgressValue(this, progressValue);
            for (int i = 0; i < this.nets.length; ++i) {
                List<StationImpl> newStations = this.nets[i].getSource().getStations(this.nets[i].getNetAttr());
                stations.addAll(newStations);
                logger.debug("got " + newStations.size() + " stations from " + this.nets[i].getNetAttr().get_code());
                this.chooser.setProgressValue(this, progressValue + netProgressInc / 2);
                for (int j = 0; j < newStations.size(); ++j) {
                    StationImpl newStationImpl = newStations.get(j);
                    if (newStationImpl.getName() == null || newStationImpl.getName().length() < 3) {
                        newStationImpl.setName(newStationImpl.get_code());
                    }
                    this.chooser.setProgressValue(this, progressValue + netProgressInc / 2 - (newStations.size() - j) / newStations.size());
                }
                this.chooser.setProgressValue(this, 100);
            }
        }
        catch (Throwable e) {
            GlobalExceptionHandler.handle("Unable to get stations.", e);
        }
        this.stationAdd(stations);
    }

    protected boolean acceptStation(Station sta) {
        return true;
    }

    void stationAdd(List<StationImpl> s) {
        this.chooser.addStationsFromThread(s);
    }
}

