/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.chooser.DateChooserOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DateChooser
extends JPanel {
    private static final DateChooserOptions[] DEFAULT_OPTIONS = new DateChooserOptions[]{DateChooserOptions.YEAR, DateChooserOptions.MONTH, DateChooserOptions.DAY};
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private JPanel subPane = new JPanel();
    private GridBagConstraints gbc;
    private int upperLeftX = 0;
    private int upperLeftY = 0;
    private static final long ONE_DAY = 86400000L;
    private Date today;
    private Date yesterday;
    private Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private Calendar todayCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private JRadioButton todayButton = new JRadioButton("Today");
    private JRadioButton yesButton = new JRadioButton("Yesterday");
    private JRadioButton otherButton = new JRadioButton("Other");
    private JTextField julianDay;
    private JComboBox yearBox;
    private JComboBox monthBox;
    private JComboBox dayBox;
    private JComboBox hourBox;
    private JComboBox minuteBox;
    private JComboBox secondBox;
    private JComboBox weekAgoBox;
    private JLabel result;
    private String dateFormat;
    private int numberOfYears = 5;
    private boolean currentTime = false;

    public DateChooser() {
        this(DEFAULT_OPTIONS);
    }

    public DateChooser(DateChooserOptions[] dateOptions) {
        this(dateOptions, (Date)ClockUtil.now());
        this.currentTime = true;
    }

    public DateChooser(DateChooserOptions[] dateOptions, Date givendate) {
        this.initFrame();
        this.today = givendate;
        this.yesterday = new Date(this.today.getTime() - 86400000L);
        this.dateFormat = "dd MMMMM yyyy 'at' hh:mm:ss z";
        int option = 0;
        this.calendar.setTime(this.today);
        this.todayCalendar.setTime(this.today);
        this.createComponents();
        block13: for (int i = 0; i < dateOptions.length; ++i) {
            option = dateOptions[i].getDateFormatValue();
            switch (option) {
                case 0: {
                    this.yearOption();
                    continue block13;
                }
                case 1: {
                    this.monthOption();
                    continue block13;
                }
                case 2: {
                    this.dayOption();
                    continue block13;
                }
                case 3: {
                    this.hourOption();
                    continue block13;
                }
                case 4: {
                    this.minuteOption();
                    continue block13;
                }
                case 5: {
                    this.secondOption();
                    continue block13;
                }
                case 7: {
                    this.julianOption();
                    continue block13;
                }
                case 8: {
                    this.todayOption();
                    continue block13;
                }
                case 9: {
                    this.radioButtonOption();
                    continue block13;
                }
                case 10: {
                    this.weekagoOption();
                    continue block13;
                }
                case 11: {
                    this.intervalOption();
                }
            }
        }
    }

    protected void initFrame() {
        this.subPane.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
    }

    public void setHour(int value) {
        this.calendar.set(11, value);
    }

    public void setMinute(int value) {
        this.calendar.set(12, value);
    }

    private void radioButtonOption() {
        this.todayButton.setActionCommand("Today");
        this.yesButton.setActionCommand("Yesterday");
        ButtonGroup group = new ButtonGroup();
        group.add(this.todayButton);
        group.add(this.yesButton);
        group.add(this.otherButton);
        this.todayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.updateToday();
                DateChooser.this.calendar.setTime(DateChooser.this.today);
                DateChooser.this.dateChanged();
            }
        });
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.updateToday();
                DateChooser.this.calendar.setTime(DateChooser.this.yesterday);
                DateChooser.this.dateChanged();
            }
        });
        this.gbc.gridx = this.upperLeftX;
        this.gbc.gridy = this.upperLeftY++;
        this.subPane.add((Component)this.todayButton, this.gbc);
        ++this.gbc.gridx;
        this.subPane.add((Component)this.yesButton, this.gbc);
    }

    public void setNumberOfYears(int totalyears) {
        this.numberOfYears = totalyears;
        int addedyear = this.todayCalendar.get(1);
        String[] yearst = new String[this.numberOfYears];
        for (int i = 0; i < this.numberOfYears; ++i) {
            yearst[i] = "" + addedyear;
            --addedyear;
        }
        this.yearBox.setModel(new DefaultComboBoxModel<String>(yearst));
    }

    private void yearOption() {
        int todayYear = this.todayCalendar.get(1);
        String[] years = new String[this.numberOfYears];
        for (int i = 0; i < this.numberOfYears; ++i) {
            years[i] = String.valueOf(todayYear--);
        }
        this.yearBox = new JComboBox<String>(years);
        this.yearBox.setSelectedIndex(0);
        this.yearBox.setAlignmentX(0.0f);
        this.yearBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                DateChooser.this.calendar.set(1, Integer.parseInt((String)cb.getSelectedItem()));
                DateChooser.this.dateChanged();
            }
        });
        this.gbc.gridx = this.upperLeftX++;
        this.gbc.gridy = this.upperLeftY;
        this.subPane.add((Component)new JLabel("Year"), this.gbc);
        this.gbc.gridheight = 2;
        ++this.gbc.gridy;
        this.subPane.add((Component)this.yearBox, this.gbc);
    }

    private void monthOption() {
        this.monthBox = new JComboBox<String>(MONTHS);
        this.monthBox.setSelectedIndex(this.calendar.get(2));
        this.monthBox.setAlignmentX(0.0f);
        this.monthBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                DateChooser.this.calendar.set(2, cb.getSelectedIndex());
                DateChooser.this.dateChanged();
            }
        });
        this.gbc.gridx = this.upperLeftX++;
        this.gbc.gridy = this.upperLeftY;
        this.subPane.add((Component)new JLabel("Month"), this.gbc);
        ++this.gbc.gridy;
        this.subPane.add((Component)this.monthBox, this.gbc);
    }

    private void dayOption() {
        String[] dayStrings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
        this.dayBox = new JComboBox<String>(dayStrings);
        this.dayBox.setSelectedIndex(this.calendar.get(5) - 1);
        this.dayBox.setAlignmentX(0.0f);
        this.dayBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                DateChooser.this.calendar.set(5, cb.getSelectedIndex() + 1);
                DateChooser.this.dateChanged();
            }
        });
        this.gbc.gridx = this.upperLeftX++;
        this.gbc.gridy = this.upperLeftY;
        this.subPane.add((Component)new JLabel("Day"), this.gbc);
        ++this.gbc.gridy;
        this.subPane.add((Component)this.dayBox, this.gbc);
    }

    private void hourOption() {
        int hoursInDay = 24;
        String[] hourStringArray = new String[hoursInDay];
        for (int i = 0; i < hoursInDay; ++i) {
            hourStringArray[i] = String.valueOf(i);
        }
        this.hourBox = new JComboBox<String>(hourStringArray);
        this.hourBox.setSelectedIndex(this.calendar.get(11));
        this.hourBox.setAlignmentX(0.0f);
        this.hourBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                DateChooser.this.calendar.set(11, cb.getSelectedIndex());
                DateChooser.this.dateChanged();
            }
        });
        this.gbc.gridx = this.upperLeftX++;
        this.gbc.gridy = this.upperLeftY;
        this.subPane.add((Component)new JLabel("Hour"), this.gbc);
        ++this.gbc.gridy;
        this.subPane.add((Component)this.hourBox, this.gbc);
    }

    private void minuteOption() {
        int minutesInHour = 60;
        String[] minuteStringArray = new String[minutesInHour];
        for (int i = 0; i < minutesInHour; ++i) {
            minuteStringArray[i] = String.valueOf(i);
        }
        this.minuteBox = new JComboBox<String>(minuteStringArray);
        this.minuteBox.setSelectedIndex(this.calendar.get(12));
        this.minuteBox.setAlignmentX(0.0f);
        this.minuteBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                DateChooser.this.calendar.set(12, cb.getSelectedIndex());
                DateChooser.this.dateChanged();
            }
        });
        this.gbc.gridx = ++this.upperLeftX;
        this.gbc.gridy = this.upperLeftY;
        this.subPane.add((Component)new JLabel("Minute"), this.gbc);
        ++this.gbc.gridy;
        this.subPane.add((Component)this.minuteBox, this.gbc);
    }

    private void secondOption() {
        int secondsInMinute = 60;
        String[] secst = new String[secondsInMinute];
        for (int i = 0; i < secondsInMinute; ++i) {
            secst[i] = String.valueOf(i);
        }
        this.secondBox = new JComboBox<String>(secst);
        this.secondBox.setSelectedIndex(this.calendar.get(13));
        this.secondBox.setAlignmentX(0.0f);
        this.secondBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                DateChooser.this.calendar.set(13, cb.getSelectedIndex());
                DateChooser.this.dateChanged();
            }
        });
        this.gbc.gridx = ++this.upperLeftX;
        this.gbc.gridy = this.upperLeftY;
        this.subPane.add((Component)new JLabel("Second"), this.gbc);
        ++this.gbc.gridy;
        this.subPane.add((Component)this.secondBox, this.gbc);
    }

    private void julianOption() {
        Integer dayint = new Integer(this.calendar.get(6));
        String dayString = dayint.toString();
        this.julianDay = new JTextField(dayString);
        this.julianDay.setAlignmentX(0.0f);
        this.julianDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.calendar.set(6, Integer.parseInt(DateChooser.this.julianDay.getText()));
                DateChooser.this.dateChanged();
            }
        });
        this.gbc.gridy = this.upperLeftY;
        ++this.gbc.gridx;
        this.subPane.add((Component)new JLabel("JulianDay"), this.gbc);
        ++this.gbc.gridy;
        this.subPane.add((Component)this.julianDay, this.gbc);
    }

    private void todayOption() {
        JLabel resultLabel = new JLabel("Current Date/Time", 2);
        this.result = new JLabel(" ");
        this.result.setForeground(Color.black);
        this.result.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel resultPanel = new JPanel(new GridLayout(0, 1));
        resultPanel.add(resultLabel);
        resultPanel.add(this.result);
        this.setLayout(new BoxLayout(this, 1));
        resultPanel.setAlignmentX(0.0f);
        this.add(resultPanel);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.reformat(this.dateFormat);
    }

    private void intervalOption() {
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton weekButton = new JRadioButton("weekAgo");
        final JRadioButton monthButton = new JRadioButton("monthAgo");
        final JRadioButton yearButton = new JRadioButton("yearAgo");
        final JComboBox valueBox = new JComboBox();
        weekButton.setSelected(true);
        buttonGroup.add(weekButton);
        buttonGroup.add(monthButton);
        buttonGroup.add(yearButton);
        this.gbc.gridx = this.upperLeftX;
        this.gbc.gridy = this.upperLeftY;
        ++this.gbc.gridx;
        ++this.gbc.gridx;
        this.subPane.add(new JLabel("Number"));
        ++this.gbc.gridx;
        this.populateComboBox(valueBox, 1, 3);
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        tempCalendar.add(3, -1);
        this.calendar = tempCalendar;
        this.subPane.add(valueBox);
        ++this.gbc.gridx;
        this.subPane.add(weekButton);
        ++this.gbc.gridx;
        this.subPane.add(monthButton);
        ++this.gbc.gridx;
        this.subPane.add(yearButton);
        weekButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.populateComboBox(valueBox, 1, 3);
            }
        });
        monthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.populateComboBox(valueBox, 1, 11);
            }
        });
        yearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.populateComboBox(valueBox, 1, 4);
            }
        });
        valueBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value;
                JComboBox cb = (JComboBox)e.getSource();
                String newSelection = (String)cb.getSelectedItem();
                try {
                    value = Integer.parseInt(newSelection);
                }
                catch (NumberFormatException nfe) {
                    value = -1;
                }
                if (value == -1) {
                    return;
                }
                Calendar tempCalendar = Calendar.getInstance();
                tempCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                if (weekButton.isSelected()) {
                    tempCalendar.add(3, -value);
                } else if (monthButton.isSelected()) {
                    tempCalendar.add(2, -value);
                } else if (yearButton.isSelected()) {
                    tempCalendar.add(1, -value);
                }
                DateChooser.this.calendar = tempCalendar;
            }
        });
    }

    private void populateComboBox(JComboBox comboBox, int start, int end) {
        comboBox.removeAllItems();
        for (int counter = start; counter <= end; ++counter) {
            comboBox.addItem(new String(new Integer(counter).toString()));
        }
        comboBox.setSelectedIndex(0);
    }

    private void weekagoOption() {
        int numberofweeks = 3;
        this.weekAgoBox = new JComboBox();
        for (int counter = 1; counter <= numberofweeks; ++counter) {
            this.weekAgoBox.addItem(new String(new Integer(counter).toString()));
        }
        this.weekAgoBox.setSelectedIndex(0);
        this.weekAgoBox.setAlignmentX(0.0f);
        this.weekAgoBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String newSelection = (String)cb.getSelectedItem();
            }
        });
        this.gbc.gridx = ++this.upperLeftX;
        this.gbc.gridy = this.upperLeftY;
        this.subPane.add((Component)new JLabel("Week  Ago"), this.gbc);
        ++this.gbc.gridy;
        this.subPane.add((Component)this.weekAgoBox, this.gbc);
    }

    protected void createComponents() {
        this.subPane.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.upperLeftX = 0;
        this.gbc.gridx = 0;
        this.upperLeftY = 0;
        this.gbc.gridy = 0;
        this.add(this.subPane);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private void updateToday() {
        if (this.currentTime) {
            this.today = ClockUtil.now();
            this.yesterday = new Date(this.today.getTime() - 86400000L);
            this.todayCalendar.setTime(this.today);
        }
    }

    public boolean isToday() {
        this.dateChanged();
        return this.todayButton.isSelected();
    }

    private void dateChanged() {
        this.updateToday();
        int todaysYear = this.todayCalendar.get(1);
        int calJulianDay = this.calendar.get(6);
        int todaysJulianDay = this.todayCalendar.get(6);
        int calYear = this.calendar.get(1);
        this.otherButton.setSelected(true);
        if (calYear == todaysYear) {
            if (this.yearBox != null) {
                this.yearBox.setSelectedIndex(0);
            }
            if (todaysJulianDay == calJulianDay) {
                this.todayButton.setSelected(true);
            }
            if (calJulianDay == todaysJulianDay - 1) {
                this.yesButton.setSelected(true);
            }
        } else if (this.yearBox != null) {
            int indexofyear = todaysYear - calYear;
            this.yearBox.setSelectedIndex(indexofyear);
        }
        if (this.monthBox != null) {
            this.monthBox.setSelectedIndex(this.calendar.get(2));
        }
        if (this.dayBox != null) {
            this.dayBox.setSelectedIndex(this.calendar.get(5) - 1);
        }
        if (this.hourBox != null) {
            this.hourBox.setSelectedIndex(this.calendar.get(11));
        }
        if (this.minuteBox != null) {
            this.minuteBox.setSelectedIndex(this.calendar.get(12));
        }
        if (this.secondBox != null) {
            this.secondBox.setSelectedIndex(this.calendar.get(13));
        }
        this.repaint();
    }

    public void reformat() {
        Date today = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
        try {
            String dateString = formatter.format(today);
            this.result.setForeground(Color.black);
            this.result.setText(dateString);
        }
        catch (IllegalArgumentException iae) {
            this.result.setForeground(Color.red);
            this.result.setText("Error: " + iae.getMessage());
        }
    }

    public void reformat(String newDateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(newDateFormat);
        try {
            String dateString = formatter.format((Date)ClockUtil.now());
            this.result.setForeground(Color.black);
            this.result.setText(dateString);
        }
        catch (IllegalArgumentException iae) {
            this.result.setForeground(Color.red);
            this.result.setText("Error: " + iae.getMessage());
        }
    }

    public void setDate(Date newDate) {
        this.calendar.setTime(newDate);
        this.dateChanged();
    }

    public Date getDate() {
        this.dateChanged();
        return this.calendar.getTime();
    }
}

