/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.chooser.AvailableDataStationRenderer;
import edu.sc.seis.fissuresUtil.chooser.AvailableStationDataListener;
import edu.sc.seis.fissuresUtil.chooser.BestChannelUtil;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserException;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserSeisSource;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserSource;
import edu.sc.seis.fissuresUtil.chooser.ChannelSelectionEvent;
import edu.sc.seis.fissuresUtil.chooser.ChannelSelectionListener;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.chooser.NameListCellRenderer;
import edu.sc.seis.fissuresUtil.chooser.NetworkDataEvent;
import edu.sc.seis.fissuresUtil.chooser.NetworkDataListener;
import edu.sc.seis.fissuresUtil.chooser.NetworkFromSource;
import edu.sc.seis.fissuresUtil.chooser.SortedStationJList;
import edu.sc.seis.fissuresUtil.chooser.StationAcceptor;
import edu.sc.seis.fissuresUtil.chooser.StationDataEvent;
import edu.sc.seis.fissuresUtil.chooser.StationDataListener;
import edu.sc.seis.fissuresUtil.chooser.StationLoader;
import edu.sc.seis.fissuresUtil.chooser.StationSelectionEvent;
import edu.sc.seis.fissuresUtil.chooser.StationSelectionListener;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.omg.CORBA.COMM_FAILURE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelChooser
extends JPanel {
    protected BestChannelUtil bestChanUtil = new BestChannelUtil();
    protected boolean showCodes = false;
    protected boolean showNames = true;
    protected boolean codeIsFirst = true;
    protected boolean showSites;
    protected boolean showNetworks;
    protected String[] selectableBand;
    protected String[] autoSelectBand;
    private String[] configuredNetworks;
    protected int[] selectableOrientations;
    protected int autoSelectedOrientation;
    protected ResourceBundle bundle;
    String lnettip = "Source of data";
    String lstatip = "Station";
    String lsittip = "Seismometer site";
    String lchatip = "Seismometer channels";
    String gotip = "Searches and retrieves a seismogram";
    String closetip = "Hide this window";
    String thistip = "Select date and location to obtain seismogram";
    String bhztip = "B=Broad Band | H=High Gain Seismometer | Z=Vertical";
    String bhetip = "B=Broad Band | H=High Gain Seismometer | E=East-West";
    String bhntip = "B=Broad Band | H=High Gain Seismometer | N=North-South";
    public static final int BEST_CHANNELS = 0;
    public static final int VERTICAL_ONLY = 1;
    public static final int HORIZONTAL_ONLY = 2;
    public static final int INDIVIDUAL_CHANNELS = 3;
    public static final int THREE_COMPONENT = 4;
    public static final String EXTREMELY_SHORT_PERIOD = "E";
    public static final String SHORT_PERIOD = "S";
    public static final String HIGH_BROAD_BAND = "H";
    public static final String BROAD_BAND = "B";
    public static final String MID_PERIOD = "M";
    public static final String LONG_PERIOD = "L";
    public static final String VERY_LONG_PERIOD = "V";
    public static final String ULTRA_LONG_PERIOD = "U";
    public static final String EXTREMELY_LONG_PERIOD = "R";
    public static final String ADMINISTRATIVE = "A";
    public static final String WEATHER_ENVIRONMENTAL = "W";
    public static final String EXPERIMENTAL = "X";
    private static final String[] defaultSelectableBand = new String[]{"B", "L"};
    private static final String[] defaultAutoSelectBand = new String[]{"B"};
    public static final int[] DEFAULT_SELECTABLE_ORIENTATIONS = new int[]{0, 1, 2, 3, 4};
    private static final int defaultAutoSelectedOrientation = 0;
    private JLabel netLabel;
    private JLabel staLabel;
    private JLabel siLabel;
    private JLabel orientationLabel;
    private JLabel chLabel;
    protected JList networkList;
    protected SortedStationJList stationList;
    protected JList siteList;
    protected JList orientationList;
    protected JList channelList;
    protected JProgressBar progressBar = new JProgressBar(0, 100);
    protected List<StationAcceptor> stationAcceptors = new LinkedList<StationAcceptor>();
    protected DefaultListModel networks = new DefaultListModel();
    protected DefaultListModel<StationImpl> stationNames = new DefaultListModel();
    protected HashMap<String, List<StationImpl>> stationMap = new HashMap();
    protected DefaultListModel sites = new DefaultListModel();
    protected DefaultListModel channels = new DefaultListModel();
    protected DefaultListModel bandListModel = new DefaultListModel();
    protected HashMap<String, Channel> channelMap = new HashMap();
    private List<ChannelChooserSource> netdc;
    protected HashMap<ChannelChooserSource, List<NetworkAttrImpl>> netDCToNetMap = new HashMap();
    protected HashMap<String, ChannelChooserSource> netIdToNetMap = new HashMap();
    private StationLoader stationLoader = null;
    private ChannelLoader channelLoader = null;
    private Thread progressOwner = null;
    private GridBagConstraints gbc;
    final ListCellRenderer renderer = new NameListCellRenderer(true, false, true);
    private AvailableDataStationRenderer stationRenderer;
    private List<ChannelSelectionListener> channelSelectionListeners = new ArrayList<ChannelSelectionListener>();
    private static Logger logger = LoggerFactory.getLogger((String)ChannelChooser.class.getName());

    public ChannelChooser(List<ChannelChooserSource> netDC) {
        this(netDC, false);
    }

    public ChannelChooser(List<ChannelChooserSource> netDC, boolean showSites) {
        this(netDC, showSites, new String[0]);
    }

    public ChannelChooser(List<ChannelChooserSource> netdcgiven, String[] configuredNetworks) {
        this(netdcgiven, false, configuredNetworks);
    }

    public ChannelChooser(List<ChannelChooserSource> netdcgiven, boolean showSites, String[] configuredNetworks) {
        this(netdcgiven, showSites, true, configuredNetworks);
    }

    public ChannelChooser(List<ChannelChooserSource> netdcgiven, boolean showSites, boolean showNetworks, String[] configuredNetworks) {
        this(netdcgiven, showSites, showNetworks, configuredNetworks, defaultSelectableBand, defaultAutoSelectBand);
    }

    public ChannelChooser(List<ChannelChooserSource> netdcgiven, boolean showSites, String[] configuredNetworks, String[] selectableBand, String[] autoSelectBand) {
        this(netdcgiven, showSites, true, configuredNetworks, selectableBand, autoSelectBand);
    }

    public ChannelChooser(List<ChannelChooserSource> netdcgiven, boolean showSites, boolean showNetworks, String[] configuredNetworks, String[] selectableBand, String[] autoSelectBand) {
        this(netdcgiven, showSites, showNetworks, configuredNetworks, selectableBand, autoSelectBand, DEFAULT_SELECTABLE_ORIENTATIONS, 0);
    }

    public ChannelChooser(List<ChannelChooserSource> netdcgiven, boolean showSites, String[] configuredNetworks, String[] selectableBand, String[] autoSelectBand, int[] selectableOrientations, int autoSelectedOrientation) {
        this(netdcgiven, showSites, true, configuredNetworks, selectableBand, autoSelectBand, selectableOrientations, autoSelectedOrientation);
    }

    public ChannelChooser(List<ChannelChooserSource> netdcgiven, boolean showSites, boolean showNetworks, String[] configuredNetworks, String[] selectableBand, String[] autoSelectBand, int[] selectableOrientations, int autoSelectedOrientation) {
        this.showSites = showSites;
        this.showNetworks = showNetworks;
        this.selectableOrientations = selectableOrientations;
        this.autoSelectedOrientation = autoSelectedOrientation;
        this.selectableBand = selectableBand;
        this.autoSelectBand = autoSelectBand;
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.bundle = ResourceBundle.getBundle(ChannelChooser.class.getName());
        this.initFrame();
        this.setConfiguredNetworks(configuredNetworks);
        this.setNetworkDCs(netdcgiven);
    }

    public void setSeismogramDC(ChannelChooserSeisSource seismogramSourceLocator) {
        if (this.stationRenderer != null) {
            this.stationRenderer.stopChecking();
        }
        this.stationRenderer = new AvailableDataStationRenderer(this.showNames, this.showCodes, this.codeIsFirst, seismogramSourceLocator, this);
        this.stationRenderer.setJList(this.stationList);
        this.setStationListCellRenderer(this.stationRenderer);
    }

    public void setShowCodes(boolean showCodes) {
        this.showCodes = showCodes;
        if (this.stationRenderer != null) {
            this.stationRenderer.setUseCodes(showCodes);
        }
    }

    public void setAvailbleDataOrigin(Origin origin) {
        if (this.stationRenderer != null) {
            this.stationRenderer.setOrigin(origin);
        }
    }

    public void addAvailableStationDataListener(AvailableStationDataListener dataListener) {
        if (this.stationRenderer == null) {
            throw new NullPointerException("StationRenderer is null, so cannot add availableStationDataListener");
        }
        this.stationRenderer.addAvailableStationDataListener(dataListener);
    }

    public void recheckNetworkAvailability() {
        if (this.stationRenderer == null) {
            throw new NullPointerException("StationRenderer is null, so cannot recheckNetworkAvailability");
        }
        this.stationRenderer.recheckNetworks();
    }

    public void setStationListCellRenderer(ListCellRenderer r) {
        this.stationList.setCellRenderer(r);
    }

    public void setNetworkListCellRenderer(ListCellRenderer r) {
        this.networkList.setCellRenderer(r);
    }

    public Map<ChannelChooserSource, List<NetworkAttrImpl>> getNetDCToNetMap() {
        return this.netDCToNetMap;
    }

    public void setConfiguredNetworks(String[] configuredNetworks) {
        this.configuredNetworks = new String[configuredNetworks.length];
        System.arraycopy(configuredNetworks, 0, this.configuredNetworks, 0, configuredNetworks.length);
    }

    public List<ChannelChooserSource> getNetworkDCs() {
        return this.netdc;
    }

    public void setNetworkDCs(List<ChannelChooserSource> netdcgiven) {
        this.netdc = netdcgiven;
        this.channels.clear();
        this.sites.clear();
        this.clearStations();
        this.networks.clear();
        for (ChannelChooserSource channelChooserSource : netdcgiven) {
            NetworkLoader networkLoader = new NetworkLoader(channelChooserSource);
            if (!this.showNetworks) {
                networkLoader.setDoSelect(true);
            } else {
                networkLoader.setDoSelect(false);
            }
            networkLoader.start();
        }
    }

    public void addStationAcceptor(StationAcceptor sAccept) {
        this.stationAcceptors.add(sAccept);
    }

    public void initFrame() {
        this.initWidgets();
        this.layoutWidgets();
    }

    public void appendNetwork(NetworkFromSource netsource) {
        this.netIdToNetMap.put(NetworkIdUtil.toString((NetworkId)netsource.getNetAttr().get_id()), netsource.getSource());
        this.networks.addElement(netsource);
        this.fireNetworkDataChangedEvent(netsource);
        int index = this.networks.indexOf(netsource.getNetAttr());
        this.networkList.getSelectionModel().addSelectionInterval(index, index);
    }

    public void selectAllNetworks() {
        this.networkList.getSelectionModel().setSelectionInterval(0, this.networkList.getModel().getSize() - 1);
    }

    private void layoutWidgets() {
        JScrollPane scroller;
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        if (this.showNetworks) {
            this.gbc.gridwidth = 2;
            this.add((Component)this.netLabel, this.gbc);
            ++this.gbc.gridy;
            scroller = new JScrollPane(this.networkList);
            this.gbc.weighty = 1.0;
            this.add((Component)scroller, this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = 1;
            this.gbc.weighty = 0.0;
        }
        this.gbc.gridwidth = 2;
        this.add((Component)this.staLabel, this.gbc);
        ++this.gbc.gridy;
        scroller = new JScrollPane(this.stationList);
        this.gbc.weighty = 1.0;
        this.add((Component)scroller, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.gbc.weighty = 0.0;
        if (this.showSites) {
            this.add((Component)this.siLabel, this.gbc);
            ++this.gbc.gridy;
            scroller = new JScrollPane(this.siteList);
            this.gbc.weighty = 1.0;
            this.add((Component)scroller, this.gbc);
            ++this.gbc.gridx;
            --this.gbc.gridy;
            this.gbc.weighty = 0.0;
        }
        this.add((Component)this.orientationLabel, this.gbc);
        ++this.gbc.gridy;
        scroller = new JScrollPane(this.orientationList);
        this.gbc.weighty = 0.25;
        this.add((Component)scroller, this.gbc);
        ++this.gbc.gridx;
        --this.gbc.gridy;
        this.gbc.weighty = 0.0;
        this.add((Component)this.chLabel, this.gbc);
        ++this.gbc.gridy;
        scroller = new JScrollPane(this.channelList);
        this.gbc.weighty = 0.25;
        this.add((Component)scroller, this.gbc);
        ++this.gbc.gridx;
        --this.gbc.gridy;
        this.gbc.weighty = 0.0;
        ++this.gbc.gridy;
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.weighty = 0.1;
        this.gbc.gridwidth = 0;
        this.add((Component)this.progressBar, this.gbc);
    }

    private void initWidgets() {
        this.netLabel = new JLabel(this.bundle.getString("LABEL_NETWORKS"));
        this.staLabel = new JLabel(this.bundle.getString("LABEL_STATIONS"));
        this.siLabel = new JLabel(this.bundle.getString("LABEL_SITES"));
        this.orientationLabel = new JLabel(this.bundle.getString("LABEL_ORIENTATIONS"));
        this.chLabel = new JLabel(this.bundle.getString("LABEL_CHANNELS"));
        this.netLabel.setToolTipText(this.lnettip);
        this.staLabel.setToolTipText(this.lstatip);
        this.siLabel.setToolTipText(this.lsittip);
        this.chLabel.setToolTipText(this.lchatip);
        this.networkList = new JList(this.networks);
        this.networkList.setCellRenderer(this.renderer);
        this.networkList.setSelectionMode(2);
        this.networkList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int first = e.getFirstIndex();
                int last = e.getLastIndex();
                ListSelectionModel selections = ChannelChooser.this.networkList.getSelectionModel();
                for (int i = first; i <= last; ++i) {
                    NetworkFromSource net = (NetworkFromSource)ChannelChooser.this.networks.get(i);
                    if (selections.isSelectedIndex(i)) {
                        NetworkFromSource[] nets = new NetworkFromSource[]{net};
                        StationLoader t = new StationLoader(ChannelChooser.this, nets);
                        Iterator<StationAcceptor> it = ChannelChooser.this.stationAcceptors.iterator();
                        while (it.hasNext()) {
                            t.addStationAcceptor(it.next());
                        }
                        ChannelChooser.this.setStationLoader(t);
                        t.start();
                        continue;
                    }
                    try {
                        List<StationImpl> newStations = net.getSource().getStations(net.getNetAttr());
                        for (StationImpl stationImpl : newStations) {
                            ChannelChooser.this.stationNames.removeElement(stationImpl.getName());
                            ChannelChooser.this.stationMap.remove(stationImpl.getName());
                        }
                        continue;
                    }
                    catch (ChannelChooserException e1) {
                        GlobalExceptionHandler.handle("Unable to get stations.", e1);
                    }
                }
            }
        });
        this.stationList = new SortedStationJList(this.stationNames);
        this.stationList.sort();
        this.stationList.setCellRenderer(this.renderer);
        this.stationList.setSelectionMode(2);
        this.stationList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ChannelLoader t = new ChannelLoader(e);
                ChannelChooser.this.setChannelLoader(t);
                t.start();
                ChannelChooser.this.fireStationSelectedEvent(e);
            }
        });
        this.siteList = new JList(this.sites);
        this.siteList.setCellRenderer(this.renderer);
        this.siteList.setSelectionMode(2);
        final BundleListCellRenderer bundleRenderer = new BundleListCellRenderer();
        String[] orientationTypes = new String[5];
        orientationTypes[4] = "THREE_COMPONENT";
        orientationTypes[1] = "VERTICAL_ONLY";
        orientationTypes[2] = "HORIZONTAL_ONLY";
        orientationTypes[3] = "INDIVIDUAL_CHANNELS";
        orientationTypes[0] = "BEST_CHANNELS";
        this.orientationList = new JList<String>(orientationTypes);
        this.orientationList.setCellRenderer(bundleRenderer);
        this.orientationList.setSelectionMode(0);
        this.orientationList.getSelectionModel().setSelectionInterval(this.autoSelectedOrientation, this.autoSelectedOrientation);
        this.orientationList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                String selected = (String)ChannelChooser.this.orientationList.getSelectedValue();
                if ((selected.equals("THREE_COMPONENT") || selected.equals("VERTICAL_ONLY") || selected.equals("HORIZONTAL_ONLY")) && ChannelChooser.this.channelList.getModel() != ChannelChooser.this.bandListModel) {
                    ChannelChooser.this.channelList.setModel(ChannelChooser.this.bandListModel);
                    ChannelChooser.this.channelList.setCellRenderer(bundleRenderer);
                } else if (selected.equals("INDIVIDUAL_CHANNELS") && ChannelChooser.this.channelList.getModel() != ChannelChooser.this.channels) {
                    ChannelChooser.this.channelList.setModel(ChannelChooser.this.channels);
                    ChannelChooser.this.channelList.setCellRenderer(ChannelChooser.this.renderer);
                }
            }
        });
        if (this.selectableBand != null) {
            for (int i = 0; i < this.selectableBand.length; ++i) {
                this.bandListModel.addElement(this.selectableBand[i]);
            }
        } else {
            this.bandListModel.addElement(LONG_PERIOD);
            this.bandListModel.addElement(BROAD_BAND);
            this.bandListModel.addElement(SHORT_PERIOD);
            this.bandListModel.addElement(VERY_LONG_PERIOD);
            this.bandListModel.addElement(ULTRA_LONG_PERIOD);
            this.bandListModel.addElement(EXTREMELY_LONG_PERIOD);
            this.bandListModel.addElement(MID_PERIOD);
            this.bandListModel.addElement(EXTREMELY_SHORT_PERIOD);
            this.bandListModel.addElement(HIGH_BROAD_BAND);
            this.bandListModel.addElement(ADMINISTRATIVE);
            this.bandListModel.addElement(WEATHER_ENVIRONMENTAL);
            this.bandListModel.addElement(EXPERIMENTAL);
        }
        if (this.autoSelectedOrientation == 3) {
            this.channelList = new JList(this.channels);
            this.channelList.setCellRenderer(this.renderer);
        } else {
            this.channelList = new JList(this.bandListModel);
            this.channelList.setCellRenderer(bundleRenderer);
        }
        this.channelList.setSelectionMode(2);
        ListModel chanListModel = this.channelList.getModel();
        ListSelectionModel channelSelctionModel = this.channelList.getSelectionModel();
        block1: for (int j = 0; j < this.autoSelectBand.length; ++j) {
            for (int i = 0; i < chanListModel.getSize(); ++i) {
                String listElement = (String)chanListModel.getElementAt(i);
                if (!listElement.equals(this.autoSelectBand[j])) continue;
                channelSelctionModel.addSelectionInterval(i, i);
                continue block1;
            }
        }
    }

    public List<NetworkFromSource> getNetworks() {
        ArrayList<NetworkFromSource> out = new ArrayList<NetworkFromSource>();
        Object[] objArray = this.networks.toArray();
        for (int i = 0; i < objArray.length; ++i) {
            out.add((NetworkFromSource)objArray[i]);
        }
        return out;
    }

    public void addNetworkDataListener(NetworkDataListener s) {
        this.listenerList.add(NetworkDataListener.class, s);
    }

    protected void fireNetworkDataChangedEvent(NetworkFromSource netSource) {
        NetworkDataEvent networkDataEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != NetworkDataListener.class) continue;
            if (networkDataEvent == null) {
                networkDataEvent = new NetworkDataEvent(this, netSource);
            }
            ((NetworkDataListener)listeners[i + 1]).networkDataChanged(networkDataEvent);
        }
    }

    protected void addStations(List<StationImpl> stations) {
        boolean addedStation = false;
        for (StationImpl sta : stations) {
            List<StationImpl> staList = this.stationMap.get(sta.getName());
            if (staList == null) {
                staList = new ArrayList<StationImpl>();
                this.stationMap.put(sta.getName(), staList);
                this.stationNames.addElement(sta);
                addedStation = true;
            }
            staList.add(sta);
        }
        if (addedStation) {
            this.stationList.sort();
        }
        this.fireStationDataChangedEvent((Station[])stations.toArray(new StationImpl[0]));
    }

    protected void addStationsFromThread(final List<StationImpl> sta) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChannelChooser.this.addStations(sta);
            }
        });
    }

    public void addStationDataListener(StationDataListener s) {
        this.listenerList.add(StationDataListener.class, s);
        s.stationDataCleared();
        s.stationDataChanged(new StationDataEvent(this.getStations()));
    }

    public void addStationSelectionListener(StationSelectionListener s) {
        this.listenerList.add(StationSelectionListener.class, s);
        s.stationSelectionChanged(new StationSelectionEvent(this, this.getSelectedStations()));
    }

    protected void fireStationDataChangedEvent(Station[] stations) {
        StationDataEvent stationDataEvent = new StationDataEvent(stations);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StationDataListener.class) continue;
            ((StationDataListener)listeners[i + 1]).stationDataChanged(stationDataEvent);
        }
    }

    protected void fireStationDataClearedEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StationDataListener.class) continue;
            ((StationDataListener)listeners[i + 1]).stationDataCleared();
        }
    }

    protected void fireStationSelectedEvent(ListSelectionEvent e) {
        StationSelectionEvent stationSelectionEvent = new StationSelectionEvent(this, this.getSelectedStations());
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StationSelectionListener.class) continue;
            ((StationSelectionListener)listeners[i + 1]).stationSelectionChanged(stationSelectionEvent);
        }
    }

    public Station[] getStations() {
        LinkedList<StationImpl> out = new LinkedList<StationImpl>();
        Object[] objArray = this.stationNames.toArray();
        for (int i = 0; i < objArray.length; ++i) {
            String name = ((Station)objArray[i]).getName();
            List<StationImpl> staList = this.stationMap.get(name);
            if (staList == null) {
                logger.warn("no stations for name=" + name);
                continue;
            }
            out.addAll(staList);
        }
        return out.toArray(new Station[0]);
    }

    protected void clearStations() {
        this.stationNames.clear();
        this.stationMap.clear();
        this.fireStationDataClearedEvent();
    }

    protected void clearStationsFromThread() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ChannelChooser.this.clearStations();
                }
            });
        }
        catch (InterruptedException e) {
            logger.warn("Caught exception while clearing stations, will continue. Hope all is well...", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.warn("Caught exception while clearing stations, will continue. Hope all is well...", (Throwable)e);
        }
    }

    public Channel getChannel(ChannelId chanId) {
        return this.channelMap.get(ChannelIdUtil.toString((ChannelId)chanId));
    }

    public Channel[] getChannels() {
        Channel[] outChannels = this.channelMap.values().toArray(new Channel[0]);
        return outChannels;
    }

    public List<ChannelImpl> getChannels(StationImpl station) throws ChannelChooserException {
        ChannelChooserSource net = this.netIdToNetMap.get(NetworkIdUtil.toString((NetworkId)station.get_id().network_id));
        List<ChannelImpl> staChans = net.getChannels(station);
        return staChans;
    }

    public List<ChannelImpl> getChannels(StationImpl station, MicroSecondDate when) throws ChannelChooserException {
        List<ChannelImpl> in = this.getChannels(station);
        ArrayList<ChannelImpl> out = new ArrayList<ChannelImpl>();
        for (ChannelImpl channelImpl : in) {
            MicroSecondDate b = new MicroSecondDate(channelImpl.getBeginTime());
            MicroSecondDate e = new MicroSecondDate(channelImpl.getEndTime());
            if (!when.after((Date)b) || !when.before((Date)e)) continue;
            out.add(channelImpl);
        }
        return out;
    }

    public String[] getSelectedChanCodes() {
        Object[] vals = this.channelList.getSelectedValues();
        String[] out = new String[vals.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (String)vals[i];
        }
        return out;
    }

    public List<NetworkFromSource> getSelectedNetworks() {
        if (!this.showNetworks) {
            return this.getNetworks();
        }
        ArrayList<NetworkFromSource> out = new ArrayList<NetworkFromSource>();
        Object[] selected = this.networkList.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            out.add((NetworkFromSource)selected[i]);
        }
        return out;
    }

    public StationImpl[] getSelectedStations() {
        LinkedList<StationImpl> out = new LinkedList<StationImpl>();
        List selected = this.stationList.getSelectedValuesList();
        for (StationImpl selSta : selected) {
            List<StationImpl> staList = this.stationMap.get(selSta.getName());
            out.addAll(staList);
        }
        return out.toArray(new StationImpl[0]);
    }

    public StationImpl[] getSelectedStations(MicroSecondDate when) {
        StationImpl[] in = this.getSelectedStations();
        return ChannelChooser.getStationsThatExistOnDate(when, in);
    }

    public static StationImpl[] getStationsThatExistOnDate(MicroSecondDate when, StationImpl[] in) {
        ArrayList<StationImpl> out = new ArrayList<StationImpl>();
        for (int i = 0; i < in.length; ++i) {
            MicroSecondDate b = new MicroSecondDate(in[i].getBeginTime());
            MicroSecondDate e = new MicroSecondDate(in[i].getEndTime());
            if (!when.after((Date)b) || !when.before((Date)e)) continue;
            out.add(in[i]);
        }
        return out.toArray(new StationImpl[out.size()]);
    }

    public void clearStationSelection() {
        this.stationList.getSelectionModel().clearSelection();
    }

    public void toggleStationSelected(Station stat) {
        int i;
        ListSelectionModel selModel = this.stationList.getSelectionModel();
        if (selModel.isSelectedIndex(i = this.findIndex(stat))) {
            selModel.removeSelectionInterval(i, i);
        } else {
            selModel.addSelectionInterval(i, i);
        }
        this.stationList.ensureIndexIsVisible(i);
    }

    public void select(Station stat) {
        ListSelectionModel selModel = this.stationList.getSelectionModel();
        int i = this.findIndex(stat);
        selModel.addSelectionInterval(i, i);
        this.stationList.ensureIndexIsVisible(i);
    }

    public void deselect(Station stat) {
        ListSelectionModel selModel = this.stationList.getSelectionModel();
        int i = this.findIndex(stat);
        selModel.removeSelectionInterval(i, i);
        this.stationList.ensureIndexIsVisible(i);
    }

    private int findIndex(Station stat) {
        ListModel listModel = this.stationList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Station cur = (Station)listModel.getElementAt(i);
            if (!cur.equals(stat)) continue;
            return i;
        }
        return -1;
    }

    public boolean isSourceKnown(NetworkId netid) {
        ChannelChooserSource net = this.netIdToNetMap.get(NetworkIdUtil.toString((NetworkId)netid));
        return net != null;
    }

    public ChannelChooserSource getSource(NetworkId netid) {
        ChannelChooserSource net = this.netIdToNetMap.get(NetworkIdUtil.toString((NetworkId)netid));
        if (net == null) {
            logger.debug("source for " + NetworkIdUtil.toString((NetworkId)netid) + " is not yet loaded, trying from remote server");
            List<ChannelChooserSource> retrievedDCs = this.getNetworkDCs();
            for (ChannelChooserSource channelChooserSource : retrievedDCs) {
                try {
                    List<NetworkAttrImpl> netsFromSource = channelChooserSource.getNetworks();
                    for (NetworkAttrImpl networkAttrImpl : netsFromSource) {
                        if (!NetworkIdUtil.areEqual((NetworkId)networkAttrImpl.get_id(), (NetworkId)netid)) continue;
                        return channelChooserSource;
                    }
                }
                catch (COMM_FAILURE netsFromSource) {
                }
                catch (ChannelChooserException e) {
                    logger.warn("unable to get networks from " + channelChooserSource.toString());
                }
            }
        }
        return net;
    }

    public ChannelImpl[] getSelectedChannels() throws ChannelChooserException {
        return this.getSelectedChannels(ClockUtil.now());
    }

    public ChannelImpl[] getSelectedChannels(MicroSecondDate when) throws ChannelChooserException {
        LinkedList<ChannelImpl> outChannels = new LinkedList<ChannelImpl>();
        StationImpl[] selectedStations = this.getSelectedStations(when);
        logger.debug(selectedStations.length + " stations before pruning");
        LinkedList<StationImpl> outStations = new LinkedList<StationImpl>();
        for (int i = 0; i < selectedStations.length - 1; ++i) {
            boolean foundDup = false;
            for (int j = i + 1; j < selectedStations.length; ++j) {
                if (!selectedStations[i].getName().equals(selectedStations[j].getName()) || !selectedStations[i].get_code().equals(selectedStations[j].get_code()) || selectedStations[i].getLocation().latitude != selectedStations[j].getLocation().latitude || selectedStations[i].getLocation().longitude != selectedStations[j].getLocation().longitude) continue;
                foundDup = true;
                break;
            }
            if (foundDup) continue;
            outStations.add(selectedStations[i]);
        }
        if (selectedStations.length > 0) {
            outStations.add(selectedStations[selectedStations.length - 1]);
        }
        selectedStations = outStations.toArray(new StationImpl[outStations.size()]);
        logger.debug(selectedStations.length + " stations after pruning");
        Object[] selectedChannelCodes = this.channelList.getSelectedValues();
        String[] siteCodeHeuristic = this.bestChanUtil.getSiteCodeHeuristic();
        for (int staNum = 0; staNum < selectedStations.length; ++staNum) {
            ChannelChooserSource net = this.netIdToNetMap.get(NetworkIdUtil.toString((NetworkId)selectedStations[staNum].get_id().network_id));
            ChannelImpl[] staChans = ChannelImpl.implize((Channel[])((Channel[])net.getChannels(selectedStations[staNum]).toArray(new ChannelImpl[0])));
            if (!this.showSites) {
                if (this.orientationList.getSelectedValue().equals("INDIVIDUAL_CHANNELS")) {
                    block3: for (int bandNum = 0; bandNum < selectedChannelCodes.length; ++bandNum) {
                        for (int chanNum = 0; chanNum < staChans.length; ++chanNum) {
                            for (int h = 0; h < siteCodeHeuristic.length; ++h) {
                                if (!staChans[chanNum].getSite().get_code().equals(siteCodeHeuristic[h]) || !staChans[chanNum].get_code().equals(selectedChannelCodes[bandNum])) continue;
                                outChannels.add(staChans[chanNum]);
                                continue block3;
                            }
                        }
                    }
                    continue;
                }
                String orientation = (String)this.orientationList.getSelectedValue();
                for (int i = 0; i < selectedChannelCodes.length; ++i) {
                    String bc = (String)selectedChannelCodes[i];
                    ChannelImpl[] chans = null;
                    if (orientation.equals("VERTICAL_ONLY")) {
                        chans = this.getVerticalChannel(staChans, bc);
                    } else if (orientation.equals("HORIZONTAL_ONLY")) {
                        chans = this.getHorizontalChannels(staChans, bc);
                    } else if (orientation.equals("THREE_COMPONENT")) {
                        chans = this.bestChanUtil.getBestMotionVector(BestChannelUtil.getAllBand(Arrays.asList(staChans), bc));
                    } else if (orientation.equals("BEST_CHANNELS")) {
                        chans = this.bestChanUtil.getBestMotionVector(BestChannelUtil.getAllBand(Arrays.asList(staChans), bc));
                        if (chans == null || chans.length == 0) {
                            ChannelImpl[] channelImplArray = new ChannelImpl[1];
                            channelImplArray[0] = this.bestChanUtil.getBestChannel(BestChannelUtil.getAllBand(Arrays.asList(staChans), bc));
                            chans = channelImplArray;
                        }
                    }
                    if (chans == null) continue;
                    for (int j = 0; j < chans.length; ++j) {
                        ChannelImpl channel = chans[j];
                        if (channel == null) continue;
                        outChannels.add(channel);
                    }
                }
                continue;
            }
            ChannelImpl[] inChannels = ChannelImpl.implize((Channel[])this.getChannels());
            inChannels = BestChannelUtil.pruneChannels(Arrays.asList(inChannels), when).toArray(new ChannelImpl[0]);
            Object[] selectedSiteCodes = this.siteList.getSelectedValues();
            block8: for (int i = 0; i < inChannels.length; ++i) {
                for (int j = 0; j < selectedSiteCodes.length; ++j) {
                    for (int k = 0; k < selectedChannelCodes.length; ++k) {
                        if (!inChannels[i].getSite().get_code().equals(selectedSiteCodes[j]) || !inChannels[i].get_code().equals(selectedChannelCodes[k])) continue;
                        outChannels.add(inChannels[i]);
                        continue block8;
                    }
                }
            }
        }
        logger.debug("Found " + outChannels.size() + " channels");
        return outChannels.toArray(new ChannelImpl[0]);
    }

    private ChannelImpl[] getVerticalChannel(ChannelImpl[] chanArray, String bandCode) {
        return new ChannelImpl[]{this.bestChanUtil.getBestChannel(BestChannelUtil.getAllBand(Arrays.asList(chanArray), bandCode))};
    }

    private ChannelImpl[] getHorizontalChannels(ChannelImpl[] allChannels, String bandCode) {
        ChannelImpl[] vector = this.bestChanUtil.getBestMotionVector(BestChannelUtil.getAllBand(Arrays.asList(allChannels), bandCode));
        return this.bestChanUtil.getAllHorizontal(Arrays.asList(vector)).toArray(new ChannelImpl[0]);
    }

    protected synchronized StationLoader getStationLoader() {
        return this.stationLoader;
    }

    protected synchronized void setStationLoader(StationLoader v) {
        this.stationLoader = v;
    }

    protected synchronized ChannelLoader getChannelLoader() {
        return this.channelLoader;
    }

    protected synchronized void setChannelLoader(ChannelLoader v) {
        this.channelLoader = v;
    }

    protected synchronized void setProgressOwner(Thread t) {
        this.progressBar.setValue(0);
        this.progressOwner = t;
    }

    protected synchronized void setProgressValue(Thread t, int value) {
        if (t.equals(this.progressOwner)) {
            this.progressBar.setValue(value);
        }
    }

    protected synchronized void setProgressMax(Thread t, int max) {
        if (t.equals(this.progressOwner)) {
            this.progressBar.setMaximum(max);
        }
    }

    private void fireChannelSelectionEvent(ChannelSelectionEvent e) {
        Iterator<ChannelSelectionListener> it = this.channelSelectionListeners.iterator();
        while (it.hasNext()) {
            it.next().channelSelectionChanged(e);
        }
    }

    public void addChannelSelectionListener(ChannelSelectionListener csl) {
        this.channelSelectionListeners.add(csl);
    }

    public void removeChannelSelectionListener(ChannelSelectionListener csl) {
        this.channelSelectionListeners.remove(csl);
    }

    class ChannelLoader
    extends Thread {
        ListSelectionEvent e;

        public ChannelLoader(ListSelectionEvent e) {
            this.e = e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ChannelChooser.this.setProgressOwner(this);
            ChannelChooser.this.setProgressMax(this, this.e.getLastIndex() - this.e.getFirstIndex() + 1);
            for (int i = this.e.getFirstIndex(); i <= this.e.getLastIndex(); ++i) {
                String staName = ((Station)ChannelChooser.this.stationNames.getElementAt(i)).getName();
                List<StationImpl> stations = ChannelChooser.this.stationMap.get(staName);
                for (StationImpl sta : stations) {
                    ChannelChooser channelChooser = ChannelChooser.this;
                    synchronized (channelChooser) {
                        if (this.equals(ChannelChooser.this.getChannelLoader())) {
                            if (!ChannelChooser.this.stationList.isSelectedIndex(i)) {
                                this.removeChannels((Station)sta);
                                continue;
                            }
                        } else {
                            return;
                        }
                    }
                    List<ChannelImpl> chans = null;
                    ChannelChooserSource net = ChannelChooser.this.netIdToNetMap.get(NetworkIdUtil.toString((NetworkId)sta.get_id().network_id));
                    if (net != null) {
                        try {
                            chans = net.getChannels(sta);
                        }
                        catch (ChannelChooserException e1) {
                            GlobalExceptionHandler.handle(e1);
                        }
                    } else {
                        logger.warn("Unable to find network server for station " + sta.getName() + " " + StationIdUtil.toString((StationId)sta.get_id()));
                        continue;
                    }
                    ChannelChooser channelChooser2 = ChannelChooser.this;
                    synchronized (channelChooser2) {
                        if (this.equals(ChannelChooser.this.getChannelLoader())) {
                            if (ChannelChooser.this.stationList.isSelectedIndex(i)) {
                                try {
                                    this.addChannels(chans);
                                }
                                catch (ChannelChooserException e1) {
                                    GlobalExceptionHandler.handle(e1);
                                }
                            }
                        } else {
                            return;
                        }
                    }
                }
                ChannelChooser.this.setProgressValue(this, i - this.e.getFirstIndex());
            }
            ChannelChooser.this.progressBar.setValue(ChannelChooser.this.progressBar.getMaximum());
        }

        void addChannels(List<ChannelImpl> chans) throws ChannelChooserException {
            for (ChannelImpl channelImpl : chans) {
                String chanKey = ChannelIdUtil.toString((ChannelId)channelImpl.get_id());
                if (ChannelChooser.this.channelMap.containsKey(chanKey)) continue;
                ChannelChooser.this.channelMap.put(chanKey, (Channel)channelImpl);
                if (!ChannelChooser.this.sites.contains(channelImpl.getSite().get_code())) {
                    ChannelChooser.this.sites.addElement(channelImpl.getSite().get_code());
                }
                if (ChannelChooser.this.channels.contains(channelImpl.get_code())) continue;
                ChannelChooser.this.channels.addElement(channelImpl.get_code());
            }
            ChannelChooser.this.fireChannelSelectionEvent(new ChannelSelectionEvent(ChannelChooser.this.getSelectedChannels()));
        }

        void removeChannels(Channel[] chans) {
            for (int j = 0; j < chans.length; ++j) {
                String chanKey = ChannelIdUtil.toString((ChannelId)chans[j].get_id());
                if (!ChannelChooser.this.channelMap.containsKey(chanKey)) continue;
                ChannelChooser.this.channelMap.remove(chanKey);
            }
        }

        void removeChannels(Station station) {
            String stationPrefix = NetworkIdUtil.toString((NetworkId)station.get_id().network_id) + "." + station.get_id().station_code;
            Iterator<String> it = ChannelChooser.this.channelMap.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                if (!key.startsWith(stationPrefix)) continue;
                it.remove();
            }
        }
    }

    class NetworkLoader
    extends Thread {
        ChannelChooserSource netDC;
        boolean doSelect = true;

        public NetworkLoader(ChannelChooserSource channelChooserSource) {
            this.netDC = channelChooserSource;
        }

        public void setDoSelect(boolean b) {
            this.doSelect = b;
        }

        @Override
        public void run() {
            ChannelChooser.this.setProgressOwner(this);
            if (ChannelChooser.this.configuredNetworks == null || ChannelChooser.this.configuredNetworks.length == 0) {
                try {
                    logger.info("before get networks: " + this.netDC);
                    List<NetworkAttrImpl> nets = this.netDC.getNetworks();
                    if (nets == null) {
                        nets = new ArrayList<NetworkAttrImpl>();
                        logger.warn("the array returned from NetworkFinder.retrieve_all() is null.  this is wrong.");
                    }
                    ChannelChooser.this.netDCToNetMap.put(this.netDC, nets);
                    ChannelChooser.this.setProgressMax(this, nets.size() + 1);
                    int progressVal = 1;
                    ChannelChooser.this.setProgressValue(this, progressVal);
                    ++progressVal;
                    for (NetworkAttrImpl networkAttrImpl : nets) {
                        if (networkAttrImpl != null) {
                            this.networkAdd(new NetworkFromSource(networkAttrImpl, this.netDC));
                        } else {
                            logger.warn("a networkaccess returned from NetworkFinder.retrieve_all() is null, skipping.");
                        }
                        ChannelChooser.this.setProgressValue(this, progressVal);
                        ++progressVal;
                    }
                }
                catch (ChannelChooserException e) {
                    logger.warn("Unable to get networks from " + this.netDC, (Throwable)e);
                }
            } else {
                int totalNetworks = 0;
                ChannelChooser.this.setProgressMax(this, ChannelChooser.this.configuredNetworks.length);
                for (int counter = 0; counter < ChannelChooser.this.configuredNetworks.length; ++counter) {
                    try {
                        List<NetworkAttrImpl> netList = this.netDC.getNetworks();
                        for (NetworkAttrImpl netAttr : netList) {
                            if (!netAttr.get_code().equals(ChannelChooser.this.configuredNetworks[counter])) continue;
                            List<NetworkAttrImpl> storedNets = ChannelChooser.this.netDCToNetMap.get(this.netDC);
                            if (storedNets == null) {
                                storedNets = new ArrayList<NetworkAttrImpl>();
                                storedNets.add(netAttr);
                                ChannelChooser.this.netDCToNetMap.put(this.netDC, storedNets);
                            } else {
                                ChannelChooser.this.netDCToNetMap.get(this.netDC).add(netAttr);
                            }
                            this.networkAdd(new NetworkFromSource(netAttr, this.netDC));
                            ++totalNetworks;
                            break;
                        }
                    }
                    catch (ChannelChooserException e) {
                        logger.warn("Problem with Network " + ChannelChooser.this.configuredNetworks[counter] + " from source " + this.netDC);
                    }
                    ChannelChooser.this.setProgressValue(this, counter + 1);
                }
            }
            if (this.doSelect) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChannelChooser.this.selectAllNetworks();
                    }
                });
            }
            ChannelChooser.this.setProgressValue(this, ChannelChooser.this.progressBar.getMaximum());
        }

        void networkAdd(final NetworkFromSource netSource) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChannelChooser.this.appendNetwork(netSource);
                }
            });
        }
    }

    class BundleListCellRenderer
    extends DefaultListCellRenderer {
        BundleListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object useValue = value;
            String name = "XXXX";
            try {
                name = ChannelChooser.this.bundle.getString((String)value);
                useValue = name;
            }
            catch (MissingResourceException e) {
                try {
                    name = ChannelChooser.this.bundle.getString("BANDNAME_" + (String)value);
                    useValue = name;
                }
                catch (MissingResourceException ee) {
                    useValue = value;
                }
            }
            if (useValue.equals(name) && (name == null || name.length() == 0)) {
                useValue = value;
            }
            return super.getListCellRendererComponent((JList<?>)list, useValue, index, isSelected, cellHasFocus);
        }
    }
}

