/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.AvailableStationDataEvent;
import edu.sc.seis.fissuresUtil.chooser.AvailableStationDataListener;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserException;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserSeisSource;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.chooser.NameListCellRenderer;
import edu.sc.seis.fissuresUtil.chooser.NetworkDataEvent;
import edu.sc.seis.fissuresUtil.chooser.NetworkDataListener;
import edu.sc.seis.fissuresUtil.chooser.NetworkFromSource;
import edu.sc.seis.fissuresUtil.chooser.SortedStationJList;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableDataStationRenderer
extends NameListCellRenderer {
    private static Color STATION_AVAILABLE = Color.BLUE;
    private static Color STATION_UNAVAILABLE = Color.GRAY;
    protected LinkedList stationsToCheck = new LinkedList();
    protected Map stationsUpNow = new HashMap();
    protected ChannelChooserSeisSource dc;
    protected TimeInterval TEN_MINUTES = new TimeInterval(20.0, UnitImpl.MINUTE);
    protected ChannelChooser channelChooser = null;
    protected JList jlist = null;
    protected Origin origin = null;
    private WorkerThreadPool netCheckerPool = new WorkerThreadPool("Network Station Availability Checker", 5);
    private List netCheckers = new ArrayList();
    private static Logger logger = LoggerFactory.getLogger(AvailableDataStationRenderer.class);

    public AvailableDataStationRenderer(boolean useNames) {
        super(useNames);
    }

    public AvailableDataStationRenderer(boolean useNames, boolean useCodes, boolean codeIsFirst) {
        super(useNames, useCodes, codeIsFirst);
    }

    public AvailableDataStationRenderer(boolean useNames, boolean useCodes, boolean codeIsFirst, ChannelChooserSeisSource dc, ChannelChooser channelChooser) {
        super(useNames, useCodes, codeIsFirst);
        this.dc = dc;
        this.channelChooser = channelChooser;
        this.startThread();
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
        this.recheckNetworks();
    }

    protected void startThread() {
        this.recheckNetworks();
        this.channelChooser.addNetworkDataListener(new NetworkDataListener(){

            @Override
            public void networkDataCleared() {
            }

            @Override
            public void networkDataChanged(NetworkDataEvent s) {
                AvailableDataStationRenderer.this.startNetworkChecker(s.getNetworkFromSource());
            }
        });
    }

    protected void recheckNetworks() {
        this.stationsUpNow.clear();
        List<NetworkFromSource> nets = this.channelChooser.getNetworks();
        for (NetworkFromSource networkFromSource : nets) {
            this.startNetworkChecker(networkFromSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopChecking() {
        super.stopChecking();
        List list = this.netCheckers;
        synchronized (list) {
            Iterator it = this.netCheckers.iterator();
            while (it.hasNext()) {
                ((NetworkChecker)it.next()).stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNetworkChecker(NetworkFromSource na) {
        NetworkChecker checker = null;
        List list = this.netCheckers;
        synchronized (list) {
            Iterator it = this.netCheckers.iterator();
            NetworkId naId = na.getNetAttr().get_id();
            while (it.hasNext()) {
                NetworkChecker cur = (NetworkChecker)it.next();
                NetworkId curId = cur.getNetwork().getNetAttr().get_id();
                if (!NetworkIdUtil.areEqual((NetworkId)curId, (NetworkId)naId)) continue;
                checker = cur;
                checker.stop();
                break;
            }
            if (checker == null) {
                checker = new NetworkChecker(na);
                this.netCheckers.add(checker);
            }
            this.netCheckerPool.invokeLater(checker);
        }
    }

    protected synchronized void addAvailableStationDataListener(AvailableStationDataListener listener) {
        this.listenerList.add(AvailableStationDataListener.class, listener);
        Set keySet = this.stationsUpNow.keySet();
        for (Station station : keySet) {
            Object obj = this.stationsUpNow.get(station);
            if (obj instanceof Station) continue;
            int status = (Boolean)obj != false ? 2 : 1;
            listener.stationAvailabiltyChanged(new AvailableStationDataEvent(station, status));
        }
    }

    protected synchronized void fireStationAvailabilityChanged(Station sta, boolean isUp) {
        Object[] listeners = this.listenerList.getListenerList();
        AvailableStationDataEvent fooEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AvailableStationDataListener.class) continue;
            if (fooEvent == null) {
                int status = isUp ? 2 : 1;
                fooEvent = new AvailableStationDataEvent(sta, status);
            }
            ((AvailableStationDataListener)listeners[i + 1]).stationAvailabiltyChanged(fooEvent);
        }
    }

    public void setJList(JList jlist) {
        this.jlist = jlist;
        if (jlist instanceof SortedStationJList) {
            ((SortedStationJList)jlist).setNamer(this);
        }
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        Station station = (Station)value;
        if (this.stationsUpNow.get(station) != null && this.stationsUpNow.get(station) instanceof Boolean) {
            Boolean val = (Boolean)this.stationsUpNow.get(station);
            if (val.booleanValue()) {
                c.setForeground(STATION_AVAILABLE);
            } else {
                c.setForeground(STATION_UNAVAILABLE);
            }
        } else if (this.stationsUpNow.get(station) == null) {
            if (this.stationsToCheck.contains(station)) {
                this.increasePriority(station);
            } else {
                this.addToCheck(station);
            }
        }
        return c;
    }

    public RequestFilter[] createFakeRequestBHZ(Channel[] chan) {
        MicroSecondDate now = ClockUtil.now();
        TimeRange range = new TimeRange(now.subtract(this.TEN_MINUTES).getFissuresTime(), now.getFissuresTime());
        RequestFilter[] request = new RequestFilter[]{};
        for (int i = 0; i < chan.length; ++i) {
            if (!chan[i].get_code().equals("BHZ") && !chan[i].get_code().equals("LHZ") && !chan[i].get_code().equals("SHZ") && !chan[i].get_code().equals("HHZ")) continue;
            RequestFilter[] tmp = new RequestFilter[request.length + 1];
            System.arraycopy(request, 0, tmp, 0, request.length);
            tmp[tmp.length - 1] = new RequestFilter(chan[i].get_id(), range.start_time, range.end_time);
            request = tmp;
        }
        return request;
    }

    protected synchronized void increasePriority(Station station) {
        if (this.stationsToCheck.contains(station)) {
            this.stationsToCheck.remove(station);
            this.stationsToCheck.addFirst(station);
        }
    }

    protected synchronized void addToCheck(Station station) {
        this.stationsToCheck.addFirst(station);
        this.notifyAll();
    }

    protected synchronized Station getToCheck() throws InterruptedException {
        while (this.stationsToCheck.isEmpty()) {
            this.wait();
        }
        Station sta = (Station)this.stationsToCheck.removeFirst();
        this.stationsUpNow.put(sta, sta);
        return sta;
    }

    protected synchronized void finishedCheck(Station station, boolean val) {
        if (val) {
            this.stationsUpNow.put(station, Boolean.TRUE);
        } else {
            this.stationsUpNow.put(station, Boolean.FALSE);
        }
        this.fireStationAvailabilityChanged(station, val);
        this.stationsToCheck.remove(station);
        if (this.jlist != null) {
            this.jlist.repaint();
        }
    }

    protected synchronized void finishedError(Station station) {
        this.stationsUpNow.remove(station);
        this.stationsToCheck.remove(station);
        logger.warn("Seismogram server not found for " + StationIdUtil.toString((StationId)station.get_id()));
    }

    protected synchronized void finishedError(Station station, Throwable e) {
        this.stationsUpNow.remove(station);
        this.stationsToCheck.remove(station);
        logger.error("Problem doing available data for " + StationIdUtil.toString((StationId)station.get_id()), e);
    }

    private static void stripStationCodeSuffix(ChannelId id, String suffix) {
        if (id.station_code.endsWith(suffix)) {
            id.station_code = id.station_code.substring(0, suffix.length());
        }
    }

    class NetworkChecker
    extends AbstractJob {
        NetworkFromSource net;
        boolean quitThread;

        NetworkChecker(NetworkFromSource na) {
            super(na.getNetAttr().get_code() + " Available Data");
            this.net = na;
            JobTracker.getTracker().add(this);
            logger.info("constructor NetworkChecker " + this.net.getNetAttr().get_id().network_code);
        }

        public void stop() {
            this.quitThread = true;
        }

        public int hashCode() {
            return NetworkIdUtil.hashCode((NetworkId)this.net.getNetAttr().get_id());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof NetworkChecker) {
                NetworkId myId = this.net.getNetAttr().get_id();
                NetworkId oId = ((NetworkChecker)o).net.getNetAttr().get_id();
                return NetworkIdUtil.areEqual((NetworkId)myId, (NetworkId)oId);
            }
            return false;
        }

        public NetworkFromSource getNetwork() {
            return this.net;
        }

        @Override
        public void runJob() {
            this.setFinished(false);
            this.quitThread = false;
            while (!this.quitThread) {
                try {
                    this.checkNet();
                }
                catch (ChannelChooserException e) {
                    logger.warn("Problem checking networks", (Throwable)e);
                }
            }
            logger.debug("network checker thread quitting");
            this.setFinished();
        }

        void checkNet() throws ChannelChooserException {
            TimeRange range;
            logger.info("checking " + this.net.getNetAttr().get_code());
            this.setStatus("Creating available data request");
            if (AvailableDataStationRenderer.this.origin == null) {
                MicroSecondDate now = ClockUtil.now();
                range = new TimeRange(now.subtract(AvailableDataStationRenderer.this.TEN_MINUTES).getFissuresTime(), now.getFissuresTime());
            } else {
                MicroSecondDate oTime = new MicroSecondDate(AvailableDataStationRenderer.this.origin.getOriginTime());
                range = new TimeRange(oTime.getFissuresTime(), oTime.add(AvailableDataStationRenderer.this.TEN_MINUTES).getFissuresTime());
            }
            String[] siteCodes = new String[]{"00", "  "};
            String[] chanCodes = AvailableDataStationRenderer.this.channelChooser.getSelectedChanCodes();
            RequestFilter[] request = new RequestFilter[chanCodes.length * siteCodes.length];
            for (int c = 0; c < chanCodes.length; ++c) {
                while (chanCodes[c].length() < 3) {
                    int n = c;
                    chanCodes[n] = chanCodes[n] + "?";
                }
                for (int l = 0; l < siteCodes.length; ++l) {
                    request[c * siteCodes.length + l] = new RequestFilter(new ChannelId(this.net.getNetAttr().get_id(), "*", siteCodes[l], chanCodes[c], range.start_time), range.start_time, range.end_time);
                }
            }
            List<StationImpl> stations = this.net.getSource().getStations(this.net.getNetAttr());
            AvailableDataStationRenderer.this.channelChooser.addStations(stations);
            LinkedList<StationImpl> allStations = new LinkedList<StationImpl>();
            for (StationImpl stationImpl : stations) {
                allStations.add(stationImpl);
                logger.debug(StationIdUtil.toString((StationId)stationImpl.get_id()));
            }
            this.setStatus("Checking data availability");
            List<Object> available = new ArrayList();
            try {
                available = AvailableDataStationRenderer.this.dc.availableData(Arrays.asList(request));
            }
            catch (Throwable t) {
                for (Station station : allStations) {
                    AvailableDataStationRenderer.this.finishedError(station, t);
                }
                this.quitThread = true;
                GlobalExceptionHandler.handle(t);
                return;
            }
            logger.info(available.size() + " items returned for " + this.net.getNetAttr().get_code());
            this.setStatus(available.size() + " items returned");
            if (available.size() == 0) {
                logger.warn("there is no available data " + this.net.getNetAttr().get_code());
            }
            for (RequestFilter requestFilter : available) {
                AvailableDataStationRenderer.stripStationCodeSuffix(requestFilter.channel_id, "-farm");
                AvailableDataStationRenderer.stripStationCodeSuffix(requestFilter.channel_id, "-spyder");
                Iterator iterator = allStations.iterator();
                while (iterator.hasNext()) {
                    Station station = (Station)iterator.next();
                    if (!station.get_code().equals(requestFilter.channel_id.station_code)) continue;
                    AvailableDataStationRenderer.this.finishedCheck(station, true);
                    iterator.remove();
                }
            }
            for (Station station : allStations) {
                AvailableDataStationRenderer.this.finishedCheck(station, false);
            }
            this.quitThread = true;
        }
    }
}

