/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.CacheEventDC;
import edu.sc.seis.fissuresUtil.cache.CachePlottableDC;
import edu.sc.seis.fissuresUtil.cache.ClassicRetryStrategy;
import edu.sc.seis.fissuresUtil.cache.NSEventDC;
import edu.sc.seis.fissuresUtil.cache.NSPlottableDC;
import edu.sc.seis.fissuresUtil.cache.NSSeismogramDC;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.ProxyEventDC;
import edu.sc.seis.fissuresUtil.cache.ProxyPlottableDC;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import edu.sc.seis.fissuresUtil.cache.RetryEventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.RetryEventDC;
import edu.sc.seis.fissuresUtil.cache.RetryPlottableDC;
import edu.sc.seis.fissuresUtil.cache.RetrySeismogramDC;
import edu.sc.seis.fissuresUtil.cache.RetryStrategy;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;

public class BulletproofVestFactory {
    protected static int defaultTimeoutSeconds = 20;
    protected static int sleepSeconds = 1;
    private static int defaultNumRetry = 3;

    public static ProxyEventAccessOperations vestEventAccess(EventAccessOperations eventAccess) {
        return BulletproofVestFactory.vestEventAccess(eventAccess, 3);
    }

    public static ProxyEventAccessOperations vestEventAccess(EventAccessOperations eventAccess, int numRetry) {
        if (eventAccess == null) {
            throw new IllegalArgumentException("eventAccess cannot be null");
        }
        if (eventAccess instanceof CacheEvent) {
            return (ProxyEventAccessOperations)eventAccess;
        }
        RetryEventAccessOperations retry = new RetryEventAccessOperations(eventAccess, numRetry);
        CacheEvent cache = new CacheEvent((EventAccessOperations)retry);
        return cache;
    }

    public static ProxyEventAccessOperations[] vestEventAccess(EventAccessOperations[] events) {
        return BulletproofVestFactory.vestEventAccess(events, 3);
    }

    public static ProxyEventAccessOperations[] vestEventAccess(EventAccessOperations[] events, int numRetry) {
        ProxyEventAccessOperations[] out = new ProxyEventAccessOperations[events.length];
        for (int i = 0; i < events.length; ++i) {
            out[i] = BulletproofVestFactory.vestEventAccess(events[i], numRetry);
        }
        return out;
    }

    public static ProxyEventDC vestEventDC(String serverDNS, String serverName, FissuresNamingService fisName) {
        return BulletproofVestFactory.vestEventDC(serverDNS, serverName, fisName, new ClassicRetryStrategy(BulletproofVestFactory.getDefaultNumRetry()));
    }

    public static ProxyEventDC vestEventDC(String serverDNS, String serverName, FissuresNamingService fisName, RetryStrategy strat) {
        NSEventDC ns = new NSEventDC(serverDNS, serverName, fisName);
        RetryEventDC retry = new RetryEventDC(ns, strat);
        CacheEventDC cache = new CacheEventDC(retry);
        return cache;
    }

    public static ProxySeismogramDC vestSeismogramDC(String serverDNS, String serverName, FissuresNamingService fisName) {
        return BulletproofVestFactory.vestSeismogramDC(serverDNS, serverName, fisName, BulletproofVestFactory.getDefaultNumRetry());
    }

    public static ProxySeismogramDC vestSeismogramDC(String serverDNS, String serverName, FissuresNamingService fisName, int numRetry) {
        return BulletproofVestFactory.vestSeismogramDC(serverDNS, serverName, fisName, new ClassicRetryStrategy(numRetry));
    }

    public static ProxySeismogramDC vestSeismogramDC(String serverDNS, String serverName, FissuresNamingService fisName, RetryStrategy strat) {
        NSSeismogramDC ns = new NSSeismogramDC(serverDNS, serverName, fisName);
        RetrySeismogramDC retryDC = new RetrySeismogramDC(ns, strat);
        return retryDC;
    }

    public static ProxyPlottableDC vestPlottableDC(String serverDNS, String serverName, FissuresNamingService fisName) {
        return BulletproofVestFactory.vestPlottableDC(serverDNS, serverName, fisName, BulletproofVestFactory.getDefaultNumRetry());
    }

    public static ProxyPlottableDC vestPlottableDC(String serverDNS, String serverName, FissuresNamingService fisName, int numRetry) {
        return BulletproofVestFactory.vestPlottableDC(serverDNS, serverName, fisName, new ClassicRetryStrategy(numRetry));
    }

    public static ProxyPlottableDC vestPlottableDC(String serverDNS, String serverName, FissuresNamingService fisName, RetryStrategy strat) {
        NSPlottableDC ns = new NSPlottableDC(serverDNS, serverName, fisName);
        RetryPlottableDC retry = new RetryPlottableDC(ns, strat);
        CachePlottableDC cache = new CachePlottableDC(retry);
        return cache;
    }

    public static int getDefaultNumRetry() {
        return defaultNumRetry;
    }

    public static void setDefaultNumRetry(int defaultNum) {
        defaultNumRetry = defaultNum;
    }

    public static void retrySleep(int count) {
        if (count > 1) {
            try {
                if (count > 30) {
                    Thread.sleep((defaultTimeoutSeconds + 300) * sleepSeconds * 1000);
                } else if (count > 10) {
                    Thread.sleep((defaultTimeoutSeconds + 10 * count) * sleepSeconds * 1000);
                } else {
                    Thread.sleep(defaultTimeoutSeconds * sleepSeconds * 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

