/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.StatusListener;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractJob
implements Job,
Runnable {
    private boolean finished = false;
    private List listeners = new ArrayList();
    private String status = "Initializing";
    private String name;

    public AbstractJob(String name) {
        this.name = name;
    }

    @Override
    public void run() {
        try {
            this.runJob();
            if (!this.isFinished()) {
                this.setFinished();
            }
        }
        catch (Throwable e) {
            if (!this.isFinished()) {
                this.setFinished();
            }
            GlobalExceptionHandler.handle(e);
        }
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
        this.fireStatusUpdate();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void add(StatusListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void fireStatusUpdate() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((StatusListener)it.next()).statusUpdated(this);
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    protected void setFinished() {
        this.setFinished(true);
    }

    protected void setFinished(boolean finished) {
        this.finished = finished;
        if (finished) {
            this.setStatus("Finished");
        }
        this.fireStatusUpdate();
    }
}

