/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TauPUtil {
    static Map<String, TauPUtil> taupUtilMap = new HashMap<String, TauPUtil>();
    TauP_Time taup_time;
    private static final Logger logger = LoggerFactory.getLogger(TauPUtil.class);

    private TauPUtil(String modelName) throws TauModelException {
        this.taup_time = new TauP_Time(modelName);
    }

    public List<Arrival> calcTravelTimes(Station station, Origin origin, String[] phaseNames) throws TauModelException {
        return this.calcTravelTimes(station.getLocation(), origin, phaseNames);
    }

    public synchronized List<Arrival> calcTravelTimes(Location stationLoc, Origin origin, String[] phaseNames) throws TauModelException {
        QuantityImpl depth = (QuantityImpl)origin.getLocation().depth;
        double depthVal = (depth = depth.convertTo(UnitImpl.KILOMETER)).getValue();
        if (depthVal < 0.0) {
            logger.info("depth negative not allowed, setting to zero");
            depthVal = 0.0;
        }
        DistAz distAz = new DistAz(stationLoc, origin.getLocation());
        return this.calcTravelTimes(distAz.getDelta(), depthVal, phaseNames);
    }

    public synchronized List<Arrival> calcTravelTimes(double distDeg, double depthKm, String[] phaseNames) throws TauModelException {
        this.taup_time.setSourceDepth(depthKm);
        this.taup_time.clearPhaseNames();
        for (int i = 0; i < phaseNames.length; ++i) {
            this.taup_time.appendPhaseName(phaseNames[i]);
        }
        this.taup_time.calculate(distDeg);
        List arrivals = this.taup_time.getArrivals();
        return arrivals;
    }

    public TauModel getTauModel() {
        return this.taup_time.getTauModel();
    }

    public static synchronized TauPUtil getTauPUtil() {
        try {
            return TauPUtil.getTauPUtil("prem");
        }
        catch (TauModelException e) {
            throw new RuntimeException("Should never happen as prem is bundled with TauP", e);
        }
    }

    public static synchronized TauPUtil getTauPUtil(String modelName) throws TauModelException {
        if (!taupUtilMap.containsKey(modelName)) {
            taupUtilMap.put(modelName, new TauPUtil(modelName));
        }
        return taupUtilMap.get(modelName);
    }
}

