/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.network;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;

public class ChannelImpl
extends Channel {
    protected int dbid;

    public ChannelImpl(ChannelId id, String name, Orientation an_orientation, Sampling sampling_info, TimeRange effective_time, Site my_site) {
        this.id = id;
        this.setName(name);
        this.setOrientation(an_orientation);
        this.setSamplingInfo(sampling_info);
        this.setEffectiveTime(effective_time);
        this.setSite(my_site);
    }

    public ChannelImpl(ChannelId id, String name, Orientation an_orientation, Sampling sampling_info, TimeRange effective_time, Site my_site, int dbid) {
        this.id = id;
        this.setName(name);
        this.setOrientation(an_orientation);
        this.setSamplingInfo(sampling_info);
        this.setEffectiveTime(effective_time);
        this.setSite(my_site);
        this.dbid = dbid;
    }

    protected ChannelImpl() {
    }

    public static ChannelImpl createEmpty() {
        return new ChannelImpl();
    }

    public ChannelId get_id() {
        return this.getId();
    }

    public String get_code() {
        return this.getId().channel_code;
    }

    public NetworkAttrImpl getNetworkAttrImpl() {
        return (NetworkAttrImpl)this.getNetworkAttr();
    }

    public StationImpl getStationImpl() {
        return (StationImpl)this.getStation();
    }

    public SiteImpl getSiteImpl() {
        return (SiteImpl)this.getSite();
    }

    public static int getAzimuth(String chanCode) {
        if (chanCode.endsWith("Z") || chanCode.endsWith("N")) {
            return 0;
        }
        if (chanCode.endsWith("E")) {
            return 90;
        }
        return -1;
    }

    public static int getDip(String chanCode) {
        if (chanCode.endsWith("E") || chanCode.endsWith("N")) {
            return 0;
        }
        if (chanCode.endsWith("Z")) {
            return -90;
        }
        return -1;
    }

    protected void setDbid(int dbid) {
        this.dbid = dbid;
    }

    public int getDbid() {
        return this.dbid;
    }

    public void associateInDB(ChannelImpl indb) {
        this.setDbid(indb.getDbid());
    }

    public static ChannelImpl[] implize(Channel[] chan) {
        if (chan instanceof ChannelImpl[]) {
            return (ChannelImpl[])chan;
        }
        ChannelImpl[] out = new ChannelImpl[chan.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (ChannelImpl)chan[i];
        }
        return out;
    }

    public String toString() {
        return ChannelIdUtil.toStringNoDates(this);
    }
}

