/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.MaskFormatter;
import net.sf.nachocalendar.components.ArrowButton;

public class YearScroller
extends JPanel {
    private JButton bNext;
    private JButton bPrevious;
    private JFormattedTextField tYear;
    private transient ArrayList changeListenerList;

    public YearScroller() {
        this.initComponents();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        this.tYear.setValue(new Integer(cal.get(1)));
        Border border = this.tYear.getBorder();
        this.tYear.setBorder(null);
        this.setBorder(border);
    }

    private void initComponents() {
        this.bPrevious = new ArrowButton(7);
        try {
            this.tYear = new JFormattedTextField(new MaskFormatter("####"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bNext = new ArrowButton(3);
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.bPrevious.addActionListener(formListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bPrevious, gridBagConstraints);
        this.tYear.setColumns(4);
        this.tYear.setHorizontalAlignment(0);
        this.tYear.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tYear, gridBagConstraints);
        this.bNext.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bNext, gridBagConstraints);
    }

    private void tYearActionPerformed(ActionEvent evt) {
        this.fireChangeListenerStateChanged(new ChangeEvent(this));
    }

    private void bNextActionPerformed(ActionEvent evt) {
        this.setYear(this.getYear() + 1);
        this.fireChangeListenerStateChanged(new ChangeEvent(this));
    }

    private void bPreviousActionPerformed(ActionEvent evt) {
        this.setYear(this.getYear() - 1);
        this.fireChangeListenerStateChanged(new ChangeEvent(this));
    }

    public void setNextIcon(Icon icon) {
        this.bNext.setIcon(icon);
    }

    public void setPreviousIcon(Icon icon) {
        this.bPrevious.setIcon(icon);
    }

    public void setNextText(String text) {
        this.bNext.setText(text);
    }

    public void setPreviousText(String text) {
        this.bPrevious.setText(text);
    }

    public int getYear() {
        return ((Number)this.tYear.getValue()).intValue();
    }

    public void setYear(int year) {
        if (year > 0 && year < 2100) {
            this.tYear.setValue(new Integer(year));
        }
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList();
        }
        this.changeListenerList.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (this.changeListenerList != null) {
            this.changeListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListenerStateChanged(ChangeEvent event) {
        ArrayList list;
        YearScroller yearScroller = this;
        synchronized (yearScroller) {
            if (this.changeListenerList == null) {
                return;
            }
            list = (ArrayList)this.changeListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    public void setEnabled(boolean b) {
        this.bNext.setEnabled(b);
        this.bPrevious.setEnabled(b);
        this.tYear.setEnabled(b);
    }

    public boolean isEnabled() {
        return this.tYear.isEnabled();
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == YearScroller.this.bPrevious) {
                YearScroller.this.bPreviousActionPerformed(evt);
            } else if (evt.getSource() == YearScroller.this.tYear) {
                YearScroller.this.tYearActionPerformed(evt);
            } else if (evt.getSource() == YearScroller.this.bNext) {
                YearScroller.this.bNextActionPerformed(evt);
            }
        }
    }
}

