/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.io.FileList;
import phelps.io.PrintStreams;

public class Validate {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2003/08/29 04:42:21 $";
    public static final String USAGE = "java tool.pdf.Validate [options] <PDF-file...>\n\t[-fast] [-full] [-dev] [-password <password>]";
    public static final int LEVEL_QUICK = 0;
    public static final int LEVEL_FULL = 1;
    public static final int LEVEL_DEVEL = 2;
    public static final int LEVEL_DEVEL_WARNING = 3;
    public static final int LEVEL_DEVEL_CONTENT = 4;
    private static final String[] ATTRS_PAGES;
    private static final String[] ATTRS_PAGE;
    private static final String[] ATTRS_IMAGE;
    private List<String> errs_ = new ArrayList<String>(10);
    private String password_;
    private boolean frepairok_;
    private int level_;
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private PrintStream out_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Validate() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.frepairok_ = false;
        this.level_ = 2;
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setLevel(int n) {
        if (!($assertionsDisabled || 0 <= n && n <= 4)) {
            throw new AssertionError();
        }
        this.level_ = n;
    }

    public void setRepair(boolean bl) {
        this.frepairok_ = bl;
    }

    public boolean validate(File file) throws IOException {
        if (this.fverbose_) {
            System.out.println(file);
        }
        if (!($assertionsDisabled || file != null && file.exists())) {
            throw new AssertionError();
        }
        this.errs_.clear();
        PDFReader pDFReader = null;
        try {
            pDFReader = new PDFReader(file);
        }
        catch (ParseException parseException) {
            this.err(-1, parseException.toString());
            return false;
        }
        catch (IOException iOException) {
            System.err.println("Can't open " + file);
            throw iOException;
        }
        pDFReader.setExact(true);
        pDFReader.setPassword(this.password_);
        if (!pDFReader.isAuthorized()) {
            System.err.println("invalid password " + file);
            return false;
        }
        Dict dict = pDFReader.getCatalog();
        int n = pDFReader.getObjCnt();
        if (!this.frepairok_ && pDFReader.isRepaired()) {
            return false;
        }
        if (pDFReader.getObjGen(0) != 65535) {
            this.err(0, "generation must be 65535");
        }
        Object object = null;
        if (this.level_ >= 1) {
            pDFReader.fault();
            for (int i = 1; i < n; ++i) {
                try {
                    object = pDFReader.getObject(i);
                    if (COS.CLASS_DICTIONARY != object.getClass() || ((Dict)object).get("DATA") == null) continue;
                    byte[] byArray = pDFReader.getStreamData(new IRef(i, 0), false, false);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.err(i, exception.toString());
                    System.out.println("#" + i + ": " + object);
                    break;
                }
            }
            if (!this.frepairok_ && pDFReader.isRepaired()) {
                return false;
            }
        }
        if (this.errs_.isEmpty() && pDFReader.isRepaired()) {
            this.err(-1, file + " -- invalid but repairable (with tool.pdf.Repair)");
        }
        if (this.errs_.isEmpty() && this.level_ >= 2) {
            this.validateDev(pDFReader);
        }
        pDFReader.close();
        return this.errs_.isEmpty();
    }

    void validateDev(PDFReader pDFReader) throws IOException {
        Object object;
        Object object2;
        int n;
        Dict dict;
        Object object3;
        Dict dict2;
        int n2 = pDFReader.getObjCnt();
        int n3 = pDFReader.getPageCnt();
        if (n3 == 0) {
            this.warn(-1, "No pages");
        }
        if ((dict2 = pDFReader.getTrailer()).get("Root") == null) {
            this.err(-1, "No /Root in trailer");
        }
        if ((object3 = dict2.get("Size")) == null) {
            this.err(-1, "No /Size in trailer");
        } else if (COS.CLASS_INTEGER != object3.getClass()) {
            this.err(-1, "/Size in trailer not direct integer");
        } else {
            int n4 = ((Number)object3).intValue();
            if (n4 != n2) {
                this.err(-1, "Wrong /Size in trailer: " + n4 + " should be " + n2);
            }
        }
        Dict dict3 = pDFReader.getCatalog();
        if (dict3.get("Pages") == null) {
            this.warn(-1, "No /Pages in catalog");
        }
        if ((dict = pDFReader.getInfo()) == null) {
            this.warn(-1, "No /Info with metadata in trailer");
        }
        for (n = 0; n < n3; ++n) {
            object2 = pDFReader.getPageRef(n + 1);
            object = pDFReader.getPage(n + 1);
            this.requiredAttrs(((IRef)object2).id, (Dict)object, ATTRS_PAGE);
        }
        for (n = 0; n < n2; ++n) {
            object3 = pDFReader.getObject(n);
            if (COS.CLASS_DICTIONARY != object3.getClass()) continue;
            object2 = (Dict)object3;
            object = (String)((Dict)object2).get("Type");
            String string = (String)((Dict)object2).get("Subtype");
            if ("Pages".equals(object)) {
                this.requiredAttrs(n, (Dict)object2, ATTRS_PAGES);
                continue;
            }
            if ("Page".equals(object)) {
                if (((Dict)object2).get("Contents") != null) continue;
                this.warn(n, "/Page without /Contents");
                continue;
            }
            if (("XObject".equals(object) || null == object) && "Image".equals(string)) {
                this.requiredAttrs(n, (Dict)object2, ATTRS_IMAGE);
                continue;
            }
            if (("XObject".equals(object) || null == object) && !"Image".equals(string)) continue;
        }
    }

    private void requiredAttrs(int n, Dict dict, String[] stringArray) {
        boolean bl = true;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            if (dict.get(string) != null) continue;
            this.err(n, "missing attr '" + string + "'");
        }
    }

    private void err(int n, String string) {
        this.out_.print("ERROR");
        if (n >= 0) {
            this.out_.print(".  object #" + n);
        }
        this.out_.println(": " + string);
    }

    private void warn(int n, String string) {
        if (this.level_ < 3) {
            return;
        }
        this.out_.print("WARNING.  ");
        if (n >= 0) {
            this.out_.print(" object #" + n);
        }
        this.out_.println(": " + string);
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.level_ = 1;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.equals("-fast") || string.equals("-quick")) {
                this.level_ = 0;
                continue;
            }
            if (string.equals("-full")) {
                this.level_ = 1;
                continue;
            }
            if (string.startsWith("-dev")) {
                this.level_ = 2;
                continue;
            }
            if (string.startsWith("-rep")) {
                this.setRepair(true);
                continue;
            }
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (2 == this.level_ && this.fverbose_) {
            this.level_ = 3;
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Validate validate = new Validate();
        int n = validate.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                validate.validate(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
    }

    static {
        $assertionsDisabled = !Validate.class.desiredAssertionStatus();
        ATTRS_PAGES = new String[]{"Type", "Count", "Kids"};
        ATTRS_PAGE = new String[]{"Type", "Parent", "Resources", "MediaBox"};
        ATTRS_IMAGE = new String[]{"Width", "Height"};
    }
}

