/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Cmd;
import multivalent.std.adaptor.pdf.CryptFilter;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import multivalent.std.adaptor.pdf.SecurityHandler;
import phelps.io.FileList;
import phelps.io.PrintStreams;
import phelps.lang.Integers;

public class Uncompress
implements Observer {
    static final boolean DEBUG = true;
    public static final String VERSION = "2.0 of $Date: 2003/08/29 04:41:49 $";
    public static final String USAGE = "java tool.pdf.Uncompress [-exact] [-password <owner-password>] <PDF-file>";
    private String password_;
    private boolean fexact_;
    private boolean fverbose_;
    private boolean fquiet_;
    private PrintStream out_;
    private PDFReader pdfr_;
    private PDFWriter pdfw_;
    private List<Dict> pagedict_ = null;
    private List<Object> objs_;
    private Set[] objuse_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Uncompress() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.fexact_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void setExact(boolean bl) {
        this.fexact_ = bl;
    }

    public void uncompress(File file, File file2) throws IOException, ParseException {
        Object object;
        if (!$assertionsDisabled && file.equals(file2)) {
            throw new AssertionError();
        }
        PDFReader pDFReader = new PDFReader(file);
        pDFReader.setExact(true);
        if (pDFReader.getTrailer().get("Encrypt") != null) {
            object = pDFReader.getEncrypt().getSecurityHandler();
            ((SecurityHandler)object).authOwner(this.password_);
            if (!((SecurityHandler)object).isAuthorized()) {
                throw new ParseException("owner password required");
            }
            pDFReader.getTrailer().remove("Encrypt");
        }
        object = new PDFWriter(file2, pDFReader);
        ((PDFWriter)object).setExact(this.fexact_);
        ((PDFWriter)object).getTrailer().remove("Compress");
        ((PDFWriter)object).setCompress(false);
        if (!this.fexact_) {
            this.markupPages(pDFReader, (PDFWriter)object);
        }
        this.pdfr_ = pDFReader;
        this.pdfw_ = object;
        ((PDFWriter)object).writePDF(this);
        ((PDFWriter)object).close();
        this.pdfr_ = null;
        this.pdfw_ = null;
        if (!this.fquiet_) {
            this.out_.println(file2 + " is UNCOMPRESSED" + (this.fexact_ ? "" : " and prettyprinted") + " and can be edited");
            this.out_.println("file length " + file.length() + " => " + file2.length());
        }
        pDFReader.close();
    }

    public void update(Observable observable, Object object) {
        Object object2;
        if (this.fexact_) {
            return;
        }
        String string = null;
        int n = this.pagedict_.indexOf(object);
        if (n != -1) {
            string = "page " + (n + 1);
        } else {
            int n2;
            n = this.objs_.indexOf(object);
            if (n >= 1 && (n2 = (object2 = this.objuse_[n]).size()) != 0) {
                if (n2 == 1) {
                    string = "used by page " + object2.iterator().next();
                } else {
                    int[] nArray = new int[n2];
                    int n3 = 0;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        nArray[n3++] = (Integer)iterator.next();
                    }
                    string = "used by pages " + Integers.toRange(nArray);
                }
            }
        }
        if (COS.CLASS_DICTIONARY == object.getClass() && ((Dict)object).get("DATA") != null) {
            try {
                object2 = (Dict)object;
                if (this.pdfr_.getEncrypt().getCryptFilter((Dict)object2) != CryptFilter.IDENTITY) {
                    this.pdfw_.removeFilter((Dict)object2, "Crypt");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string != null) {
            try {
                this.pdfw_.getRAF().write(("% " + string + "\n").getBytes());
            }
            catch (IOException iOException) {
                System.out.println("can't write: " + iOException);
            }
        }
    }

    private void markupPages(PDFReader pDFReader, PDFWriter pDFWriter) throws IOException {
        int n;
        int n2 = pDFReader.getObjCnt();
        this.objs_ = new ArrayList<Object>(n2);
        this.objs_.add(COS.OBJECT_NULL);
        int n3 = pDFReader.getPageCnt();
        this.pagedict_ = new ArrayList<Dict>(n3);
        for (n = 0; n < n3; ++n) {
            this.pagedict_.add((Dict)pDFWriter.getObject(pDFReader.getPageRef(n + 1)));
        }
        this.objuse_ = new Set[n2];
        for (n = 1; n < n2; ++n) {
            this.objs_.add(pDFReader.getObject(n));
            this.objuse_[n] = new LinkedHashSet(5);
        }
        for (n = 0; n < n3; ++n) {
            IRef iRef = pDFReader.getPageRef(n + 1);
            this.pageOwner(n + 1, pDFReader.getObject(iRef), this.objuse_);
            this.prettyprint(iRef, pDFReader, pDFWriter);
        }
    }

    private void pageOwner(int n, Object object, Set[] setArray) {
        block3: {
            Class<?> clazz;
            block4: {
                block2: {
                    clazz = object.getClass();
                    if (COS.CLASS_IREF != clazz) break block2;
                    int n2 = ((IRef)object).id;
                    setArray[n2].add(Integers.getInteger(n));
                    break block3;
                }
                if (COS.CLASS_ARRAY != clazz) break block4;
                Object[] objectArray = (Object[])object;
                int n3 = objectArray.length;
                for (int i = 0; i < n3; ++i) {
                    Object object2 = objectArray[i];
                    this.pageOwner(n, object2, setArray);
                }
                break block3;
            }
            if (COS.CLASS_DICTIONARY != clazz) break block3;
            Iterator iterator = ((Dict)object).values().iterator();
            while (iterator.hasNext()) {
                this.pageOwner(n, iterator.next(), setArray);
            }
        }
    }

    private void prettyprint(Object object, PDFReader pDFReader, PDFWriter pDFWriter) throws IOException {
        Dict dict;
        Object object2;
        Object object3;
        Object[] objectArray;
        Dict dict2 = (Dict)pDFReader.getObject(object);
        Object object4 = pDFWriter.getObject(dict2.get("Contents"));
        if (object4 == null) {
            objectArray = new Object[]{};
        } else if (COS.CLASS_DICTIONARY == object4.getClass()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object4;
        } else {
            objectArray = (Object[])object4;
        }
        Object[] objectArray3 = objectArray;
        int n = objectArray3.length;
        for (int i = 0; i < n; ++i) {
            object3 = (Dict)pDFWriter.getObject(objectArray3[i]);
            try {
                object2 = pDFReader.readCommandArray(object3);
                ((Dict)object3).put("DATA", pDFWriter.writeCommandArray((Cmd[])object2, true));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Dict dict3 = (Dict)pDFReader.getObject(dict2.get("Resources"));
        Dict dict4 = dict = dict3 != null ? (Dict)pDFReader.getObject(dict3.get("XObject")) : null;
        if (dict != null) {
            object3 = dict.values().iterator();
            while (object3.hasNext()) {
                object2 = pDFReader.getObject(object3.next());
                if (COS.CLASS_DICTIONARY != object2.getClass()) continue;
                Dict dict5 = (Dict)object2;
                if (!"Form".equals("Subtype")) continue;
                this.prettyprint(object2, pDFReader, pDFWriter);
            }
        }
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        this.fexact_ = false;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.equals("-password")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.equals("-exact")) {
                this.fexact_ = true;
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        Uncompress uncompress = new Uncompress();
        int n = uncompress.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            String string = file.getPath();
            String string2 = (string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - ".pdf".length()) : string) + "-u.pdf";
            try {
                uncompress.uncompress(file, new File(string2));
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
    }

    static {
        $assertionsDisabled = !Uncompress.class.desiredAssertionStatus();
    }
}

