/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import phelps.io.FileList;
import phelps.io.PrintStreams;
import phelps.lang.Integers;

public class Split {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2003/08/27 19:18:13 $";
    public static final String USAGE = "java tool.pdf.Split [-page <range>] [-password] <PDF-file>";
    static final String[] CAT_ZAP = new String[]{"PageLabels", "Outlines", "Threads", "StructTreeRoot", "SpiderInfo", "OpenAction", "AcroForm"};
    private String range_;
    private String password_;
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private PrintStream out_;

    public Split() {
        this.defaults();
    }

    public void defaults() {
        this.range_ = null;
        this.password_ = null;
        this.out_ = PrintStreams.DEVNULL;
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void setRange(String string) {
        this.range_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public void split(File file) throws IOException, ParseException {
        String string = file.getPath();
        String string2 = (string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - 4) : string) + "-x.pdf";
        this.split(file, new File(string2));
    }

    public void split(File file, File file2) throws IOException, ParseException {
        Dict dict;
        int n;
        Object object;
        if (!this.fquiet_) {
            this.out_.println(file);
        }
        PDFReader pDFReader = new PDFReader(file);
        pDFReader.setPassword(this.password_);
        PDFWriter pDFWriter = new PDFWriter(file2, pDFReader);
        pDFWriter.setPassword(this.password_);
        int[] nArray = Integers.parseRange(this.range_, pDFReader.getPageCnt());
        int n2 = pDFReader.getPageCnt();
        ArrayList<IRef> arrayList = new ArrayList<IRef>(n2);
        boolean[] blArray = new boolean[n2 + 1];
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i];
            if (n4 < 1 || n4 > n2) continue;
            object = pDFReader.getPageRef(n4);
            Dict dict2 = pDFReader.getPage(n4);
            if (!blArray[n4]) {
                dict2 = (Dict)pDFWriter.getObject(object);
                blArray[n4] = true;
            } else {
                n = pDFWriter.addObject(new Dict(dict2));
                if (this.fmonitor_) {
                    System.out.println(" dup" + nArray[i]);
                }
                object = new IRef(n, 0);
            }
            arrayList.add((IRef)object);
            dict2.remove("B");
        }
        Dict dict3 = pDFWriter.getCatalog();
        for (n3 = 1; n3 <= n2; ++n3) {
            if (blArray[n3]) continue;
            pDFWriter.setObject(pDFReader.getPageRef((int)n3).id, COS.OBJECT_NULL);
        }
        Dict dict4 = (Dict)pDFWriter.getObject(dict3.get("Names"));
        Dict dict5 = dict = dict4 != null ? (Dict)pDFWriter.getObject(dict4.get("Dests")) : null;
        if (dict != null) {
            this.cleanNamedDests(dict, pDFWriter);
        }
        object = CAT_ZAP;
        int n5 = ((String[])object).length;
        for (n = 0; n < n5; ++n) {
            String string = object[n];
            dict3.remove(string);
        }
        pDFWriter.resetPageTree(arrayList);
        pDFWriter.refcntRemove();
        pDFWriter.liftPageTree();
        pDFWriter.writePDF();
        pDFWriter.close();
    }

    private Object cleanNamedDests(Object object, PDFWriter pDFWriter) throws IOException {
        Object object2 = null;
        if (COS.CLASS_DICTIONARY != (object = pDFWriter.getObject(object)).getClass()) {
            return object2;
        }
        Dict dict = (Dict)object;
        if (dict.get("Kids") != null) {
            Object[] objectArray = (Object[])pDFWriter.getObject(dict.get("Kids"));
            int n = 0;
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                if (this.cleanNamedDests(objectArray[i], pDFWriter) != COS.OBJECT_NULL) continue;
                objectArray[i] = COS.OBJECT_NULL;
                ++n;
            }
            if (n == objectArray.length) {
                object2 = COS.OBJECT_NULL;
            } else if (n > 0) {
                Object[] objectArray2 = (Object[])pDFWriter.getObject(dict.get("Limits"));
                int n3 = objectArray.length;
                for (n2 = 0; n2 < n3 && objectArray[n2] == COS.OBJECT_NULL; ++n2) {
                }
                for (n3 = objectArray.length - 1; n3 >= 0 && objectArray[n3] == COS.OBJECT_NULL; --n3) {
                }
                Object[] objectArray3 = new Object[n3 - n2 + 1];
                System.arraycopy(objectArray, n2, objectArray3, 0, n3 - n2 + 1);
                dict.put("Kids", objectArray3);
            }
        } else if (dict.get("Names") != null) {
            Object[] objectArray = (Object[])pDFWriter.getObject(dict.get("Names"));
            int n = 0;
            int n4 = objectArray.length;
            for (int i = 0; i < n4; i += 2) {
                if (this.cleanNamedDests(objectArray[i + 1], pDFWriter) != COS.OBJECT_NULL) continue;
                Object object3 = COS.OBJECT_NULL;
                objectArray[i + 1] = object3;
                objectArray[i] = object3;
                ++n;
            }
            if (n == objectArray.length / 2) {
                object2 = COS.OBJECT_NULL;
            } else if (n > 0) {
                Object[] objectArray4 = (Object[])pDFWriter.getObject(dict.get("Limits"));
                int n5 = objectArray.length;
                for (n4 = 0; n4 < n5 && objectArray[n4 + 1] == COS.OBJECT_NULL; n4 += 2) {
                }
                for (n5 = objectArray.length - 2; n5 >= 0 && objectArray[n5 + 1] == COS.OBJECT_NULL; n5 -= 2) {
                }
                Object[] objectArray5 = new Object[n5 - n4 + 2];
                System.arraycopy(objectArray, n4, objectArray5, 0, n5 - n4 + 2);
                dict.put("Names", objectArray5);
            }
        } else {
            Object[] objectArray;
            Object object4 = dict.get("D");
            if (object4 == null) {
                System.out.println(dict);
            }
            if (object4 != null && COS.CLASS_ARRAY == object4.getClass() && (objectArray = (Object[])object4).length > 0 && COS.CLASS_IREF == objectArray[0].getClass()) {
                object2 = pDFWriter.getObject(objectArray[0]);
            }
        }
        return object2;
    }

    private void cleanLinks() {
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-page") || string.startsWith("-range")) {
                this.setRange(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-pass")) {
                this.setPassword(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fverbose_ = false;
                this.fmonitor_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Split split = new Split();
        int n = split.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                split.split(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }
}

